/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactGroupJoin;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.GroupMemberPermissions;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContactGroupJoinDao
extends OlvidDao<ContactGroupJoin> {
    public ContactGroupJoinDao(ConnectionSource singleConnectionSource) throws SQLException {
        super(singleConnectionSource, ContactGroupJoin.class);
    }

    public List<ContactGroupJoin> getAllContactGroupJoin() {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        this.checkThread();
        try {
            return queryBuilder.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("getAllContactGroupJoin", throwables);
            return null;
        }
    }

    public ContactGroupJoin get(Group group, Contact contact) {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        this.checkThread();
        if (group == null || contact == null || !group.getOwnedIdentityId().equals(contact.getOwnedIdentityId())) {
            AppLogger.e("ContactGroupJoinDao: get(group, contact): invalid params");
            return null;
        }
        try {
            queryBuilder.where().eq(ContactGroupJoin.FK_GROUP, group).and().eq(ContactGroupJoin.FK_CONTACT, contact);
            return (ContactGroupJoin)queryBuilder.queryForFirst();
        }
        catch (SQLException throwables) {
            AppLogger.e("ContactGroupJoinDao: Unable to get", throwables);
            return null;
        }
    }

    public ContactGroupJoin get(OwnedIdentity ownedIdentity, byte[] bytesGroupOwnerAndUid, byte[] bytesContactIdentity) {
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        ObvQueryBuilder groupQB = DbManager.getInstance().getGroupDao().queryBuilder();
        ObvQueryBuilder contactQB = DbManager.getInstance().getContactDao().queryBuilder();
        this.checkThread();
        if (ownedIdentity == null || bytesGroupOwnerAndUid == null || bytesContactIdentity == null) {
            AppLogger.e("ContactGroupJoinDao: get(OwnedIdentity, byte, byte): invalid params");
            return null;
        }
        try {
            groupQB.where().eq(Group.BYTES_GROUP_IDENTIFIER, bytesGroupOwnerAndUid);
            contactQB.where().eq(Contact.BYTES_CONTACT_IDENTITY, bytesContactIdentity).and().eq(Contact.FK_OWNED_IDENTITY, ownedIdentity);
            queryBuilder.join(ContactGroupJoin.FK_GROUP, Group.GEN_ID, groupQB);
            queryBuilder.join(ContactGroupJoin.FK_CONTACT, Contact.GEN_ID, contactQB);
            return (ContactGroupJoin)queryBuilder.queryForFirst();
        }
        catch (SQLException throwables) {
            AppLogger.e("ContactGroupJoinDao: Unable to get", throwables);
            return null;
        }
    }

    public List<ContactGroupJoin> getGroupContactGroupJoin(Group group) {
        ObvQueryBuilder contactGroupJoinLongQb = this.queryBuilder();
        this.checkThread();
        if (group == null) {
            AppLogger.e("getGroupContactGroupJoin:  invalid params");
            return null;
        }
        try {
            contactGroupJoinLongQb.where().eq(ContactGroupJoin.FK_GROUP, group).and().eq(ContactGroupJoin.FK_OWNED_IDENTITY, group.getOwnedIdentityId());
            return contactGroupJoinLongQb.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("Unable to query: getGroupContactGroupJoin", throwables);
            return null;
        }
    }

    public long getContactGroupJoinCount(Id<OwnedIdentity> ownedIdentityId, Id<Group> groupId, byte[] contactBytes) {
        ObvQueryBuilder contactGroupJoinLongQb = this.queryBuilder();
        ObvQueryBuilder contactQB = DbManager.getInstance().getContactDao().queryBuilder();
        this.checkThread();
        if (groupId == null) {
            AppLogger.e("getGroupContactGroupJoin:  invalid params");
            return 0L;
        }
        try {
            contactQB.where().eq(Contact.BYTES_CONTACT_IDENTITY, contactBytes);
            contactGroupJoinLongQb.where().eq(ContactGroupJoin.FK_GROUP, groupId).and().eq(ContactGroupJoin.FK_OWNED_IDENTITY, ownedIdentityId);
            contactGroupJoinLongQb.join(ContactGroupJoin.FK_CONTACT, Contact.GEN_ID, contactQB);
            return contactGroupJoinLongQb.countOf();
        }
        catch (SQLException throwables) {
            AppLogger.e("Unable to query: getGroupContactGroupJoin", throwables);
            return 0L;
        }
    }

    public List<Id<Contact>> getGroupMembersContactIds(Id<Group> group) {
        ObvQueryBuilder contactGroupJoinLongQb = this.queryBuilder();
        this.checkThread();
        if (group == null) {
            AppLogger.e("getGroupMembersContactIds: invalid params");
            return null;
        }
        try {
            contactGroupJoinLongQb.where().eq(ContactGroupJoin.FK_GROUP, group);
            contactGroupJoinLongQb.selectColumns(ContactGroupJoin.FK_CONTACT);
            List contactGroupJoinList = contactGroupJoinLongQb.query();
            if (contactGroupJoinList == null) {
                return null;
            }
            ArrayList<Id<Contact>> contactIds = new ArrayList<Id<Contact>>(contactGroupJoinList.size());
            for (ContactGroupJoin contactGroupJoin : contactGroupJoinList) {
                contactIds.add(contactGroupJoin.getContactId());
            }
            return contactIds;
        }
        catch (SQLException throwables) {
            AppLogger.e("Unable to query: getGroupMembersContactIds", throwables);
            return null;
        }
    }

    public Collection<Discussion> getAllOwnedGroupDiscussionIdsWithSpecificContact(Contact contact) {
        ObvQueryBuilder contactGroupJoinQB = this.queryBuilder();
        ObvQueryBuilder groupQB = DbManager.getInstance().getGroupDao().queryBuilder();
        ObvQueryBuilder discussionQB = DbManager.getInstance().getDiscussionDao().queryBuilder();
        ObvQueryBuilder groupMemberPermissionsQB = DbManager.getInstance().getGroupMemberPermissionsDao().queryBuilder();
        this.checkThread();
        if (contact == null) {
            AppLogger.e("getAllOwnedGroupDiscussionIdsWithSpecificContact: invalid params");
            return null;
        }
        try {
            groupMemberPermissionsQB.where().eq(GroupMemberPermissions.ADMIN, false).and().isNotNull(GroupMemberPermissions.FK_CONTACT_GROUP_JOIN);
            contactGroupJoinQB.join(ContactGroupJoin.GEN_ID, GroupMemberPermissions.FK_CONTACT_GROUP_JOIN, groupMemberPermissionsQB);
            contactGroupJoinQB.where().eq(ContactGroupJoin.FK_CONTACT, contact);
            contactGroupJoinQB.selectColumns(ContactGroupJoin.FK_GROUP);
            List contactGroupJoinList = contactGroupJoinQB.query();
            if (contactGroupJoinList == null) {
                return null;
            }
            ArrayList groupsId = new ArrayList(contactGroupJoinList.size());
            for (ContactGroupJoin contactGroupJoin : contactGroupJoinList) {
                groupsId.add(contactGroupJoin.getGroupId());
            }
            discussionQB.where().in(Discussion.FK_GROUP, groupsId);
            return discussionQB.query();
        }
        catch (SQLException throwables) {
            AppLogger.e("Unable to query: getGroupMembersContacts", throwables);
            return null;
        }
    }
}

