/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvUpdateBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidDao;
import io.olvid.windows.messenger.database.dao.common.gen.Column;
import io.olvid.windows.messenger.database.tables.Capabilities;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;

public class CapabilitiesDao
extends OlvidDao<Capabilities> {
    public CapabilitiesDao(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, Capabilities.class);
    }

    private void updateCapability(Id<Capabilities> capabilitiesId, Column.booleanColumn<Capabilities> column, boolean capable) {
        ObvUpdateBuilder<Capabilities> updateBuilder = this.updateBuilder();
        this.checkThread();
        try {
            updateBuilder.where().eq(Capabilities.GEN_ID, capabilitiesId);
            updateBuilder.updateColumnValue(column, capable);
            updateBuilder.update();
        }
        catch (SQLException e) {
            AppLogger.e(String.format("updateCapability: Unable to update %s:", column), e);
        }
    }

    private void updateCapability(OwnedIdentity ownedIdentity, Column.booleanColumn<Capabilities> column, boolean capable) {
        if (ownedIdentity == null) {
            this.logger.error(String.format("Invalid parameters: updateCapability %s", column));
            return;
        }
        this.updateCapability(ownedIdentity.getCapabilitiesId(), column, capable);
    }

    public void updateWebrtcContinuousIce(OwnedIdentity ownedIdentity, boolean capable) {
        this.updateCapability(ownedIdentity, (Column.booleanColumn<Capabilities>)Capabilities.WEBRTC_CONTINUOUS_ICE, capable);
    }

    public void updateOneToOneContacts(OwnedIdentity ownedIdentity, boolean capable) {
        this.updateCapability(ownedIdentity, (Column.booleanColumn<Capabilities>)Capabilities.ONE_TO_ONE_CONTACTS, capable);
    }

    public void updateGroupsV2(OwnedIdentity ownedIdentity, boolean capable) {
        this.updateCapability(ownedIdentity, (Column.booleanColumn<Capabilities>)Capabilities.GROUPS_V2, capable);
    }

    private void updateCapability(Contact contact, Column.booleanColumn<Capabilities> column, boolean capable) {
        if (contact == null) {
            this.logger.error(String.format("Invalid parameters: updateCapability %s", column));
            return;
        }
        this.updateCapability(contact.getCapabilitiesId(), column, capable);
    }

    public void updateWebrtcContinuousIce(Contact contact, boolean capable) {
        this.updateCapability(contact, (Column.booleanColumn<Capabilities>)Capabilities.WEBRTC_CONTINUOUS_ICE, capable);
    }

    public void updateOneToOneContacts(Contact contact, boolean capable) {
        this.updateCapability(contact, (Column.booleanColumn<Capabilities>)Capabilities.ONE_TO_ONE_CONTACTS, capable);
    }

    public void updateGroupsV2(Contact contact, boolean capable) {
        this.updateCapability(contact, (Column.booleanColumn<Capabilities>)Capabilities.GROUPS_V2, capable);
    }
}

