/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.database.dao;

import com.j256.ormlite.support.ConnectionSource;
import io.olvid.windows.messenger.database.dao.common.ObvQueryBuilder;
import io.olvid.windows.messenger.database.dao.common.OlvidAbstractDao;
import io.olvid.windows.messenger.database.management.gen.AppSchemaVersion;
import io.olvid.windows.messenger.database.tables.AppDbSchemaVersion;
import io.olvid.windows.messenger.database.tables.gen.AppDbSchemaVersionGenerated;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;

public class AppDbSchemaVersionDao
extends OlvidAbstractDao<AppDbSchemaVersion> {
    public AppDbSchemaVersionDao(ConnectionSource connectionSource) throws SQLException {
        super(connectionSource, AppDbSchemaVersion.class);
    }

    private Optional<AppDbSchemaVersion> getCurrentAppDbSchemaVersion() throws SQLException {
        this.checkThread();
        ObvQueryBuilder queryBuilder = this.queryBuilder();
        queryBuilder.orderBy(AppDbSchemaVersion.VERSION, false);
        List versions = queryBuilder.query();
        if (versions.isEmpty()) {
            return Optional.empty();
        }
        AppDbSchemaVersion last = (AppDbSchemaVersion)versions.getFirst();
        if (versions.size() > 1) {
            this.logger.warning("Found %d appDbSchemaVersions", versions.size());
            for (AppDbSchemaVersion version : versions.subList(1, versions.size())) {
                if (this.delete(version) != 1) {
                    throw new SQLException("Cannot clean version: " + String.valueOf((Object)version.getVersion()));
                }
                this.logger.debug("Cleaned version: " + String.valueOf((Object)version.getVersion()));
            }
        }
        return Optional.of(last);
    }

    public Optional<AppSchemaVersion> getCurrentVersion() throws SQLException {
        return this.getCurrentAppDbSchemaVersion().map(AppDbSchemaVersionGenerated::getVersion);
    }

    public void updateAppDbSchemaVersion(AppSchemaVersion version) throws SQLException {
        AppDbSchemaVersion appDbSchemaVersion;
        Optional<AppDbSchemaVersion> appDbSchemaVersionOpt = this.getCurrentAppDbSchemaVersion();
        if (appDbSchemaVersionOpt.isPresent() && this.delete(appDbSchemaVersion = appDbSchemaVersionOpt.get()) != 1) {
            throw new SQLException("Unable to delete current appDbSchemaVersion");
        }
        appDbSchemaVersion = new AppDbSchemaVersion(version);
        this.insert(appDbSchemaVersion);
    }
}

