/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.configuration;

import io.olvid.windows.messenger.configuration.AbstractConfiguration;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.util.UUID;

public class EngineConfiguration
extends AbstractConfiguration {
    private static final String CONFIG_FILE_NAME = "configuration/engine.properties";
    private static final String API_KEY_KEY = "engine.apiKey";
    private static final String SERVER_NAME_KEY = "engine.serverName";
    private static final String PROD_SERVER_NAME_KEY = "engine.prodServerName";
    private static EngineConfiguration configurationInstance = new EngineConfiguration();

    EngineConfiguration() {
        super(CONFIG_FILE_NAME);
    }

    public static synchronized EngineConfiguration getInstance() {
        if (configurationInstance == null) {
            configurationInstance = new EngineConfiguration();
        }
        return configurationInstance;
    }

    public UUID getApiKey() {
        return UUID.fromString(EngineConfiguration.configurationInstance.configurationProperties.getProperty(API_KEY_KEY));
    }

    public String getServerName() {
        if (AppRuntimeHelper.isDevMode) {
            return EngineConfiguration.configurationInstance.configurationProperties.getProperty(SERVER_NAME_KEY);
        }
        return EngineConfiguration.configurationInstance.configurationProperties.getProperty(PROD_SERVER_NAME_KEY);
    }

    @Override
    AbstractConfiguration.ConfigurationLocation getLocation() {
        return AbstractConfiguration.ConfigurationLocation.EMBEDDED;
    }
}

