/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.configuration;

import io.olvid.windows.messenger.configuration.AbstractConfiguration;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.text.MessageFormat;

public class AppDatabaseConfiguration
extends AbstractConfiguration {
    public static final String CONFIG_FILE_NAME = "configuration/app_database.properties";
    private static final String DB_URL_KEY = "database.url";
    private static final String DATA_DIR_REGISTRY_KEY = "data.dir.registry.key";
    private static AppDatabaseConfiguration instance;

    private AppDatabaseConfiguration(String configFileName) {
        super(configFileName);
    }

    public static synchronized AppDatabaseConfiguration getInstance() {
        if (instance == null) {
            instance = new AppDatabaseConfiguration(CONFIG_FILE_NAME);
        }
        return instance;
    }

    public String getDbURL() {
        return MessageFormat.format(this.configurationProperties.getProperty(DB_URL_KEY), AppRuntimeHelper.OLVID_DATA_DIR_ABSOLUTE_PATH);
    }

    public String getDataDirRegistryKey() {
        return this.configurationProperties.getProperty(DATA_DIR_REGISTRY_KEY);
    }

    @Override
    AbstractConfiguration.ConfigurationLocation getLocation() {
        return AbstractConfiguration.ConfigurationLocation.EMBEDDED;
    }
}

