/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.start_up;

import io.olvid.windows.messenger.FXApp;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.fx.notifications.NotificationCenter;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.io.IOUtils;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.TcpServerNC;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import javafx.application.Application;

public class Launcher {
    static FileLock longTermLock;
    static OpenOption[] rwOpt;

    public static void main(String[] args) {
        AppRuntimeHelper.initializeStaticConstants();
        AppLogger appLogger = new AppLogger(Launcher.class);
        File portFile = new File(AppRuntimeHelper.OLVID_DATA_DIR_ABSOLUTE_PATH + File.separator + "port");
        boolean startNeeded = true;
        String keycloakArg = null;
        TcpServerNC.TcpMessageNotificationEnumType argType = TcpServerNC.TcpMessageNotificationEnumType.UNKNOWN;
        if (args.length == 0) {
            argType = TcpServerNC.TcpMessageNotificationEnumType.NONE;
        } else if (args.length == 1) {
            if ("--background".equals(args[0])) {
                argType = TcpServerNC.TcpMessageNotificationEnumType.NONE;
            } else {
                keycloakArg = args[0];
                argType = AppRuntimeHelper.getArgType(keycloakArg);
            }
        }
        appLogger.info("ARGTYPE  --> " + String.valueOf(argType));
        if (!portFile.exists()) {
            appLogger.debug("Launcher::main() port file doesn't exist");
            portFile = IOUtils.createFileIfNotExist(portFile);
            if (portFile != null) {
                try {
                    FileChannel fc = FileChannel.open(portFile.toPath(), rwOpt);
                    FileLock fileLock = fc.tryLock(0L, Long.MAX_VALUE, false);
                    if (fileLock != null) {
                        if (!AppRuntimeHelper.initiateTcpServerAndSavePort(fc)) {
                            appLogger.warning("Couldn't start tcp server.....");
                        }
                        fileLock.close();
                    }
                    if ((longTermLock = fc.tryLock(0L, Long.MAX_VALUE, true)) == null) {
                        throw new IOException("can't get Long term lock");
                    }
                }
                catch (IOException ioException) {
                    AppLogger.e("Can't open newly created file...this is bad", ioException);
                    return;
                }
            }
        } else {
            appLogger.info("Launcher::main() PORT FILE EXISTS");
            startNeeded = Launcher.readPortAndWriteArgsToSocket(portFile, keycloakArg, argType);
        }
        appLogger.info("CHECK IF WE NEED TO START UI startNeeded  --> " + startNeeded);
        if (startNeeded) {
            appLogger.info("Starting UI....");
            String[] appArgs = argType == TcpServerNC.TcpMessageNotificationEnumType.UNKNOWN ? AppRuntimeHelper.removeElementFromArray(args, keycloakArg) : args;
            Application.launch(FXApp.class, (String[])appArgs);
            Launcher.stopSequence();
        }
        System.exit(0);
    }

    private static void stopSequence() {
        AppLogger.i("Start stop sequence");
        AppRuntimeHelper.closeBackgroundComponents();
        if (NCRegistry.getTCPServerNC() != null) {
            NCRegistry.getTCPServerNC().stopCenter();
            AppLogger.i("Stopped TCP Server");
        }
        EngineWrapper.getInstance().clearEngine();
        DbManager.clearConnections();
        KeycloakManager.stop();
        AsyncTaskExecutor.shutdownNow();
        NotificationCenter.getInstance().removeTrayIcon();
        AppLogger.i("Stopped UI background services");
    }

    private static boolean readPortAndWriteArgsToSocket(File portFile, String keycloakArg, TcpServerNC.TcpMessageNotificationEnumType argType) {
        boolean startNeeded = false;
        try {
            FileChannel fc = FileChannel.open(portFile.toPath(), rwOpt);
            FileLock fileLock = fc.tryLock(0L, Long.MAX_VALUE, false);
            if (fileLock == null) {
                fileLock = fc.tryLock(0L, Long.MAX_VALUE, true);
                if (fileLock != null) {
                    byte[] portBytes = new byte[2];
                    if (IOUtils.bulletProofRead(fc, portBytes, 0, portBytes.length) != portBytes.length) {
                        throw new IOException("Something went wrong reading port file");
                    }
                    ByteBuffer byteBuffer = ByteBuffer.wrap(portBytes);
                    fileLock.close();
                    TcpServerNC.TcpMessage message = null;
                    switch (argType) {
                        case NONE: {
                            message = new TcpServerNC.TcpMessage(argType.messageId);
                            break;
                        }
                        case KEYCLOAK_CONFIGURATION_URI: 
                        case KEYCLOAK_AUTHENTICATION_REDIRECT_URI: {
                            message = new TcpServerNC.TcpMessage(argType.messageId, keycloakArg);
                            break;
                        }
                    }
                    if (message != null && AppRuntimeHelper.writeArgToClientSocket(byteBuffer.getShort(), message)) {
                        AppLogger.w("Launcher::readPortAndWriteArgsToSocket Couldn't write arg with tcp client...");
                    }
                }
            } else {
                AppLogger.w("Launcher::readPortAndWriteArgsToSocket Application is not running... start up needed....");
                if (AppRuntimeHelper.initiateTcpServerAndSavePort(fc)) {
                    fileLock.close();
                    longTermLock = fc.tryLock(0L, Long.MAX_VALUE, true);
                    startNeeded = true;
                } else {
                    AppLogger.w("Couldn't start tcp server...");
                }
            }
        }
        catch (IOException ioException) {
            AppLogger.e("Couldn't create port file accessor even though it exists...this is bad", ioException);
        }
        return startNeeded;
    }

    static {
        rwOpt = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE};
    }
}

