/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc.state_pattern;

import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.state_pattern.IFlow;
import io.olvid.windows.messenger.misc.state_pattern.IFlowState;
import io.olvid.windows.messenger.misc.state_pattern.StackContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;

public class FlowStackContext<F extends IFlow<F>> {
    protected final LinkedList<F> flowHistory = new LinkedList();
    protected final Map<F, StackContext<IFlowState<F, ?>>> contextMap = new HashMap();
    private final MutableLiveData<State<F>> currentSubFlowStateLiveData = new MutableLiveData();

    private void checkTransition(IFlowState<F, ?> current, IFlowState<F, ?> nextState) {
        if (current.equals(nextState) || !current.getNextSteps().contains(Either.right(nextState))) {
            throw new IllegalStateException();
        }
    }

    private void checkTransition(IFlowState<F, ?> current, F nextFlow) {
        if (!current.getNextSteps().contains(Either.left(nextFlow))) {
            throw new IllegalStateException();
        }
    }

    private void checkState(F flow, IFlowState<F, ?> nextState) {
        if (!flow.getStates().contains(nextState)) {
            throw new IllegalStateException();
        }
    }

    private void newFlow(F flow, IFlowState<F, ?> state) {
        this.checkState(flow, state);
        this.flowHistory.add(flow);
        StackContext context = new StackContext();
        this.contextMap.put(flow, context);
        context.pushState(state);
    }

    public synchronized void pushState(F flow, IFlowState<F, ?> state) {
        Objects.requireNonNull(flow);
        Objects.requireNonNull(state);
        if (this.flowHistory.isEmpty()) {
            this.newFlow(flow, state);
        } else {
            F currentFlow = this.getCurrentFlow();
            IFlowState<F, ?> currentState = this.getCurrentState();
            if (currentFlow.equals(flow)) {
                this.checkTransition(currentState, (F)state);
                this.getCurrentContext().pushState(state);
            } else {
                this.checkTransition(currentState, flow);
                this.newFlow(flow, state);
            }
        }
        this.currentSubFlowStateLiveData.postValue(new State<F>(flow, state));
    }

    public synchronized boolean goToPreviousState() {
        StackContext<IFlowState<F, ?>> context = this.getCurrentContext();
        IFlowState state = (IFlowState)context.getCurrentState();
        if (state == null || !state.hasPrevious()) {
            return false;
        }
        if (context.getStackSize() == 0) {
            if (this.flowHistory.size() == 1) {
                return false;
            }
            IFlow flow = (IFlow)this.flowHistory.pollLast();
            this.contextMap.remove(flow);
        } else if (!context.goToPreviousState()) {
            throw new IllegalStateException("Cannot go to previous state");
        }
        this.currentSubFlowStateLiveData.postValue(new State<F>(this.getCurrentFlow(), this.getCurrentState()));
        return true;
    }

    public int getCurrentPosition() {
        int position = 0;
        for (StackContext<IFlowState<F, ?>> context : this.contextMap.values()) {
            position += context.getStackSize() + 1;
        }
        return position - 1;
    }

    public synchronized int getMaxRemainingSteps() {
        StackContext<IFlowState<F, ?>> flowStackContext = this.contextMap.get(this.getCurrentFlow());
        ArrayList list = new ArrayList();
        for (IFlowState fiFlowState : flowStackContext.statesHistory) {
            list.add(Either.right(fiFlowState));
        }
        for (IFlow iFlow : this.flowHistory) {
            list.add(Either.left(iFlow));
        }
        return this.getCurrentState().getMaxRemainingSteps(list);
    }

    public LiveData<State<F>> getCurrentStateLiveData() {
        return this.currentSubFlowStateLiveData;
    }

    public synchronized void clearContext() {
        this.flowHistory.clear();
        this.contextMap.clear();
        this.currentSubFlowStateLiveData.postValue(null);
    }

    public synchronized F getCurrentFlow() {
        return (F)((IFlow)this.flowHistory.getLast());
    }

    private synchronized StackContext<IFlowState<F, ?>> getCurrentContext() {
        F currentFlow = this.getCurrentFlow();
        return this.contextMap.get(currentFlow);
    }

    public synchronized IFlowState<F, ?> getCurrentState() {
        return (IFlowState)this.getCurrentContext().getCurrentState();
    }

    public record State<F extends IFlow<F>>(F flow, IFlowState<F, ?> state) {
    }
}

