/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc.notification_pattern.notification_centers;

import io.olvid.engine.encoder.Encoded;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.engine.api.TransferApi;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationType;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.OwnedIdentitySyncingNotification;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.keycloak.KeycloakAuthenticationRequiredNotification;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.keycloak.KeycloakDetailsSignatureUpdatedNotification;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.keycloak.KeycloakIdentityReplacementNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.AbstractNotificationCenter;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import java.util.UUID;

public class UtilityNC
extends AbstractNotificationCenter {
    private static final String UTILITY_NOTIFIER_THREAD_NAME = "App-UtilityNotifier";

    public UtilityNC() {
        super(UTILITY_NOTIFIER_THREAD_NAME);
    }

    public static void fireIdentityTransfertStepNotification(TransferApi.Step step, UUID uuid, byte[] bytesOwnedIdentity, Encoded encodedElements) {
        NCRegistry.getUtilityNC().postNotification(new TransferNotification(step, uuid, bytesOwnedIdentity, encodedElements));
    }

    public static void fireNewerVersionDetectedNotification(int latest, int minVersion, boolean updated) {
        NCRegistry.getUtilityNC().postNotification(new NewerVersionDetectedNotification(latest, minVersion, updated));
    }

    public static void fireAuthenticationRequiredNotification(byte[] ownedIdentity) {
        NCRegistry.getUtilityNC().postNotification(new KeycloakAuthenticationRequiredNotification(ownedIdentity));
    }

    public static void fireKeycloakIdentityReplacementNotification(byte[] ownedIdentity, boolean revocationAllowed) {
        NCRegistry.getUtilityNC().postNotification(KeycloakIdentityReplacementNotification.of(ownedIdentity, revocationAllowed));
    }

    public static void fireKeycloakDetailsSignatureKeyUpdated(byte[] ownedIdentity) {
        NCRegistry.getUtilityNC().postNotification(KeycloakDetailsSignatureUpdatedNotification.of(ownedIdentity));
    }

    public static void fireOwnedIdentitySyncingNotification(Id<OwnedIdentity> ownedIdentity, OwnedIdentitySyncingNotification.SyncingNotificationState manualSyncInProgress, OwnedIdentitySyncingNotification.SyncingNotificationState initialSyncInProgress) {
        NCRegistry.getUtilityNC().postNotification(OwnedIdentitySyncingNotification.of(ownedIdentity, manualSyncInProgress, initialSyncInProgress));
    }

    public record TransferNotification(TransferApi.Step step, UUID uuid, byte[] bytesOwnedIdentity, Encoded encodedElements) implements NotificationType
    {
        @Override
        public NotificationType.NotificationEnumType getNotificationType() {
            return UtilityNotificationEnumType.IDENTITY_TRANSFERT_STEP;
        }
    }

    public record NewerVersionDetectedNotification(int latest, int minVersion, boolean updated) implements NotificationType
    {
        @Override
        public NotificationType.NotificationEnumType getNotificationType() {
            return UtilityNotificationEnumType.VERSION_DETECTED;
        }
    }

    public static enum UtilityNotificationEnumType implements NotificationType.NotificationEnumType
    {
        KEYCLOAK_AUTHENTICATION_REQUIRED,
        FORCE_SCHEDULE_NEXT_EXPIRATION_HANDLING_TASK,
        SCHEDULE_MUTE_NOTIFICATION,
        SHARE_CURRENT_DISCUSSION_FOR_NEXT_EXPIRATION_HANDLING_TASK,
        KEYCLOAK_SIGNATURE_KEY_UPDATED,
        KEYCLOAK_IDENTITY_REPLACEMENT,
        IDENTITY_TRANSFERT_STEP,
        CANCEL_DRAFT_ATTACHMENT_LOADING,
        VERSION_DETECTED,
        OWNED_IDENTITY_SYNCING;

    }
}

