/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc.notification_pattern.notification_centers;

import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.AbstractNotificationCenter;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.TcpServerNC;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UIActionNC;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UtilityNC;
import java.util.EnumMap;

public class NCRegistry {
    private static final EnumMap<NCTypes, AbstractNotificationCenter> registry = new EnumMap(NCTypes.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerNotificationCenter(NCTypes type) {
        if (type != null) {
            AppLogger.d("NCRegistry::registerNotificationCenter type : " + type.name());
            EnumMap<NCTypes, AbstractNotificationCenter> enumMap = registry;
            synchronized (enumMap) {
                if (!registry.containsKey((Object)type)) {
                    try {
                        registry.put(type, NCRegistry.buildInstance(type));
                    }
                    catch (Exception e) {
                        AppLogger.e("NCRegistry::registerNotificationCenter Couldn't create instance of NC type : " + type.name(), e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractNotificationCenter getInstance(NCTypes type) {
        AppLogger.t("NCRegistry::getInstance type : " + String.valueOf((Object)type));
        EnumMap<NCTypes, AbstractNotificationCenter> enumMap = registry;
        synchronized (enumMap) {
            if (registry.containsKey((Object)type)) {
                return registry.get((Object)type);
            }
        }
        return null;
    }

    public static UIActionNC getUIActionNC() {
        AppLogger.t("NCRegistry::getUIActionNC");
        return (UIActionNC)NCRegistry.getInstance(NCTypes.UI_ACTION_NC);
    }

    public static TcpServerNC getTCPServerNC() {
        AppLogger.t("NCRegistry::getTCPServerNC");
        return (TcpServerNC)NCRegistry.getInstance(NCTypes.TCP_SERVER_NC);
    }

    public static UtilityNC getUtilityNC() {
        AppLogger.t("NCRegistry::getUtilityNC");
        return (UtilityNC)NCRegistry.getInstance(NCTypes.UTILITY_NC);
    }

    private static AbstractNotificationCenter buildInstance(NCTypes type) {
        switch (type.ordinal()) {
            case 0: {
                AppLogger.d("NCRegistry::buildInstance building : " + String.valueOf((Object)type));
                return new UIActionNC();
            }
            case 1: {
                AppLogger.d("NCRegistry::buildInstance building : " + String.valueOf((Object)type));
                return new TcpServerNC();
            }
            case 2: {
                AppLogger.d("NCRegistry::buildInstance building : " + String.valueOf((Object)type));
                return new UtilityNC();
            }
        }
        AppLogger.w("NCRegistry::buildInstance not handling type : " + String.valueOf((Object)type));
        return null;
    }

    public static enum NCTypes {
        UI_ACTION_NC,
        TCP_SERVER_NC,
        UTILITY_NC;

    }
}

