/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc.network.tcp;

import io.olvid.windows.messenger.logger.AppLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;

public class TcpServer {
    public static final String SINGLE_CHANNEL_TCP_SERVER_THREAD_NAME = "App-TcpServerThread";
    public static final String LOCALHOST = "127.0.0.1";
    private ServerSocket serverSocket;
    private final Thread serverLoopRunner = new Thread(this::serverLoop, "App-TcpServerThread");
    private final Consumer<byte[]> onMessageReceivedCallBack;
    private final AppLogger logger = new AppLogger(this.getClass());
    static final int DEFAULT_INITIAL_PORT = 7000;
    static final int DEFAULT_PORT_RANGE = 1000;
    static final int MAX_READ_BYTE_SIZE = 10000;

    public TcpServer(Consumer<byte[]> onMessageReceivedCallBack) {
        this.onMessageReceivedCallBack = onMessageReceivedCallBack;
    }

    public boolean bindServerSocket() {
        return this.defaultBind();
    }

    public boolean bindServerSocket(int firstPort, int rangeToTest) {
        this.logger.debug("TcpServer::bindServerSocket");
        boolean ret = false;
        try {
            ServerSocket socket = new ServerSocket();
            int maxPort = firstPort + rangeToTest - 1;
            for (int i = firstPort; i <= maxPort; ++i) {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(LOCALHOST, i);
                try {
                    socket.bind(inetSocketAddress);
                }
                catch (BindException bindException) {
                    continue;
                }
                if (socket.getLocalPort() == -1) continue;
                this.serverSocket = socket;
                ret = true;
                break;
            }
            if (this.serverSocket == null) {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(LOCALHOST, 0);
                socket.bind(inetSocketAddress);
                if (socket.getLocalPort() != -1) {
                    this.serverSocket = socket;
                }
            }
            if (socket.getLocalPort() == -1) {
                this.logger.error("TcpServer::bindServerSocket Couldn't bind to a port....");
            }
        }
        catch (IOException ioException) {
            this.logger.error("TcpServer::bindServerSocket Couldn't start tcp server" + String.valueOf(ioException));
        }
        return ret;
    }

    public int getPort() {
        this.logger.debug("TcpServer::getPort");
        return this.serverSocket != null ? this.serverSocket.getLocalPort() : -1;
    }

    public void stopServer() {
        this.logger.debug("TcpServer::stopServer stopping server");
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean startServer() {
        boolean status = true;
        if (this.serverSocket == null) {
            status = this.defaultBind();
        }
        this.logger.debug("TcpServer::startServer " + this.serverSocket.getLocalPort());
        this.serverLoopRunner.start();
        this.logger.debug("Listening on port " + this.serverSocket.getLocalPort());
        return status;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void serverLoop() {
        this.logger.debug("TcpServer::serverLoop starting loop");
        try {
            while (!this.serverSocket.isClosed()) {
                Socket socket = this.serverSocket.accept();
                try {
                    byte[] readBytes = this.readMessageFromSocket(socket);
                    this.logger.debug("TcpServer::serverLoop received bytes : " + new String(readBytes, StandardCharsets.UTF_8));
                    if (this.onMessageReceivedCallBack == null) continue;
                    this.onMessageReceivedCallBack.accept(readBytes);
                }
                finally {
                    if (socket == null) continue;
                    socket.close();
                }
            }
            return;
        }
        catch (SocketException e) {
            this.logger.error("TcpServer::serverLoop socket might have been closed during the accept blocking call...");
            return;
        }
        catch (IOException e) {
            this.logger.error("TcpServer::serverLoop Something went wrong accepting channel...", e);
        }
    }

    private boolean defaultBind() {
        return this.bindServerSocket(7000, 1000);
    }

    private byte[] readMessageFromSocket(Socket socket) throws IOException {
        byte[] buffer = new byte[1024];
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int c;
            for (int total = 0; (c = socket.getInputStream().read(buffer)) > -1 && total < 10000; total += c) {
                byteArrayOutputStream.write(buffer, 0, c);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }
}

