/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc.network;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.olvid.engine.Logger;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.KnownCertificate;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.logger.AppLogger;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;

public class VerifySSLConnectionCertificatesTask
implements Runnable {
    private static final HashMap<Long, Long> lastUntrustedCertificateNotification = new HashMap();
    private static final long NOTIFICATION_MIN_INTERVAL_MILLIS = 1800000L;
    public static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----\n";
    public static final String END_CERTIFICATE = "-----END CERTIFICATE-----\n";
    private final String domainName;
    private final Certificate[] certificates;

    public VerifySSLConnectionCertificatesTask(String domainName, Certificate[] certificates) {
        this.domainName = domainName;
        this.certificates = certificates;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            if (this.certificates.length == 0 || !(this.certificates[0] instanceof X509Certificate)) {
                AppLogger.w("SSL handshake finished with no certificates or a non-X.509 certificate. Aborting user certificate validation.");
                return;
            }
            List<KnownCertificate> knownCertificates = DbManager.getInstance().getKnownCertificateDao().getAllForDomain(this.domainName);
            if (knownCertificates.size() == 0) {
                this.addCertificatesToDb(true);
                return;
            }
            X509Certificate domainCertificate = (X509Certificate)this.certificates[0];
            byte[] certificateBytes = domainCertificate.getEncoded();
            boolean domainCertificateTrusted = false;
            Object domainCertificateId = null;
            Object lastTrustedCertificateId = null;
            for (KnownCertificate knownCertificate : knownCertificates) {
                if (Arrays.equals(certificateBytes, knownCertificate.getCertificateBytes())) {
                    domainCertificateId = knownCertificate.getItemId();
                    if (knownCertificate.isTrusted()) {
                        domainCertificateTrusted = true;
                        break;
                    }
                    if (lastTrustedCertificateId == null) continue;
                    break;
                }
                if (lastTrustedCertificateId != null || !knownCertificate.isTrusted()) continue;
                lastTrustedCertificateId = knownCertificate.getItemId();
                if (domainCertificateId == null) continue;
                break;
            }
            if (domainCertificateId == null) {
                DbManager.getInstance().getKnownCertificateDao().deleteExpired(this.domainName, System.currentTimeMillis());
                this.addCertificatesToDb(true);
                return;
            }
            if (domainCertificateTrusted) return;
        }
        catch (Exception e) {
            AppLogger.e("VerifySSLConnectionCertificatesTask::run Exception while validating. Aborting user certificate validation.", e);
        }
    }

    private KnownCertificate addCertificatesToDb(boolean autoTrust) {
        try {
            X509Certificate domainCertificate = (X509Certificate)this.certificates[0];
            byte[] certificateBytes = domainCertificate.getEncoded();
            StringBuilder sb = new StringBuilder();
            sb.append(BEGIN_CERTIFICATE);
            sb.append(Base64.getEncoder().encodeToString(domainCertificate.getEncoded()));
            sb.append(END_CERTIFICATE);
            String[] issuers = new String[this.certificates.length - 1];
            for (int i = 0; i < issuers.length; ++i) {
                X509Certificate issuerCertificate = (X509Certificate)this.certificates[i + 1];
                issuers[i] = issuerCertificate.getIssuerDN().getName();
                sb.append(BEGIN_CERTIFICATE);
                sb.append(Base64.getEncoder().encodeToString(issuerCertificate.getEncoded()));
                sb.append(END_CERTIFICATE);
            }
            String issuersString = EngineWrapper.getJsonObjectMapper().writeValueAsString((Object)issuers);
            KnownCertificate newKnownCertificate = new KnownCertificate(this.domainName, certificateBytes, autoTrust ? Long.valueOf(System.currentTimeMillis()) : null, domainCertificate.getNotAfter().getTime(), issuersString, sb.toString());
            return DbManager.getInstance().getKnownCertificateDao().createIfNotExists(newKnownCertificate);
        }
        catch (JsonProcessingException | CertificateEncodingException e) {
            Logger.e((String)"Error storing SSL certificate in DB.");
        }
        catch (Exception e) {
            Logger.e((String)"Unexpected exception while storing SSL certificate in DB");
            e.printStackTrace();
        }
        return null;
    }

    private void notifyUser(long untrustedCertificateId, Long lastTrustedCertificateId) {
        Long lastNotificationTimestamp = lastUntrustedCertificateNotification.get(untrustedCertificateId);
        if (lastNotificationTimestamp == null || lastNotificationTimestamp < System.currentTimeMillis() - 1800000L) {
            lastUntrustedCertificateNotification.put(untrustedCertificateId, System.currentTimeMillis());
        }
    }
}

