/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc.network;

import io.olvid.windows.messenger.logger.AppLogger;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class OuroborosKillerProxySelector
extends ProxySelector {
    private final ProxySelector defaultProxySelector;
    private final HashSet<HostAndPort> alreadySeenProxies;

    public OuroborosKillerProxySelector(ProxySelector defaultProxySelector) {
        Objects.requireNonNull(defaultProxySelector);
        this.defaultProxySelector = defaultProxySelector;
        this.alreadySeenProxies = new HashSet();
    }

    @Override
    public List<Proxy> select(URI uri) {
        HostAndPort uriHostAndPort;
        if (Objects.equals("socket", uri.getScheme()) && this.alreadySeenProxies.contains(uriHostAndPort = new HostAndPort(uri.getHost(), uri.getPort()))) {
            AppLogger.d("Forcing direct connection to proxy: " + String.valueOf(uri));
            return Collections.singletonList(Proxy.NO_PROXY);
        }
        List<Proxy> proxies = this.defaultProxySelector.select(uri);
        for (Proxy proxy : proxies) {
            SocketAddress sa;
            if (proxy.type() == Proxy.Type.DIRECT || !((sa = proxy.address()) instanceof InetSocketAddress) || !this.alreadySeenProxies.add(new HostAndPort(((InetSocketAddress)sa).getHostString(), ((InetSocketAddress)sa).getPort()))) continue;
            AppLogger.d("Storing new seen proxy: " + String.valueOf(proxy));
        }
        return proxies;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        this.defaultProxySelector.connectFailed(uri, sa, ioe);
    }

    private record HostAndPort(String host, int port) {
    }
}

