/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc.io;

import io.olvid.engine.secure_io.SecureFile;
import io.olvid.engine.secure_io.SecureFileInputStream;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.io.ExecutableExtensions;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Optional;

public class IOUtils {
    public static File createFileIfNotExist(File portFile) {
        if (!portFile.exists()) {
            IOUtils.createDir(portFile.getParent());
            try {
                if (portFile.createNewFile()) {
                    return portFile;
                }
            }
            catch (IOException ioException) {
                return null;
            }
        }
        return null;
    }

    public static boolean createDir(String path) {
        File tmpDir = new File(path);
        if (!tmpDir.exists()) {
            AppLogger.d("Creating dir with path : " + path);
            if (!tmpDir.mkdirs()) {
                AppLogger.e("Couldn't create working dirs in file system");
                return false;
            }
            AppLogger.d("Created dir with path : " + path);
        }
        AppLogger.d("Found dir with path : " + path);
        return true;
    }

    public static int bulletProofRead(FileChannel fileAccessor, byte[] buffer, int off, int len) throws IOException {
        int bufferFullness = off;
        while (bufferFullness < off + len) {
            long count = 0L;
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, bufferFullness, len + off - bufferFullness);
            count = fileAccessor.read(byteBuffer);
            if (count < 0L) break;
            bufferFullness = (int)((long)bufferFullness + count);
        }
        return bufferFullness - off;
    }

    public static int bulletProofRead(DataInput fileAccessor, byte[] buff) throws IOException {
        return IOUtils.bulletProofRead(fileAccessor, buff, 0, buff.length);
    }

    public static int bulletProofRead(InputStream fileAccessor, byte[] buff) throws IOException {
        return IOUtils.bulletProofRead(fileAccessor, buff, 0, buff.length);
    }

    static int bulletProofRead(DataInput fileAccessor, byte[] buffer, int off, int len) throws IOException {
        fileAccessor.readFully(buffer, off, len);
        return len;
    }

    public static int bulletProofRead(InputStream fileAccessor, byte[] buffer, int off, int len) throws IOException {
        int bufferFullness;
        int count;
        for (bufferFullness = off; bufferFullness < off + len && (count = fileAccessor.read(buffer, bufferFullness, off + len - bufferFullness)) >= 0; bufferFullness += count) {
        }
        return bufferFullness - off;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean areSameFiles(SecureFile fileOne, SecureFile fileTwo) {
        if (fileOne.length() != fileTwo.length()) {
            return false;
        }
        try (SecureFileInputStream trustedFis = new SecureFileInputStream(fileOne);
             SecureFileInputStream publishedFis = new SecureFileInputStream(fileTwo);){
            byte[] trustedBuffer = new byte[65536];
            byte[] publishedBuffer = new byte[65536];
            do {
                if (IOUtils.bulletProofRead((InputStream)trustedFis, trustedBuffer, 0, trustedBuffer.length) == -1) return true;
                if (IOUtils.bulletProofRead((InputStream)publishedFis, publishedBuffer, 0, trustedBuffer.length) == -1) return true;
            } while (Arrays.equals(trustedBuffer, publishedBuffer));
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            AppLogger.e("IOUtils::compareFiles: couldn't compare files ", e);
            return false;
        }
    }

    public static Optional<String> getExtensionByStringHandling(String filename) {
        return Optional.ofNullable(filename).filter(f -> f.contains(".")).map(f -> f.substring(filename.lastIndexOf(".") + 1));
    }

    public static boolean isWinExecutableFile(String fileName) {
        Optional<String> ext = IOUtils.getExtensionByStringHandling(fileName);
        if (ext.isEmpty()) {
            return false;
        }
        ExecutableExtensions match = Arrays.stream(ExecutableExtensions.values()).filter(e -> e.name().equalsIgnoreCase((String)ext.get())).findAny().orElse(null);
        return match != null;
    }
}

