/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc.cache;

import io.olvid.windows.messenger.logger.AppLogger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class LruCache<K, V> {
    private final long cacheMaxSize;
    private long currentCacheSize;
    private final HashMap<K, V> cacheMap = new HashMap();
    private final LinkedList<K> linkedDeque = new LinkedList();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();

    public LruCache(long cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
        this.currentCacheSize = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        this.writeLock.lock();
        try {
            V ret = this.cacheMap.get(key);
            if (ret != null) {
                this.linkedDeque.remove(key);
                this.linkedDeque.add(key);
            }
            V v = ret;
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(K key, V val) {
        this.writeLock.lock();
        try {
            this.internalPut(key, val);
            boolean bl = true;
            return bl;
        }
        catch (ValueTooLargeException e) {
            AppLogger.e("Cache is empty and trying to put an element with a greater size than cache size limit", e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void internalPut(K key, V val) throws ValueTooLargeException {
        boolean knownEntry = this.cacheMap.containsKey(key);
        if (knownEntry) {
            this.linkedDeque.remove(key);
        }
        long newValueSize = this.getValueSize(val);
        while (this.currentCacheSize + newValueSize > this.cacheMaxSize) {
            K keyToRemove = !knownEntry ? this.linkedDeque.poll() : key;
            if (keyToRemove != null) {
                V removedValue = this.cacheMap.remove(keyToRemove);
                this.currentCacheSize -= this.getValueSize(removedValue);
                continue;
            }
            throw new ValueTooLargeException();
        }
        this.linkedDeque.add(key);
        this.cacheMap.put(key, val);
        this.currentCacheSize += newValueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        if (this.get(key) != null) {
            return true;
        }
        try {
            this.writeLock.lock();
            if (this.get(key) != null) {
                boolean bl = true;
                return bl;
            }
            V value = mappingFunction.apply(key);
            this.internalPut(key, value);
            boolean bl = true;
            return bl;
        }
        catch (ValueTooLargeException e) {
            AppLogger.e("Cache is empty and trying to put an element with a greater size than cache size limit", e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.readLock.lock();
        try {
            this.cacheMap.forEach(action);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        this.writeLock.lock();
        try {
            V ret = this.cacheMap.remove(key);
            if (ret != null) {
                this.currentCacheSize -= this.getValueSize(ret);
                this.linkedDeque.remove(key);
            }
            V v = ret;
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean contains(K key) {
        this.readLock.lock();
        try {
            boolean bl = this.cacheMap.containsKey(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void clear() {
        this.writeLock.lock();
        try {
            this.cacheMap.clear();
            this.currentCacheSize = 0L;
            this.linkedDeque.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public long getValueSize(V value) {
        return 1L;
    }

    public static class ValueTooLargeException
    extends Exception {
    }
}

