/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.misc;

import io.olvid.windows.messenger.fx.misc.EmojiHelper;
import io.olvid.windows.messenger.misc.StringUtils;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;

public final class PositionsMapping {
    private final String input;
    private Map<Integer, Integer> deltas = null;
    private final BitSet gaps;
    private final EnumSet<Kind> kinds;

    public PositionsMapping(String input, EnumSet<Kind> kinds) {
        this.input = input;
        this.gaps = new BitSet(input.length());
        this.kinds = kinds;
    }

    public int getIndex(int pos, boolean start) {
        if (this.deltas == null) {
            this.deltas = new LinkedHashMap<Integer, Integer>();
            this.compute();
        }
        int p = pos;
        if (this.gaps.get(pos)) {
            p = start ? this.gaps.previousClearBit(p) : this.gaps.nextClearBit(p);
        }
        int delta = 0;
        for (int idx : this.deltas.keySet()) {
            if (idx > p) continue;
            delta += this.deltas.get(idx).intValue();
        }
        return p + delta;
    }

    private void compute() {
        if (this.kinds.contains((Object)Kind.EmojiAndNewlines)) {
            Matcher m = StringUtils.LINE_TERMINATOR.matcher(this.input);
            while (m.find()) {
                int start = m.start();
                int end = m.end();
                int len = end - start;
                if (len <= 1) continue;
                this.deltas.put(start + 1, 1 - len);
                this.gaps.set(start + 1, end);
            }
        }
        if (this.kinds.contains((Object)Kind.Normalization)) {
            int cur = 0;
            for (int i = 0; i < this.input.length(); ++i) {
                String ch = this.input.substring(i, i + 1);
                String normalized = StringUtils.normalize(ch);
                int delta = ch.length() - normalized.length();
                if (delta != 0) {
                    this.deltas.put(cur + normalized.length(), delta);
                }
                if (delta < 0) {
                    this.gaps.set(cur + 1, cur + normalized.length());
                }
                cur += normalized.length();
            }
        }
        if (this.kinds.contains((Object)Kind.EmojiAndNewlines)) {
            EmojiHelper.EmojiInfo nextEmoji;
            int cur = 0;
            while (cur < this.input.length() && (nextEmoji = EmojiHelper.getNextEmoji(this.input, cur)) != null) {
                cur = nextEmoji.end();
                if (nextEmoji.length() == 1) continue;
                int start = nextEmoji.start() + 1;
                this.deltas.put(start, 1 - nextEmoji.length());
                this.gaps.set(start, start + nextEmoji.length() - 1);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("deltas: ").append(this.deltas).append(System.lineSeparator());
        builder.append("gaps: ").append(this.gaps);
        return builder.toString();
    }

    public static enum Kind {
        EmojiAndNewlines,
        Normalization;

    }
}

