/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.mediator;

import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.fx.misc.CollectionUtils;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.MediatorLiveData;
import io.olvid.windows.messenger.livedata.mediator.MessageItemLiveData;
import io.olvid.windows.messenger.logger.AppLogger;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;

public abstract class PaginatedLiveData<T extends Table>
extends MediatorLiveData<List<T>> {
    private static final AppLogger logger = new AppLogger(PaginatedLiveData.class);
    private Id<Discussion> discussionId = null;
    private Double minSortIndex = null;
    private Double maxSortIndex = null;
    private List<T> postedValue = List.of();

    public PaginatedLiveData(Class<T> clazz, LiveData<Optional<MessageItemLiveData.SortIndexInfo>> sortIndexInfoLiveData) {
        super(List.of());
        this.addSource(sortIndexInfoLiveData, (sortIndexInfoOpt, oldValue) -> {
            if (sortIndexInfoOpt.isEmpty()) {
                this.postedValue = List.of();
                this.postValue(this.postedValue);
                this.minSortIndex = null;
                this.maxSortIndex = null;
                this.discussionId = null;
                return;
            }
            try {
                List<T> after;
                List<T> before;
                MessageItemLiveData.SortIndexInfo sortIndexInfo = (MessageItemLiveData.SortIndexInfo)sortIndexInfoOpt.get();
                double newMin = sortIndexInfo.min();
                double newMax = sortIndexInfo.max();
                boolean discussionChanged = !sortIndexInfo.discussionId().equals(this.discussionId);
                this.discussionId = sortIndexInfo.discussionId();
                if (discussionChanged || this.minSortIndex == null || this.maxSortIndex == null) {
                    this.minSortIndex = newMin;
                    this.maxSortIndex = newMax;
                    List<T> values = this.fetch(this.discussionId, this.minSortIndex, false, this.maxSortIndex, false);
                    this.postedValue = values;
                    this.postValue(this.postedValue);
                    return;
                }
                List<T> values = this.postedValue;
                boolean modified = false;
                if (newMin < this.minSortIndex && !(before = this.fetch(this.discussionId, newMin, false, this.minSortIndex, true)).isEmpty()) {
                    modified = true;
                    values = CollectionUtils.concat(before, values);
                }
                this.minSortIndex = newMin;
                if (newMax > this.maxSortIndex && !(after = this.fetch(this.discussionId, this.maxSortIndex, true, newMax, false)).isEmpty()) {
                    modified = true;
                    values = CollectionUtils.concat(values, after);
                }
                this.maxSortIndex = newMax;
                if (!modified) {
                    return;
                }
                this.postedValue = values;
                this.postValue(this.postedValue);
            }
            catch (SQLException e) {
                logger.error("Failed to fetch", e);
            }
        });
        this.addSource(LiveDataFactory.buildDbLiveDataList(clazz, () -> {
            if (this.discussionId == null || this.minSortIndex == null || this.maxSortIndex == null) {
                return null;
            }
            try {
                return this.fetch(this.discussionId, this.minSortIndex, false, this.maxSortIndex, false);
            }
            catch (SQLException e) {
                logger.error("Failed to fetch", e);
                return List.of();
            }
        }), (newValue, oldValue) -> {
            if (newValue == null) {
                return;
            }
            this.postValue(newValue);
        });
    }

    protected abstract List<T> fetch(Id<Discussion> var1, double var2, boolean var4, double var5, boolean var7) throws SQLException;
}

