/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.mediator;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.database.tables.message.SystemMessage;
import io.olvid.windows.messenger.fx.discussions.discussion_view.messages.message_list.SortableItemId;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.CollectionUtils;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.MediatorLiveData;
import java.util.List;
import java.util.Optional;

public class MessageIdsLiveData
extends MediatorLiveData<SortableItemIdWithUpdateMode> {
    private final Id<Discussion> discussionId;
    private Optional<Id<InboundMessage>> firstUnreadMessage;
    private List<SortableItemId> inboundMessages;
    private List<SortableItemId> outboundMessages;
    private List<SortableItemId> ownedMessages;
    private List<SortableItemId> systemMessages;
    private List<SortableItemId> messagesIds;
    private boolean addDisclaimer = false;

    public MessageIdsLiveData(Discussion discussion) {
        super(SortableItemIdWithUpdateMode.of(List.of(), UpdateMode.ALL, Optional.empty()));
        this.discussionId = discussion.getItemId();
        this.addDisclaimer = discussion.canPostMessage();
        this.addSource(LiveDataFactory.buildDbLiveDataItemField(() -> DbManager.getInstance().getInboundMessageDao().getSortedMessagesItemIdByDiscussionWithUnreadInfo(this.discussionId), List.of(InboundMessage.class)), (newValue, oldValue) -> {
            this.inboundMessages = newValue.inboundMessageIds();
            this.firstUnreadMessage = newValue.firstUnreadMessage();
            UpdateMode updateMode = oldValue == null ? UpdateMode.ALL : UpdateMode.ONLY_INBOUND;
            this.consolidate(updateMode);
        });
        this.addSource(LiveDataFactory.buildDbLiveDataItemField(() -> DbManager.getInstance().getOutboundMessageDao().getSortedMessagesItemIdByDiscussion(this.discussionId), List.of(OutboundMessage.class)), (newValue, oldValue) -> {
            this.outboundMessages = newValue;
            UpdateMode updateMode = oldValue == null ? UpdateMode.ALL : UpdateMode.ONLY_OUTBOUND;
            this.consolidate(updateMode);
        });
        this.addSource(LiveDataFactory.buildDbLiveDataItemField(() -> DbManager.getInstance().getOwnedMessageDao().getSortedMessagesItemIdByDiscussion(this.discussionId), List.of(OwnedMessage.class)), (newValue, oldValue) -> {
            this.ownedMessages = newValue;
            UpdateMode updateMode = oldValue == null ? UpdateMode.ALL : UpdateMode.ONLY_OWNED;
            this.consolidate(updateMode);
        });
        this.addSource(LiveDataFactory.buildDbLiveDataItemField(() -> DbManager.getInstance().getSystemMessageDao().getSortedMessagesItemIdByDiscussion(this.discussionId), List.of(SystemMessage.class)), (newValue, oldValue) -> {
            this.systemMessages = newValue;
            UpdateMode updateMode = oldValue == null ? UpdateMode.ALL : UpdateMode.ONLY_SYSTEM;
            this.consolidate(updateMode);
        });
    }

    private synchronized void consolidate(UpdateMode updateMode) {
        ViewControllerHelper.checkNotUIThread();
        if (this.inboundMessages == null || this.outboundMessages == null || this.ownedMessages == null || this.systemMessages == null) {
            return;
        }
        List<Object> disclaimerMessages = this.addDisclaimer ? List.of(SortableItemId.ofDisclaimer()) : List.of();
        this.messagesIds = CollectionUtils.kWayMerge(disclaimerMessages, this.inboundMessages, this.outboundMessages, this.ownedMessages, this.systemMessages);
        if (this.messagesIds.isEmpty()) {
            this.postValue(SortableItemIdWithUpdateMode.of(List.of(), updateMode, this.firstUnreadMessage));
            return;
        }
        this.postValue(SortableItemIdWithUpdateMode.of(this.messagesIds, updateMode, this.firstUnreadMessage));
    }

    static enum UpdateMode {
        ALL,
        ONLY_INBOUND,
        ONLY_OUTBOUND,
        ONLY_OWNED,
        ONLY_SYSTEM;


        boolean computeInbound() {
            return this == ALL || this == ONLY_INBOUND;
        }

        boolean computeOutbound() {
            return this == ALL || this == ONLY_OUTBOUND;
        }

        boolean computeOwned() {
            return this == ALL || this == ONLY_OWNED;
        }

        boolean computeSystem() {
            return this == ALL || this == ONLY_SYSTEM;
        }
    }

    record SortableItemIdWithUpdateMode(List<SortableItemId> itemIds, UpdateMode updateMode, Optional<Id<InboundMessage>> firstUnreadMessageId) {
        public static SortableItemIdWithUpdateMode of(List<SortableItemId> itemIds, UpdateMode updateMode, Optional<Id<InboundMessage>> firstUnreadMessageId) {
            return new SortableItemIdWithUpdateMode(itemIds, updateMode, firstUnreadMessageId);
        }
    }
}

