/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.mediator;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ContactGroupJoin;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.GroupMemberPermissions;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.MediatorLiveData;
import io.olvid.windows.messenger.livedata.info.GroupInfo;
import java.util.List;
import java.util.Optional;

public class GroupInfoLiveData
extends MediatorLiveData<Optional<GroupInfo>> {
    private Optional<Group> groupOpt = Optional.empty();
    private int membersCount = 0;

    public GroupInfoLiveData(Id<Group> id) {
        super(Optional.empty());
        this.addSource(id, DbManager.getInstance().getGroupDao().getContextLiveData(), (newValue, oldValue) -> {
            if (DiffUtils.areContentTheSame(newValue, oldValue)) {
                return;
            }
            this.groupOpt = newValue;
            this.consolidate();
        });
        LiveData<List<GroupMemberPermissions>> groupMemberPermissionsLiveData = LiveDataFactory.buildDbLiveDataList(GroupMemberPermissions.class, () -> DbManager.getInstance().getGroupMemberPermissionsDao().getAllOthersPermissionsForGroup(id), List.of(PendingGroupMember.class, ContactGroupJoin.class));
        this.addSource(groupMemberPermissionsLiveData, (newValue, oldValue) -> {
            int oldSize;
            int newSize = newValue == null ? 0 : newValue.size();
            int n = oldSize = oldValue == null ? 0 : oldValue.size();
            if (newSize == oldSize) {
                return;
            }
            this.membersCount = newSize;
            this.consolidate();
        });
    }

    private void consolidate() {
        if (this.groupOpt.isEmpty()) {
            this.postValue(Optional.empty());
            return;
        }
        Group group = this.groupOpt.get();
        this.postValue(Optional.of(new GroupInfo(group.getDisplayName(), group.getCustomPhotoUrlOrPhotoUrl(), group.getBytesGroupIdentifier(), this.membersCount, group.isKeycloakManaged())));
    }

    public static MapLiveData<Id<Group>, Optional<GroupInfo>> getMapLiveData() {
        return MapLiveData.of(GroupInfoLiveData::new);
    }
}

