/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.mediator;

import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.MediatorLiveData;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

public abstract class DynamicMediatorLiveData<T extends Diffable, Value>
extends MediatorLiveData<Optional<Value>>
implements LiveDataListener<Optional<T>> {
    private Optional<T> currentValue = Optional.empty();
    private final Map<MapLiveData<?, ?>, OptionalLiveData<?>> keyLiveDataMap = new IdentityHashMap();

    DynamicMediatorLiveData() {
        super(Optional.empty());
    }

    protected abstract void configureSources(T var1);

    public String toString() {
        return String.format("DynamicMediatorLiveData: key=%s", this.keyLiveDataMap);
    }

    protected synchronized <K, V> void configureSource(Optional<K> key, MapLiveData<K, Optional<V>> mapLiveData, Consumer<Optional<V>> update) {
        DynamicMediatorLiveData.debug(this, "configureSource", "key=%s observable=%s", key, mapLiveData);
        if (this.keyLiveDataMap.containsKey(mapLiveData)) {
            OptionalLiveData<?> keyLiveData = this.keyLiveDataMap.get(mapLiveData);
            keyLiveData.postValue(key);
        } else if (key.isPresent()) {
            OptionalLiveData<K> keyLiveData = new OptionalLiveData<K>(key);
            this.keyLiveDataMap.put(mapLiveData, keyLiveData);
            LiveData sourceForKey = mapLiveData.of(Optional.empty(), (LiveData<Optional<K>>)keyLiveData);
            this.addSource(sourceForKey, (newValue, oldValue) -> {
                update.accept((Optional)newValue);
                this.consolidate();
            });
        }
    }

    protected void consolidate() {
        if (this.currentValue.isEmpty()) {
            DynamicMediatorLiveData.debug(this, "consolidate", "with empty", new Object[0]);
            this.postValue(Optional.empty());
        } else {
            DynamicMediatorLiveData.debug(this, "consolidate", "with %s", this.currentValue.get());
            this.consolidate((Diffable)this.currentValue.get());
        }
    }

    protected abstract void consolidate(T var1);

    @Override
    public void onChange(Optional<T> newValue, Optional<T> oldValue) {
        DynamicMediatorLiveData.debug(this, "onChange", "%s -> %s areContentTheSame=%s", oldValue, newValue, DiffUtils.areContentTheSame(newValue, oldValue));
        if (DiffUtils.areContentTheSame(newValue, oldValue)) {
            return;
        }
        this.currentValue = newValue;
        if (this.currentValue.isEmpty()) {
            this.clearSources();
            DynamicMediatorLiveData.debug(this, "onChange", "Posting empty...", new Object[0]);
            this.postValue(Optional.empty());
            return;
        }
        Diffable source = (Diffable)this.currentValue.get();
        this.configureSources(source);
        this.consolidate();
    }

    private static final class OptionalLiveData<T>
    extends MutableLiveData<Optional<T>> {
        public OptionalLiveData(Optional<T> initialValue) {
            super(initialValue);
        }
    }
}

