/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.info.backup;

import io.olvid.engine.engine.types.ObvProfileBackupsForRestore;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshot;
import io.olvid.windows.messenger.livedata.Diffable;
import io.olvid.windows.messenger.livedata.info.backup.ProfileBackupFetchResult;
import io.olvid.windows.messenger.misc.ByteArray;
import java.util.Arrays;
import java.util.Optional;

public record ProfileBackupsInfo(ByteArray threadId, long version, long timestamp, boolean thisDevice, Optional<String> deviceName, Optional<String> platform, int contactCount, int groupCount, Optional<KeycloakInfo> keycloakInfoOpt, ObvSyncSnapshot snapshot, ProfileBackupFetchResult.FetchStatus fetchStatus) implements Diffable
{
    @Override
    public boolean areContentTheSame(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ProfileBackupsInfo) {
            ProfileBackupsInfo profileBackupsInfo = (ProfileBackupsInfo)obj;
            return Arrays.equals(this.threadId.byteArray(), profileBackupsInfo.threadId.byteArray());
        }
        return false;
    }

    @Override
    public Object getItemId() {
        return this.threadId;
    }

    public record KeycloakInfo(String serverUrl, String clientId, Optional<String> clientSecret, KeycloakStatus keycloakStatus) {

        public static enum KeycloakStatus {
            UNMANAGED,
            MANAGED,
            TRANSFER_RESTRICTED;


            public static KeycloakStatus map(ObvProfileBackupsForRestore.KeycloakStatus keycloakStatus) {
                return switch (keycloakStatus) {
                    default -> throw new MatchException(null, null);
                    case ObvProfileBackupsForRestore.KeycloakStatus.UNMANAGED -> UNMANAGED;
                    case ObvProfileBackupsForRestore.KeycloakStatus.MANAGED -> MANAGED;
                    case ObvProfileBackupsForRestore.KeycloakStatus.TRANSFER_RESTRICTED -> TRANSFER_RESTRICTED;
                };
            }
        }
    }
}

