/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.info;

import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.Location;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractMessageGenerated;
import io.olvid.windows.messenger.database.tables.gen.message.AbstractUserMessageGenerated;
import io.olvid.windows.messenger.database.tables.message.InboundMessage;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.database.tables.message.OutboundMessage;
import io.olvid.windows.messenger.database.tables.message.OwnedMessage;
import io.olvid.windows.messenger.fx.generic_types.DiffUtils;
import io.olvid.windows.messenger.livedata.Diffable;
import java.util.Optional;

public record MessageRefInfo(Id<MessageRef> refId, boolean messageHasBeenReceived, Optional<InboundMessage> inboundMessage, Optional<OutboundMessage> outboundMessage, Optional<OwnedMessage> ownedMessage) implements Diffable
{
    @Override
    public boolean areContentTheSame(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        MessageRefInfo other = (MessageRefInfo)obj;
        return this.equals(obj) && DiffUtils.areContentTheSame(this.inboundMessage(), other.inboundMessage()) && DiffUtils.areContentTheSame(this.outboundMessage(), other.outboundMessage()) && DiffUtils.areContentTheSame(this.ownedMessage(), other.ownedMessage());
    }

    @Override
    public Id<MessageRef> getItemId() {
        return this.refId;
    }

    public Optional<String> getBody() {
        return this.inboundMessage().flatMap(InboundMessage::getStringContent).or(() -> this.outboundMessage().flatMap(OutboundMessage::getStringContent)).or(() -> this.ownedMessage().flatMap(OwnedMessage::getStringContent));
    }

    public Optional<Id<Location>> getLocationId() {
        return this.inboundMessage().flatMap(AbstractUserMessageGenerated::getLocationId).or(() -> this.outboundMessage().flatMap(AbstractUserMessageGenerated::getLocationId)).or(() -> this.ownedMessage().flatMap(AbstractUserMessageGenerated::getLocationId));
    }

    public Optional<Long> getTimestamp() {
        return this.inboundMessage().map(AbstractMessageGenerated::getTimestamp).or(() -> this.outboundMessage().map(AbstractMessageGenerated::getTimestamp)).or(() -> this.ownedMessage().map(AbstractMessageGenerated::getTimestamp));
    }

    public int getTotalAttachmentCount() {
        return this.inboundMessage().map(AbstractUserMessageGenerated::getTotalAttachmentCount).or(() -> this.outboundMessage().map(AbstractUserMessageGenerated::getTotalAttachmentCount)).or(() -> this.ownedMessage().map(AbstractUserMessageGenerated::getTotalAttachmentCount)).orElse(0);
    }
}

