/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.db_livedata;

import io.olvid.windows.messenger.async.LiveDataCallBackExecutor;
import io.olvid.windows.messenger.async.LiveDataStatementExecutor;
import io.olvid.windows.messenger.database.dao.datatypes.DbDaoObserver;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.Watches;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

abstract class DbLiveData<T>
extends LiveData<T> {
    protected final Callable<T> task;
    protected final List<Class<? extends Table>> tablesToListen;
    protected DbDaoObserver observer;
    private final AtomicReference<State> state = new AtomicReference<State>(State.NONE);

    public DbLiveData(Callable<T> task, List<Class<? extends Table>> tablesToListen) {
        this.task = task;
        this.tablesToListen = tablesToListen;
        this.loggerInstance = new AppLogger(this.getClass());
        this.observer = new DbDaoObserver(this::executeStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeStatement() {
        AtomicReference<State> atomicReference = this.state;
        synchronized (atomicReference) {
            switch (this.state.get().ordinal()) {
                case 1: 
                case 3: {
                    return;
                }
                case 0: {
                    this.state.set(State.QUEUED);
                    break;
                }
                case 2: {
                    this.state.set(State.RUNNING_AND_DIRTY);
                    return;
                }
            }
        }
        LiveDataStatementExecutor.LIVE_DATA_STATEMENT_EXECUTOR.submitTask(() -> {
            AtomicReference<State> atomicReference = this.state;
            synchronized (atomicReference) {
                this.state.set(State.RUNNING_AND_CLEAN);
            }
            this.loggerInstance.trace(this.getClass().getSimpleName() + "#executeStatement clazz : " + String.valueOf(this.tablesToListen));
            try {
                Watches.Watch watch = Watches.getInstance().start(this.getClass().getSimpleName(), this.tablesToListen);
                T value = this.task.call();
                long delay = watch.stop();
                this.loggerInstance.trace(watch.name() + " -> " + TimeUnit.NANOSECONDS.toMicros(delay) + "\u03bcs");
                super.postValue(value);
            }
            catch (Exception e) {
                AppLogger.e("Error while executing db task", e);
            }
            atomicReference = this.state;
            synchronized (atomicReference) {
                switch (this.state.get().ordinal()) {
                    case 3: {
                        this.state.set(State.NONE);
                        this.executeStatement();
                        break;
                    }
                    case 2: {
                        this.state.set(State.NONE);
                        break;
                    }
                    case 0: 
                    case 1: {
                        throw new IllegalStateException("Invalid state");
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(LiveDataListener<T> listener) {
        if (listener == null) {
            return;
        }
        LinkedHashSet linkedHashSet = this.registeredListeners;
        synchronized (linkedHashSet) {
            boolean added;
            boolean hasNoListeners = this.registeredListeners.isEmpty();
            if (hasNoListeners) {
                for (Class<? extends Table> dbType : this.tablesToListen) {
                    DbManager.getInstance().getDao(dbType).registerObserverWithRet(this.observer);
                    this.loggerInstance.trace("observing, called initial query with type : " + dbType.getName());
                }
            }
            if ((added = this.registeredListeners.add(listener)) && !hasNoListeners) {
                LiveDataCallBackExecutor.LIVEDATA_CALLBACK_EXECUTOR.submitTask(() -> listener.onChange(this.data, null));
            }
            if (hasNoListeners) {
                this.executeStatement();
            }
        }
    }

    @Override
    public void removeListener(LiveDataListener<T> listener) {
        super.removeListener(listener);
        if (this.registeredListeners.isEmpty()) {
            for (Class<? extends Table> dbType : this.tablesToListen) {
                DbManager.getInstance().getDao(dbType).unregisterObserver(this.observer);
                this.loggerInstance.trace("unregistered observer with type : " + dbType.getName());
            }
        }
    }

    @Override
    public void removeAllListeners() {
        super.removeAllListeners();
        for (Class<? extends Table> dbType : this.tablesToListen) {
            DbManager.getInstance().getDao(dbType).unregisterObserver(this.observer);
            this.loggerInstance.trace("removing observer with type : " + dbType.getName());
        }
    }

    private static enum State {
        NONE,
        QUEUED,
        RUNNING_AND_CLEAN,
        RUNNING_AND_DIRTY;

    }
}

