/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.cache;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.fx.misc.richtextfx.RichStyledArea;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class UnreadMessageCountCache {
    private static final AppLogger logger = new AppLogger(RichStyledArea.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private final Map<Id<OwnedIdentity>, Map<Id<Discussion>, AtomicInteger>> unreadCountMap = new HashMap<Id<OwnedIdentity>, Map<Id<Discussion>, AtomicInteger>>();
    private final Info info = new Info();
    private final MutableLiveData<Info> unreadCountLiveData = new MutableLiveData<Info>(this.info);
    private static UnreadMessageCountCache instance;

    private UnreadMessageCountCache() {
    }

    public static synchronized UnreadMessageCountCache getInstance() {
        if (instance == null) {
            instance = new UnreadMessageCountCache();
        }
        return instance;
    }

    public LiveData<Info> getUnreadCountLiveData() {
        return this.unreadCountLiveData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        this.writeLock.lock();
        try {
            List ownedIdentities = DbManager.getInstance().getOwnedIdentityDao().getAll();
            for (OwnedIdentity ownedIdentity : ownedIdentities) {
                Object ownedIdentityId = ownedIdentity.getItemId();
                List<Discussion> discussions = DbManager.getInstance().getDiscussionDao().getVisibleDiscussionsAssociatedToIdentitySortedByLastMessageTimestamp((Id<OwnedIdentity>)ownedIdentityId);
                for (Discussion discussion : discussions) {
                    Object discussionId = discussion.getItemId();
                    int unreadCount = DbManager.getInstance().getInboundMessageDao().getAllUnreadDiscussionCount((Id<Discussion>)discussionId);
                    this.incr((Id<OwnedIdentity>)ownedIdentityId, (Id<Discussion>)discussionId, unreadCount);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementUnreadCount(Id<OwnedIdentity> ownedIdentityId, Id<Discussion> discussionId, int value) {
        this.writeLock.lock();
        try {
            this.incr(ownedIdentityId, discussionId, value);
            this.unreadCountLiveData.postValue(this.info);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementUnreadCount(Id<OwnedIdentity> ownedIdentityId, Id<Discussion> discussionId, int value) {
        this.writeLock.lock();
        try {
            this.decr(ownedIdentityId, discussionId, value);
            this.unreadCountLiveData.postValue(this.info);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void identityWasDeleted(Id<OwnedIdentity> ownedIdentityId) {
        this.writeLock.lock();
        try {
            this.unreadCountMap.remove(ownedIdentityId);
            this.unreadCountLiveData.postValue(this.info);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void incr(Id<OwnedIdentity> ownedIdentityId, Id<Discussion> discussionId, int delta) {
        if (delta == 0) {
            return;
        }
        Map innerMap = this.unreadCountMap.computeIfAbsent(ownedIdentityId, k -> new HashMap());
        AtomicInteger unreadCount = innerMap.computeIfAbsent(discussionId, k -> new AtomicInteger(0));
        unreadCount.addAndGet(delta);
    }

    private void decr(Id<OwnedIdentity> ownedIdentityId, Id<Discussion> discussionId, int delta) {
        if (delta == 0) {
            return;
        }
        Map<Id<Discussion>, AtomicInteger> innerMap = this.unreadCountMap.get(ownedIdentityId);
        if (innerMap == null) {
            logger.warning("Trying to decrement unread count for a non existing owned identity");
            return;
        }
        AtomicInteger unreadCount = innerMap.get(discussionId);
        if (unreadCount == null) {
            logger.warning("Trying to decrement unread count for a non existing discussion");
            return;
        }
        int newCount = unreadCount.addAndGet(-delta);
        if (newCount == 0) {
            innerMap.remove(discussionId);
        }
        if (innerMap.isEmpty()) {
            this.unreadCountMap.remove(ownedIdentityId);
        }
    }

    public final class Info {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getUnreadMessageCount(Id<Discussion> discussionId) {
            UnreadMessageCountCache.this.readLock.lock();
            try {
                Collection<Map<Id<Discussion>, AtomicInteger>> values = UnreadMessageCountCache.this.unreadCountMap.values();
                for (Map<Id<Discussion>, AtomicInteger> innerMap : values) {
                    AtomicInteger unreadCount = innerMap.get(discussionId);
                    if (unreadCount == null) continue;
                    int n = unreadCount.get();
                    return n;
                }
                int n = 0;
                return n;
            }
            finally {
                UnreadMessageCountCache.this.readLock.unlock();
            }
        }

        public Set<Id<OwnedIdentity>> getOwnedIdentitiesWithUnreadMessages() {
            UnreadMessageCountCache.this.readLock.lock();
            try {
                Set<Id<OwnedIdentity>> set = Set.copyOf(UnreadMessageCountCache.this.unreadCountMap.keySet());
                return set;
            }
            finally {
                UnreadMessageCountCache.this.readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasUnreadMessages(Id<OwnedIdentity> ownedIdentityId) {
            UnreadMessageCountCache.this.readLock.lock();
            try {
                Map<Id<Discussion>, AtomicInteger> innerMap = UnreadMessageCountCache.this.unreadCountMap.get(ownedIdentityId);
                boolean bl = innerMap != null && !innerMap.isEmpty();
                return bl;
            }
            finally {
                UnreadMessageCountCache.this.readLock.unlock();
            }
        }
    }
}

