/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.cache;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.ContactRef;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Group;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.IdentityDetails;
import io.olvid.windows.messenger.database.tables.IdentityRef;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.PendingGroupMember;
import io.olvid.windows.messenger.database.tables.PreContact;
import io.olvid.windows.messenger.database.tables.gen.ContactGenerated;
import io.olvid.windows.messenger.database.tables.gen.OwnedIdentityGenerated;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.database.tables.message.MessageRef;
import io.olvid.windows.messenger.livedata.ListLiveData;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.DiscussionInfo;
import io.olvid.windows.messenger.livedata.info.DiscussionInfoForCell;
import io.olvid.windows.messenger.livedata.info.DiscussionInfoWithState;
import io.olvid.windows.messenger.livedata.info.GroupInfo;
import io.olvid.windows.messenger.livedata.info.IdentityInfo;
import io.olvid.windows.messenger.livedata.info.MessageRefInfo;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.livedata.info.PendingGroupMemberInfo;
import io.olvid.windows.messenger.livedata.info.PreContactInfo;
import io.olvid.windows.messenger.livedata.mediator.ContactInfoLiveData;
import io.olvid.windows.messenger.livedata.mediator.DiscussionInfoForCellLiveData;
import io.olvid.windows.messenger.livedata.mediator.DiscussionInfoLiveData;
import io.olvid.windows.messenger.livedata.mediator.DiscussionInfoWithStateLiveData;
import io.olvid.windows.messenger.livedata.mediator.GroupInfoLiveData;
import io.olvid.windows.messenger.livedata.mediator.IdentityInfoLiveData;
import io.olvid.windows.messenger.livedata.mediator.MessageRefLiveData;
import io.olvid.windows.messenger.livedata.mediator.PendingGroupMemberInfoLiveData;
import io.olvid.windows.messenger.livedata.mediator.PreContactInfoLiveData;
import java.util.List;
import java.util.Optional;

public final class DbCache {
    private static final DbCache instance = new DbCache();
    private final LiveData<List<IdentityDetails>> identityDetails = LiveDataFactory.buildDbLiveDataList(IdentityDetails.class, () -> DbManager.getInstance().getIdentityDetailsDao().getAll());
    private final LiveData<List<OwnedIdentity>> ownedIdentities = LiveDataFactory.buildDbLiveDataList(OwnedIdentity.class, () -> DbManager.getInstance().getOwnedIdentityDao().getAllSortedByIndex());
    public final LiveData<List<OwnedIdentityInfo>> ownedIdentitiesInfo = LiveDataFactory.map(ListLiveData.join(this.ownedIdentities, this.identityDetails, OwnedIdentityGenerated::getIdentityDetailsId, AbstractTableGenerated::getItemId), List.of(), l -> l.stream().map(p -> new OwnedIdentityInfo((OwnedIdentity)p.getFirst(), (IdentityDetails)p.getSecond())).toList());
    public final MapLiveData<Id<OwnedIdentity>, Optional<OwnedIdentityInfo>> ownedIdentityMapLiveData = ListLiveData.findByKey(this.ownedIdentitiesInfo, OwnedIdentityInfo::genId);
    private final LiveData<List<Contact>> contacts = LiveDataFactory.buildDbLiveDataList(Contact.class, () -> DbManager.getInstance().getContactDao().getAll());
    public final LiveData<List<ContactInfo>> contactsInfo = LiveDataFactory.map(ListLiveData.join(this.contacts, this.identityDetails, ContactGenerated::getIdentityDetailsId, AbstractTableGenerated::getItemId), List.of(), l -> l.stream().map(p -> new ContactInfo((Contact)p.getFirst(), (IdentityDetails)p.getSecond())).toList());
    public final MapLiveData<Id<Contact>, Optional<ContactInfo>> contactInfoMapLiveData = ListLiveData.findByKey(this.contactsInfo, ContactInfo::genId);
    public final MapLiveData<Id<ContactRef>, ContactInfoLiveData.ContactInfoState> contactRefInfoMapLiveData = ContactInfoLiveData.getMapLiveData();
    public final MapLiveData<Id<IdentityRef>, Optional<IdentityInfo>> identityInfoMapLiveData = IdentityInfoLiveData.getMapLiveData();
    public final MapLiveData<Id<Group>, Optional<GroupInfo>> groupInfoMapLiveData = GroupInfoLiveData.getMapLiveData();
    private final MapLiveData<Id<MessageRef>, Optional<MessageRefInfo>> messageRefInfoMapLiveData = MessageRefLiveData.getMapLiveData();
    private final MapLiveData<Id<PreContact>, Optional<PreContactInfo>> preContactInfoMapLiveData = PreContactInfoLiveData.getMapLiveData();
    public final MapLiveData<Id<Discussion>, DiscussionInfo> discussionInfoMapLiveData = DiscussionInfoLiveData.getMapLiveData(this.preContactInfoMapLiveData, this.groupInfoMapLiveData);
    public final MapLiveData<Id<Discussion>, Optional<DiscussionInfoForCell>> discussionInfoForCellMapLiveData = DiscussionInfoForCellLiveData.getMapLiveData(this.messageRefInfoMapLiveData);
    public final MapLiveData<Id<Discussion>, DiscussionInfoWithState> discussionInfoWithStateMapLiveData = DiscussionInfoWithStateLiveData.getMapLiveData();
    public final MapLiveData<Id<PendingGroupMember>, Optional<PendingGroupMemberInfo>> pendingGroupMemberInfoLiveData = PendingGroupMemberInfoLiveData.getMapLiveData();

    public static DbCache getInstance() {
        return instance;
    }

    public Optional<ContactInfo> getContactInfo(Id<Contact> contactId) {
        return this.contactsInfo.getValue().stream().filter(info -> info.genId().equals(contactId)).findFirst();
    }
}

