/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata.cache;

import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.attachment.InboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OutboundAttachment;
import io.olvid.windows.messenger.database.tables.attachment.OwnedAttachment;
import io.olvid.windows.messenger.database.tables.gen.attachment.AbstractAttachmentGenerated;
import io.olvid.windows.messenger.database.tables.gen.attachment.ReceivedAttachmentGenerated;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.misc.BytesKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class AttachmentProgressCache {
    private final Map<AttachmentKey, Id<OutboundAttachment>> outboundAttachmentIdMap = new HashMap<AttachmentKey, Id<OutboundAttachment>>();
    private final Map<AttachmentKey, Id<InboundAttachment>> inboundAttachmentIdMap = new HashMap<AttachmentKey, Id<InboundAttachment>>();
    private final Map<AttachmentKey, Id<OwnedAttachment>> ownedAttachmentIdMap = new HashMap<AttachmentKey, Id<OwnedAttachment>>();
    private final Map<Id<OutboundAttachment>, Float> copyingProgressMap = new HashMap<Id<OutboundAttachment>, Float>();
    private final MutableLiveData<Map<Id<OutboundAttachment>, Float>> copyingProgressLiveData = new MutableLiveData<Map<Id<OutboundAttachment>, Float>>(this.copyingProgressMap);
    private final Map<Id<OutboundAttachment>, Map<BytesKey, UploadInfo>> serverUploadInfo = new HashMap<Id<OutboundAttachment>, Map<BytesKey, UploadInfo>>();
    private final Map<Id<OutboundAttachment>, UploadInfo> uploadProgressMap = new HashMap<Id<OutboundAttachment>, UploadInfo>();
    private final MutableLiveData<Map<Id<OutboundAttachment>, UploadInfo>> uploadProgressMapLiveData = new MutableLiveData<Map<Id<OutboundAttachment>, UploadInfo>>(this.uploadProgressMap);
    private final Map<Id<InboundAttachment>, Float> inboundDownloadProgressMap = new HashMap<Id<InboundAttachment>, Float>();
    private final MutableLiveData<Map<Id<InboundAttachment>, Float>> inboundDownloadProgressLiveData = new MutableLiveData<Map<Id<InboundAttachment>, Float>>(this.inboundDownloadProgressMap);
    private final Map<Id<OwnedAttachment>, Float> ownedDownloadProgressMap = new HashMap<Id<OwnedAttachment>, Float>();
    private final MutableLiveData<Map<Id<OwnedAttachment>, Float>> ownedDownloadProgressLiveData = new MutableLiveData<Map<Id<OwnedAttachment>, Float>>(this.ownedDownloadProgressMap);
    private static AttachmentProgressCache instance;

    private AttachmentProgressCache() {
    }

    public static synchronized AttachmentProgressCache getInstance() {
        if (instance == null) {
            instance = new AttachmentProgressCache();
        }
        return instance;
    }

    public synchronized void doneCopying(Id<OutboundAttachment> id) {
        this.copyingProgressMap.remove(id);
        this.copyingProgressLiveData.postValue(this.copyingProgressMap);
    }

    public synchronized void updateCopying(Id<OutboundAttachment> id, float progress) {
        this.copyingProgressMap.put(id, Float.valueOf(progress));
        this.copyingProgressLiveData.postValue(this.copyingProgressMap);
    }

    public LiveData<Map<Id<OutboundAttachment>, Float>> getCopyingProgressLiveData() {
        return this.copyingProgressLiveData;
    }

    public synchronized void doneUploading(Id<OutboundAttachment> id, byte[] engineMessageIdentifier) {
        Map<BytesKey, UploadInfo> uploadInfoMap = this.serverUploadInfo.get(id);
        if (uploadInfoMap == null) {
            return;
        }
        BytesKey key = BytesKey.of(engineMessageIdentifier);
        uploadInfoMap.remove(key);
        this.consolidate(id, uploadInfoMap.values());
        if (uploadInfoMap.isEmpty()) {
            this.serverUploadInfo.remove(id);
            this.outboundAttachmentIdMap.values().removeIf(id::equals);
        }
    }

    private void cleanOutbound(Id<OutboundAttachment> id) {
        this.serverUploadInfo.remove(id);
        this.uploadProgressMap.remove(id);
        this.outboundAttachmentIdMap.values().removeIf(id::equals);
    }

    public synchronized void updateUploading(byte[] bytesOwnedIdentity, byte[] messageIdentifier, int idx, float progress, float speed, Optional<Integer> eta) {
        AttachmentKey attachmentKey = new AttachmentKey(bytesOwnedIdentity, messageIdentifier, idx);
        Id<OutboundAttachment> id = this.outboundAttachmentIdMap.get(attachmentKey);
        if (id == null) {
            Optional<OutboundAttachment> outboundAttachment = DbManager.getInstance().getOutboundAttachmentDao().getFromIndexAndMessageIdentifier(bytesOwnedIdentity, messageIdentifier, idx);
            if (outboundAttachment.isEmpty()) {
                return;
            }
            id = outboundAttachment.get().getItemId();
            this.outboundAttachmentIdMap.put(attachmentKey, id);
        }
        Map uploadInfoMap = this.serverUploadInfo.computeIfAbsent(id, k -> new ConcurrentHashMap());
        BytesKey key = BytesKey.of(messageIdentifier);
        UploadInfo uploadInfo = new UploadInfo(progress, speed, eta);
        uploadInfoMap.put(key, uploadInfo);
        this.consolidate(id, uploadInfoMap.values());
    }

    private void consolidate(Id<OutboundAttachment> id, Collection<UploadInfo> uploadInfos) {
        if (uploadInfos.isEmpty()) {
            this.uploadProgressMap.remove(id);
            this.uploadProgressMapLiveData.postValue(this.uploadProgressMap);
            return;
        }
        float totalProgress = 0.0f;
        float sumSpeedProgress = 0.0f;
        Optional<Integer> maxEta = Optional.of(-1);
        for (UploadInfo info : uploadInfos) {
            totalProgress += info.progress();
            sumSpeedProgress += info.speed();
            if (info.eta.isEmpty()) {
                maxEta = Optional.empty();
                continue;
            }
            if (maxEta.isPresent()) {
                maxEta = Optional.of(Math.max(maxEta.get(), info.eta.get()));
                continue;
            }
            maxEta = info.eta;
        }
        UploadInfo consolidateUploadInfo = new UploadInfo(totalProgress / (float)uploadInfos.size(), sumSpeedProgress, maxEta);
        this.uploadProgressMap.put(id, consolidateUploadInfo);
        this.uploadProgressMapLiveData.postValue(this.uploadProgressMap);
    }

    public LiveData<Map<Id<OutboundAttachment>, UploadInfo>> getUploadProgressLiveData() {
        return this.uploadProgressMapLiveData;
    }

    public synchronized void doneDownloading(byte[] bytesOwnedIdentity, byte[] messageIdentifier, int idx) {
        AttachmentKey attachmentKey = new AttachmentKey(bytesOwnedIdentity, messageIdentifier, idx);
        Id<InboundAttachment> inboundId = this.inboundAttachmentIdMap.get(attachmentKey);
        if (inboundId != null) {
            this.doneInboundDownloading(inboundId);
            return;
        }
        Id<OwnedAttachment> ownedId = this.ownedAttachmentIdMap.get(attachmentKey);
        if (ownedId != null) {
            this.doneOwnedDownloading(ownedId);
            return;
        }
        InboundAttachment inboundAttachment = (InboundAttachment)DbManager.getInstance().getInboundAttachmentDao().getByEngineIdentifierAndNumber(bytesOwnedIdentity, messageIdentifier, idx);
        if (inboundAttachment != null) {
            inboundId = inboundAttachment.getItemId();
            this.inboundAttachmentIdMap.put(attachmentKey, inboundId);
            this.doneInboundDownloading(inboundId);
            return;
        }
        OwnedAttachment ownedAttachment = (OwnedAttachment)DbManager.getInstance().getOwnedAttachmentDao().getByEngineIdentifierAndNumber(bytesOwnedIdentity, messageIdentifier, idx);
        if (ownedAttachment != null) {
            ownedId = ownedAttachment.getItemId();
            this.ownedAttachmentIdMap.put(attachmentKey, ownedId);
            this.doneOwnedDownloading(ownedId);
        }
    }

    public synchronized void updateDownloading(byte[] bytesOwnedIdentity, byte[] messageIdentifier, int idx, float progress) {
        AttachmentKey attachmentKey = new AttachmentKey(bytesOwnedIdentity, messageIdentifier, idx);
        Id<InboundAttachment> inboundId = this.inboundAttachmentIdMap.get(attachmentKey);
        if (inboundId != null) {
            this.updateInboundDownloading(inboundId, progress);
            return;
        }
        Id<OwnedAttachment> ownedId = this.ownedAttachmentIdMap.get(attachmentKey);
        if (ownedId != null) {
            this.updateOwnedDownloading(ownedId, progress);
            return;
        }
        InboundAttachment inboundAttachment = (InboundAttachment)DbManager.getInstance().getInboundAttachmentDao().getByEngineIdentifierAndNumber(bytesOwnedIdentity, messageIdentifier, idx);
        if (inboundAttachment != null) {
            inboundId = inboundAttachment.getItemId();
            this.inboundAttachmentIdMap.put(attachmentKey, inboundId);
            this.updateInboundDownloading(inboundId, progress);
            return;
        }
        OwnedAttachment ownedAttachment = (OwnedAttachment)DbManager.getInstance().getOwnedAttachmentDao().getByEngineIdentifierAndNumber(bytesOwnedIdentity, messageIdentifier, idx);
        if (ownedAttachment != null) {
            ownedId = ownedAttachment.getItemId();
            this.ownedAttachmentIdMap.put(attachmentKey, ownedId);
            this.updateOwnedDownloading(ownedId, progress);
        }
    }

    private void doneInboundDownloading(Id<InboundAttachment> id) {
        this.inboundDownloadProgressMap.remove(id);
        this.inboundDownloadProgressLiveData.postValue(this.inboundDownloadProgressMap);
        this.inboundAttachmentIdMap.values().removeIf(id::equals);
    }

    private void updateInboundDownloading(Id<InboundAttachment> id, float progress) {
        this.inboundDownloadProgressMap.put(id, Float.valueOf(progress));
        this.inboundDownloadProgressLiveData.postValue(this.inboundDownloadProgressMap);
    }

    public LiveData<Map<Id<InboundAttachment>, Float>> getInboundDownloadProgressLiveData() {
        return this.inboundDownloadProgressLiveData;
    }

    private void doneOwnedDownloading(Id<OwnedAttachment> id) {
        this.ownedDownloadProgressMap.remove(id);
        this.ownedDownloadProgressLiveData.postValue(this.ownedDownloadProgressMap);
        this.ownedAttachmentIdMap.values().removeIf(id::equals);
    }

    private void updateOwnedDownloading(Id<OwnedAttachment> id, float progress) {
        this.ownedDownloadProgressMap.put(id, Float.valueOf(progress));
        this.ownedDownloadProgressLiveData.postValue(this.ownedDownloadProgressMap);
    }

    public LiveData<Map<Id<OwnedAttachment>, Float>> getOwnedDownloadProgressLiveData() {
        return this.ownedDownloadProgressLiveData;
    }

    public synchronized <ReceivedAttachment extends ReceivedAttachmentGenerated<ReceivedAttachment>> void doneDownloading(Id<ReceivedAttachment> id) {
        if (id.clazz.equals(InboundAttachment.class)) {
            this.doneInboundDownloading(new Id<InboundAttachment>(InboundAttachment.class, id.getId()));
        } else if (id.clazz.equals(OwnedAttachment.class)) {
            this.doneOwnedDownloading(new Id<OwnedAttachment>(OwnedAttachment.class, id.getId()));
        }
    }

    public synchronized void clean(List<? extends AbstractAttachmentGenerated<?>> attachments) {
        for (AbstractAttachmentGenerated<?> attachment : attachments) {
            if (attachment instanceof InboundAttachment) {
                InboundAttachment inboundAttachment = (InboundAttachment)attachment;
                this.doneInboundDownloading((Id<InboundAttachment>)inboundAttachment.getItemId());
                continue;
            }
            if (attachment instanceof OwnedAttachment) {
                OwnedAttachment ownedAttachment = (OwnedAttachment)attachment;
                this.doneOwnedDownloading((Id<OwnedAttachment>)ownedAttachment.getItemId());
                continue;
            }
            if (!(attachment instanceof OutboundAttachment)) continue;
            OutboundAttachment outboundAttachment = (OutboundAttachment)attachment;
            this.cleanOutbound((Id<OutboundAttachment>)outboundAttachment.getItemId());
        }
    }

    private record AttachmentKey(byte[] bytesOwnedIdentity, byte[] messageIdentifier, int idx) {
    }

    public record UploadInfo(float progress, float speed, Optional<Integer> eta) {
    }
}

