/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata;

import io.olvid.engine.Logger;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.ApplicationSetting;
import io.olvid.windows.messenger.database.tables.Contact;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.fx.discussions.discussions_tab.DiscussionSelectionModel;
import io.olvid.windows.messenger.fx.modal.confirmation.keycloak.ConfirmationKeycloakSignatureChangedModalController;
import io.olvid.windows.messenger.fx.modal.confirmation.keycloak.DialogKeycloakIdentityReplacement;
import io.olvid.windows.messenger.fx.modal.confirmation.keycloak.KeycloakAuthenticationConfirmationModalController;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.livedata.ListLiveData;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.livedata.cache.DbCache;
import io.olvid.windows.messenger.livedata.info.ContactInfo;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.BytesKey;
import io.olvid.windows.messenger.misc.Pair;
import io.olvid.windows.messenger.misc.cache.ApplicationSettingsDatabaseCache;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationType;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.OwnedIdentitySyncingNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UtilityNC;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public final class SelectedOwnedIdentitySingleton {
    static UtilityNC.UtilityNotificationEnumType[] subscribedUtilityNotificationsTypes = new UtilityNC.UtilityNotificationEnumType[]{UtilityNC.UtilityNotificationEnumType.KEYCLOAK_AUTHENTICATION_REQUIRED, UtilityNC.UtilityNotificationEnumType.KEYCLOAK_IDENTITY_REPLACEMENT, UtilityNC.UtilityNotificationEnumType.KEYCLOAK_SIGNATURE_KEY_UPDATED, UtilityNC.UtilityNotificationEnumType.OWNED_IDENTITY_SYNCING};
    public final LiveData<Optional<Id<OwnedIdentity>>> currentOwnedIdentityId;
    public final LiveData<Optional<OwnedIdentityInfo>> currentOwnedIdentityInfo;
    public final LiveData<List<ContactInfo>> contactsInfoOfSelectedOwnedIdentity;
    public final LiveData<List<OwnedIdentityInfo>> otherOwnedIdentitiesInfo;
    private final Map<Id<OwnedIdentity>, SyncStatus> ownedIdentitiesSyncInfo = new ConcurrentHashMap<Id<OwnedIdentity>, SyncStatus>();
    private final MutableLiveData<Boolean> isSelectedOwnedIdentityInitialSyncingLD = new MutableLiveData<Boolean>(false);
    private final MutableLiveData<Boolean> isSelectedOwnedIdentityManualSyncingLD = new MutableLiveData<Boolean>(false);
    private final NotificationListener<? extends NotificationType> utilityNotificationsListener = this::utilityNotificationListener;
    private static SelectedOwnedIdentitySingleton instance;

    public static synchronized SelectedOwnedIdentitySingleton getInstance() {
        if (instance == null) {
            instance = new SelectedOwnedIdentitySingleton();
        }
        return instance;
    }

    private SelectedOwnedIdentitySingleton() {
        OwnedIdentity ownedIdentity;
        byte[] lastIdentityBytes = null;
        String lastIdentity = ApplicationSettingsDatabaseCache.getInstance().get(ApplicationSetting.GlobalAppSettings.LAST_OWNED_IDENTITY);
        if (lastIdentity != null) {
            lastIdentityBytes = Logger.fromHexString((String)lastIdentity);
        }
        Optional<Object> ownedIdentityId = (ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().getDefaultCurrentIdentity(lastIdentityBytes)) == null ? Optional.empty() : Optional.of(ownedIdentity.getItemId());
        this.currentOwnedIdentityId = LiveDataFactory.buildMutableLiveData(ownedIdentityId);
        this.currentOwnedIdentityInfo = LiveDataFactory.switchMap(this.currentOwnedIdentityId, id -> {
            if (id.isEmpty()) {
                return LiveDataFactory.buildEmptyLiveData();
            }
            return ListLiveData.findFirst(DbCache.getInstance().ownedIdentitiesInfo, i -> i.genId().equals(id.get()));
        });
        this.contactsInfoOfSelectedOwnedIdentity = LiveDataFactory.switchMap(this.currentOwnedIdentityId, id -> {
            if (id.isEmpty()) {
                return LiveDataFactory.buildMutableLiveData(List.of());
            }
            return ListLiveData.filter(DbCache.getInstance().contactsInfo, info -> info.ownedIdentityId().equals(id.get()));
        });
        this.otherOwnedIdentitiesInfo = LiveDataFactory.switchMap(this.currentOwnedIdentityId, id -> {
            if (id.isEmpty()) {
                return DbCache.getInstance().ownedIdentitiesInfo;
            }
            return ListLiveData.filter(DbCache.getInstance().ownedIdentitiesInfo, i -> !i.genId().equals(id.get()));
        });
        NCRegistry.getUtilityNC().subscribe(subscribedUtilityNotificationsTypes, this.utilityNotificationsListener);
    }

    private void updateCurrentIdentity(Id<OwnedIdentity> ownedIdentityInfoId, byte[] bytesOwnedIdentity) {
        AppLogger.i(String.format("SelectedOwnedIdentitySingleton::updateCurrentIdentity: %s -> %s", this.currentOwnedIdentityId.getValue(), ownedIdentityInfoId));
        this.currentOwnedIdentityId.postValue(Optional.of(ownedIdentityInfoId));
        DiscussionSelectionModel.getInstance().getSelectedDiscussionLiveData().postValue(null);
        AsyncTaskExecutor.submitTask(() -> {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (KeycloakManager.getInstance().selfTestAndPromptForAuthentication(BytesKey.of(bytesOwnedIdentity), true)) {
                AppLogger.d("SelectedOwnedIdentitySingleton::updateCurrentIdentity POSTING KEYCLOAKAUTHENTICATIONREQUIREDNOTIFICATION");
                UtilityNC.fireAuthenticationRequiredNotification(bytesOwnedIdentity);
            }
        });
        this.isSelectedOwnedIdentityManualSyncingLD.postValue(this.ownedIdentitiesSyncInfo.containsKey(ownedIdentityInfoId) && this.ownedIdentitiesSyncInfo.get(ownedIdentityInfoId).manualSyncInProgress);
        this.isSelectedOwnedIdentityInitialSyncingLD.postValue(this.ownedIdentitiesSyncInfo.containsKey(ownedIdentityInfoId) && this.ownedIdentitiesSyncInfo.get(ownedIdentityInfoId).initialSyncInProgress);
        if (bytesOwnedIdentity != null) {
            ApplicationSettingsDatabaseCache.getInstance().set(ApplicationSetting.GlobalAppSettings.LAST_OWNED_IDENTITY, Logger.toHexString((byte[])bytesOwnedIdentity));
        } else {
            ApplicationSettingsDatabaseCache.getInstance().set(ApplicationSetting.GlobalAppSettings.LAST_OWNED_IDENTITY, null);
        }
    }

    /*
     * Exception decompiling
     */
    private void utilityNotificationListener(NotificationType notification) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=20,626
         *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void ownedIdentitySyncNotificationHandler(OwnedIdentitySyncingNotification notification) {
        Id<OwnedIdentity> ownedId = notification.ownedIdentityId();
        OwnedIdentitySyncingNotification.SyncingNotificationState manualSyncInProgress = notification.manualSyncState();
        OwnedIdentitySyncingNotification.SyncingNotificationState initialSyncInProgress = notification.initialSyncState();
        this.ownedIdentitiesSyncInfo.compute(ownedId, (ownedIdentityId, syncStatus) -> {
            if (syncStatus == null) {
                syncStatus = new SyncStatus();
            }
            switch (manualSyncInProgress) {
                case IN_PROGRESS: {
                    syncStatus.setManualSyncInProgress(true);
                    break;
                }
                case SYNCED: {
                    syncStatus.setManualSyncInProgress(false);
                    break;
                }
            }
            switch (initialSyncInProgress) {
                case IN_PROGRESS: {
                    syncStatus.setInitialSyncInProgress(true);
                    break;
                }
                case SYNCED: {
                    syncStatus.setInitialSyncInProgress(false);
                    break;
                }
            }
            return syncStatus;
        });
        if (this.currentOwnedIdentityId.getValue().isPresent() && ownedId.equals(this.currentOwnedIdentityId.getValue().get())) {
            this.isSelectedOwnedIdentityInitialSyncingLD.postValue(this.ownedIdentitiesSyncInfo.containsKey(ownedId) && this.ownedIdentitiesSyncInfo.get(ownedId).initialSyncInProgress);
            this.isSelectedOwnedIdentityManualSyncingLD.postValue(this.ownedIdentitiesSyncInfo.containsKey(ownedId) && this.ownedIdentitiesSyncInfo.get(ownedId).manualSyncInProgress);
        }
    }

    public void updateCurrentIdentity(OwnedIdentityInfo ownedIdentityInfo) {
        this.updateCurrentIdentity(ownedIdentityInfo.genId(), ownedIdentityInfo.bytesOwnedIdentity());
    }

    public void updateCurrentIdentity(OwnedIdentity newCurrentOwnedIdentity) {
        this.updateCurrentIdentity((Id<OwnedIdentity>)newCurrentOwnedIdentity.getItemId(), newCurrentOwnedIdentity.getBytesOwnedIdentity());
    }

    public LiveData<List<ContactInfo>> of(LiveData<List<Contact>> contacts) {
        LiveData<List<Pair<Contact, ContactInfo>>> join = ListLiveData.join(contacts, this.contactsInfoOfSelectedOwnedIdentity, AbstractTableGenerated::getItemId, ContactInfo::genId);
        return LiveDataFactory.map(join, List.of(), l -> l.stream().map(Pair::getSecond).toList());
    }

    public void autoUpdateSelectedOwnedIdentity() {
        AppLogger.i("CurrentOwnedIdentitySingleton.autoUpdateCurrentIdentity() ");
        AsyncTaskExecutor.submitTask(() -> {
            OwnedIdentity ownedIdentity;
            byte[] lastIdentityBytes = null;
            String lastIdentity = ApplicationSettingsDatabaseCache.getInstance().get(ApplicationSetting.GlobalAppSettings.LAST_OWNED_IDENTITY);
            if (lastIdentity != null) {
                lastIdentityBytes = Logger.fromHexString((String)lastIdentity);
            }
            if ((ownedIdentity = DbManager.getInstance().getOwnedIdentityDao().getDefaultCurrentIdentity(lastIdentityBytes)) != null) {
                this.updateCurrentIdentity(ownedIdentity);
            }
        });
    }

    public Optional<Id<OwnedIdentity>> getSelectedOwnedIdentityId() {
        return this.currentOwnedIdentityId.getValue();
    }

    public Optional<OwnedIdentityInfo> getSelectedOwnedIdentityInfo() {
        return this.currentOwnedIdentityInfo.getValue();
    }

    public boolean isSelectedIdentityPresent() {
        return this.currentOwnedIdentityId.getValue().isPresent();
    }

    public void addListener(LiveDataListener<Optional<OwnedIdentityInfo>> listener) {
        this.currentOwnedIdentityInfo.addListener(listener);
    }

    public void removeListener(LiveDataListener<Optional<OwnedIdentityInfo>> listener) {
        this.currentOwnedIdentityInfo.removeListener(listener);
    }

    public void addOwnedIdInitialSyncingListener(LiveDataListener<Boolean> listener) {
        this.isSelectedOwnedIdentityInitialSyncingLD.addListener(listener);
    }

    public void removeOwnedIdInitialSyncingListener(LiveDataListener<Boolean> listener) {
        this.isSelectedOwnedIdentityInitialSyncingLD.removeListener(listener);
    }

    public void addOwnedIdManualSyncingListener(LiveDataListener<Boolean> listener) {
        this.isSelectedOwnedIdentityManualSyncingLD.addListener(listener);
    }

    public void removeOwnedIdManualSyncingListener(LiveDataListener<Boolean> listener) {
        this.isSelectedOwnedIdentityManualSyncingLD.removeListener(listener);
    }

    private static /* synthetic */ void lambda$utilityNotificationListener$9(byte[] ownedIdentity) {
        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(new ConfirmationKeycloakSignatureChangedModalController(ownedIdentity), false));
    }

    private static /* synthetic */ void lambda$utilityNotificationListener$8(byte[] ownedIdentity, boolean revocationAllowed) {
        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(new DialogKeycloakIdentityReplacement(Pair.of(ownedIdentity, revocationAllowed)), false));
    }

    private static /* synthetic */ void lambda$utilityNotificationListener$7() {
        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(new KeycloakAuthenticationConfirmationModalController(), false));
    }

    static class SyncStatus {
        private boolean manualSyncInProgress = false;
        private boolean initialSyncInProgress = false;

        public void setManualSyncInProgress(boolean manualSyncInProgress) {
            this.manualSyncInProgress = manualSyncInProgress;
        }

        public void setInitialSyncInProgress(boolean initialSyncInProgress) {
            this.initialSyncInProgress = initialSyncInProgress;
        }
    }
}

