/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata;

import io.olvid.windows.messenger.async.LiveDataCallBackExecutor;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.database.tables.gen.common.AbstractTableGenerated;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.livedata.MediatorLiveData;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface MapLiveData<K, V> {
    public void addListener(K var1, LiveDataListener<V> var2);

    public void removeListener(K var1, LiveDataListener<V> var2);

    public V getCurrentValue(K var1);

    default public LiveData<V> of(V none, K key) {
        Objects.requireNonNull(none);
        Objects.requireNonNull(key);
        return new KeyLiveData(none, this, key, Function.identity());
    }

    default public LiveData<Optional<V>> optionalOf(K key) {
        Objects.requireNonNull(key);
        return new KeyLiveData<K, Object, Optional>(Optional.empty(), this, key, Optional::of);
    }

    default public LiveData<V> of(V none, LiveData<Optional<K>> key) {
        Objects.requireNonNull(none);
        Objects.requireNonNull(key);
        return new SwitchMapLiveData(none, this, key, Function.identity());
    }

    default public LiveData<Optional<V>> optionalOf(LiveData<Optional<K>> key) {
        Objects.requireNonNull(key);
        return new SwitchMapLiveData<K, Object, Optional>(Optional.empty(), this, key, Optional::of);
    }

    public static <K, V> MapLiveData<K, V> of(Function<K, LiveData<V>> buildLiveData) {
        Objects.requireNonNull(buildLiveData);
        return new MapLiveDataStore<K, V>(buildLiveData);
    }

    public static <S, T extends AbstractTableGenerated<T>, U> LiveData<List<U>> list(LiveData<List<S>> source, Function<S, Id<T>> getId, MapLiveData<Id<T>, U> mapLiveData, Function<S, U> default_) {
        return new ListLiveData<S, T, U>(source, getId, mapLiveData, default_);
    }

    public static final class KeyLiveData<K, V, U>
    extends MediatorLiveData<U>
    implements LiveDataListener<V> {
        private final MapLiveData<K, V> mapLiveData;
        private final K key;
        private final Function<V, U> buildU;

        private KeyLiveData(U none, MapLiveData<K, V> mapLiveData, K key, Function<V, U> buildU) {
            super(none);
            this.mapLiveData = mapLiveData;
            this.key = key;
            this.buildU = buildU;
            this.addSource(key, mapLiveData, this);
        }

        @Override
        public void onChange(V newValue, V oldValue) {
            this.postValue(this.buildU.apply(newValue));
        }

        public String toString() {
            return String.format("KeyLiveData: key=%s map=%s", this.key, this.mapLiveData);
        }
    }

    public static final class SwitchMapLiveData<K, V, U>
    extends MediatorLiveData<U>
    implements LiveDataListener<V> {
        private final MapLiveData<K, V> mapLiveData;
        private final LiveData<Optional<K>> key;
        private final Function<V, U> buildU;

        private SwitchMapLiveData(U none, MapLiveData<K, V> mapLiveData, LiveData<Optional<K>> key, Function<V, U> buildU) {
            super(none);
            this.buildU = buildU;
            this.mapLiveData = mapLiveData;
            this.key = key;
            this.addSource(key, (newValue, oldValue) -> {
                if (newValue != null && newValue.equals(oldValue)) {
                    return;
                }
                if (oldValue != null && oldValue.isPresent()) {
                    this.removeSource(oldValue.get(), mapLiveData);
                }
                if (newValue != null && newValue.isPresent()) {
                    this.addSource(newValue.get(), mapLiveData, this);
                } else {
                    this.postValue(none);
                }
            });
        }

        @Override
        public void onChange(V newValue, V oldValue) {
            this.postValue(this.buildU.apply(newValue));
        }

        public String toString() {
            return String.format("SwitchMapLiveData: key=%s map=%s", this.key, this.mapLiveData);
        }
    }

    public static final class MapLiveDataStore<K, V>
    implements MapLiveData<K, V> {
        private final Map<K, LiveData<V>> map = new ConcurrentHashMap<K, LiveData<V>>();
        private final Function<K, LiveData<V>> buildLiveData;

        private MapLiveDataStore(Function<K, LiveData<V>> buildLiveData) {
            Objects.requireNonNull(buildLiveData);
            this.buildLiveData = buildLiveData;
        }

        @Override
        public synchronized void addListener(K key, LiveDataListener<V> listener) {
            LiveData<V> liveData = this.map.computeIfAbsent(key, this.buildLiveData);
            liveData.addListener(listener);
        }

        @Override
        public synchronized void removeListener(K key, LiveDataListener<V> listener) {
            LiveData<V> liveData = this.map.get(key);
            if (liveData == null) {
                AppLogger.e("Store: cannot find liveData for the key: " + String.valueOf(key));
                return;
            }
            liveData.removeListener(listener);
            if (liveData.hasObservers()) {
                return;
            }
            this.map.remove(key);
        }

        @Override
        public V getCurrentValue(K key) {
            LiveData<V> liveData = this.map.get(key);
            if (liveData == null) {
                return null;
            }
            return liveData.getValue();
        }

        public String toString() {
            return String.format("MapLiveDataStore: %s", this.map);
        }
    }

    public static final class ListLiveData<S, T extends AbstractTableGenerated<T>, U>
    extends MediatorLiveData<List<U>> {
        private final List<LiveDataListener<U>> listeners = new ArrayList<LiveDataListener<U>>();

        public ListLiveData(LiveData<List<S>> source, Function<S, Id<T>> getId, MapLiveData<Id<T>, U> mapLiveData, Function<S, U> default_) {
            super(new ArrayList());
            this.addSource(source, (newValues_, oldValues_) -> {
                LiveDataListener listener;
                int i;
                List oldValues;
                List newValues = newValues_ == null ? List.of() : newValues_;
                List list = oldValues = oldValues_ == null ? List.of() : oldValues_;
                if (newValues.size() > this.listeners.size()) {
                    i = this.listeners.size();
                    while (i < newValues.size()) {
                        final int fi = i++;
                        listener = new LiveDataListener<U>(){

                            @Override
                            public void onChange(U newValue, U oldValue) {
                                ((List)this.getValue()).set(fi, newValue);
                                this.postValue((List)this.getValue());
                            }
                        };
                        this.listeners.add(listener);
                    }
                }
                for (i = 0; i < Math.min(newValues.size(), oldValues.size()); ++i) {
                    Object newValue = newValues.get(i);
                    Object oldValue = oldValues.get(i);
                    LiveDataListener<U> listener2 = this.listeners.get(i);
                    if (newValue.equals(oldValue)) continue;
                    mapLiveData.removeListener((Id)getId.apply(oldValue), listener2);
                    mapLiveData.addListener((Id)getId.apply(newValue), listener2);
                }
                if (oldValues.size() > newValues.size()) {
                    for (i = oldValues.size() - 1; i >= newValues.size(); --i) {
                        Object oldValue = oldValues.get(i);
                        listener = this.listeners.get(i);
                        mapLiveData.removeListener((Id)getId.apply(oldValue), listener);
                        ((List)this.getValue()).remove(i);
                    }
                }
                if (newValues.size() > oldValues.size()) {
                    for (i = oldValues.size(); i < newValues.size(); ++i) {
                        Object newValue = newValues.get(i);
                        listener = this.listeners.get(i);
                        ((List)this.getValue()).add(default_.apply(newValue));
                        mapLiveData.addListener((Id)getId.apply(newValue), listener);
                    }
                }
                if (newValues.size() != oldValues.size()) {
                    this.postValue((List)this.getValue());
                }
            });
        }
    }

    public static final class MapLiveDataFromListLiveData<K, S, V>
    implements MapLiveData<K, V>,
    LiveDataListener<List<S>> {
        private final LiveData<List<S>> source;
        private final BiFunction<K, List<S>, V> make;
        private final Map<K, List<LiveDataListener<V>>> listeners = new ConcurrentHashMap<K, List<LiveDataListener<V>>>();
        private List<S> values = new ArrayList<S>();
        private boolean isPlugged = false;

        public MapLiveDataFromListLiveData(LiveData<List<S>> source, BiFunction<K, List<S>, V> make) {
            Objects.requireNonNull(make);
            this.source = source;
            this.make = make;
        }

        @Override
        public synchronized void addListener(K key, LiveDataListener<V> listener) {
            if (!this.isPlugged) {
                this.source.addListener(this);
                this.isPlugged = true;
            }
            List list = this.listeners.computeIfAbsent(key, k -> new ArrayList());
            list.add(listener);
            Object value = this.make.apply(key, this.values);
            LiveDataCallBackExecutor.LIVEDATA_CALLBACK_EXECUTOR.submitTask(() -> listener.onChange(value, null));
        }

        @Override
        public synchronized void removeListener(K key, LiveDataListener<V> listener) {
            this.listeners.get(key).remove(listener);
            if (this.listeners.isEmpty()) {
                this.source.removeListener(this);
                this.isPlugged = false;
            }
        }

        @Override
        public V getCurrentValue(K key) {
            return this.make.apply(key, this.values);
        }

        @Override
        public void onChange(List<S> newValues, List<S> oldValues) {
            this.values = newValues;
            for (K key : this.listeners.keySet()) {
                List<LiveDataListener<V>> list = this.listeners.get(key);
                V newValue = this.make.apply(key, newValues);
                V oldValue = this.make.apply(key, oldValues);
                for (LiveDataListener<V> listener : list) {
                    listener.onChange(newValue, oldValue);
                }
            }
        }
    }
}

