/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata;

import io.olvid.windows.messenger.database.tables.Table;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.MediatorLiveData;
import io.olvid.windows.messenger.livedata.MutableLiveData;
import io.olvid.windows.messenger.livedata.SwitchMapLiveData;
import io.olvid.windows.messenger.livedata.db_livedata.DbLiveDataItem;
import io.olvid.windows.messenger.livedata.db_livedata.DbLiveDataItemField;
import io.olvid.windows.messenger.livedata.db_livedata.DbLiveDataList;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class LiveDataFactory {
    private LiveDataFactory() {
    }

    public static <T extends Table> LiveData<List<T>> buildDbLiveDataList(Class<T> typeClass, Callable<List<T>> dbTask) {
        return new DbLiveDataList(dbTask, (List<Class<? extends Table>>)((List<Class<Table>>)List.of(typeClass)));
    }

    public static <T extends Table> LiveData<List<T>> buildDbLiveDataList(Class<T> typeClass, Callable<List<T>> dbTask, List<Class<? extends Table>> otherClassesToListen) {
        ArrayList<Class<? extends Table>> classesToListen = new ArrayList<Class<? extends Table>>();
        classesToListen.add(typeClass);
        classesToListen.addAll(otherClassesToListen);
        return new DbLiveDataList(dbTask, (List<Class<? extends Table>>)((List<Class<Table>>)classesToListen));
    }

    public static <T extends Table> LiveData<T> buildDbLiveDataItem(Class<T> typeClass, Callable<T> dbTask) {
        return new DbLiveDataItem<T>(dbTask, (List<Class<Table>>)List.of(typeClass));
    }

    public static <T extends Table> LiveData<T> buildDbLiveDataItem(Class<T> typeClass, Callable<T> dbTask, List<Class<? extends Table>> otherClassesToListen) {
        ArrayList<Class<? extends Table>> classesToListen = new ArrayList<Class<? extends Table>>();
        classesToListen.add(typeClass);
        classesToListen.addAll(otherClassesToListen);
        return new DbLiveDataItem<T>(dbTask, (List<Class<Table>>)classesToListen);
    }

    public static <QueryResultType> LiveData<QueryResultType> buildDbLiveDataItemField(Callable<QueryResultType> dbTask, List<Class<? extends Table>> classesToListen) {
        return new DbLiveDataItemField<QueryResultType>(dbTask, (List<Class<Table>>)classesToListen);
    }

    public static <T> MutableLiveData<T> buildMutableLiveData() {
        return new MutableLiveData();
    }

    public static <T> LiveData<Optional<T>> buildEmptyLiveData() {
        return new MutableLiveData(Optional.empty());
    }

    public static <T> MutableLiveData<T> buildMutableLiveData(T initialValue) {
        return new MutableLiveData<T>(initialValue);
    }

    public static <SourceDataType, OutputDataType> LiveData<OutputDataType> switchMap(LiveData<SourceDataType> sourceLiveData, Function<SourceDataType, LiveData<OutputDataType>> switchMapFunction) {
        if (sourceLiveData != null && switchMapFunction != null) {
            return new SwitchMapLiveData<SourceDataType, OutputDataType>(sourceLiveData, switchMapFunction);
        }
        return null;
    }

    public static <SourceDataType, OutputDataType> LiveData<OutputDataType> map(LiveData<SourceDataType> sourceLiveData, OutputDataType initialValue, Function<SourceDataType, OutputDataType> map) {
        MediatorLiveData liveData = new MediatorLiveData(initialValue);
        liveData.addSource(sourceLiveData, (newValue, oldValue) -> {
            if (newValue != null) {
                liveData.postValue(map.apply(newValue));
            }
        });
        return liveData;
    }

    public static <SourceDataType, OutputDataType> LiveData<OutputDataType> mapNullable(LiveData<SourceDataType> sourceLiveData, OutputDataType initialValue, Function<SourceDataType, OutputDataType> map) {
        MediatorLiveData liveData = new MediatorLiveData(initialValue);
        liveData.addSource(sourceLiveData, (newValue, oldValue) -> liveData.postValue(map.apply(newValue)));
        return liveData;
    }

    public static <SourceDataType, OutputDataType> LiveData<OutputDataType> switchMapWithCustomSourceCompare(LiveData<SourceDataType> sourceLiveData, Function<SourceDataType, LiveData<OutputDataType>> switchMapFunction, BiFunction<SourceDataType, SourceDataType, Boolean> compareFunc) {
        if (sourceLiveData != null && switchMapFunction != null) {
            return new SwitchMapLiveData<SourceDataType, OutputDataType>(sourceLiveData, switchMapFunction, compareFunc);
        }
        return null;
    }

    public static <T> LiveData<T> buildTimerLiveData(long periodMs, Supplier<T> compute) {
        return new TimerLiveData<T>(periodMs, compute);
    }

    private static final class TimerLiveData<T>
    extends MutableLiveData<T> {
        private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

        private TimerLiveData(long periodMs, Supplier<T> compute) {
            super(compute.get());
            this.executor.scheduleWithFixedDelay(() -> this.postValue(compute.get()), 0L, periodMs, TimeUnit.MILLISECONDS);
        }
    }
}

