/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata;

import io.olvid.windows.messenger.async.LiveDataCallBackExecutor;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.LinkedHashSet;

public abstract class LiveData<DataType> {
    protected DataType data;
    protected AppLogger loggerInstance;
    protected final LinkedHashSet<LiveDataListener<DataType>> registeredListeners = new LinkedHashSet();
    private static final boolean debug = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(LiveDataListener<DataType> listener) {
        if (listener != null) {
            boolean added;
            LinkedHashSet<LiveDataListener<DataType>> linkedHashSet = this.registeredListeners;
            synchronized (linkedHashSet) {
                added = this.registeredListeners.add(listener);
            }
            if (added) {
                LiveDataCallBackExecutor.LIVEDATA_CALLBACK_EXECUTOR.submitTask(() -> listener.onChange(this.data, null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(LiveDataListener<DataType> listener) {
        if (listener != null) {
            LinkedHashSet<LiveDataListener<DataType>> linkedHashSet = this.registeredListeners;
            synchronized (linkedHashSet) {
                if (!this.registeredListeners.remove(listener)) {
                    AppLogger.t("Tried to remove an unregistered listener");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        LinkedHashSet<LiveDataListener<DataType>> linkedHashSet = this.registeredListeners;
        synchronized (linkedHashSet) {
            this.registeredListeners.clear();
        }
    }

    public synchronized DataType getValue() {
        return this.data;
    }

    protected void postValue(DataType newValue) {
        LiveDataCallBackExecutor.LIVEDATA_CALLBACK_EXECUTOR.submitTask(() -> {
            try {
                LinkedHashSet<LiveDataListener<DataType>> tmpRegisteredListeners;
                DataType oldValue = this.data;
                this.data = newValue;
                LinkedHashSet<LiveDataListener<DataType>> linkedHashSet = this.registeredListeners;
                synchronized (linkedHashSet) {
                    tmpRegisteredListeners = new LinkedHashSet<LiveDataListener<DataType>>(this.registeredListeners);
                }
                for (LiveDataListener liveDataListener : tmpRegisteredListeners) {
                    try {
                        liveDataListener.onChange(this.data, oldValue);
                    }
                    catch (Exception e) {
                        this.loggerInstance.error("Something went wrong calling livedata listener for data type : " + String.valueOf(this.data.getClass()), e);
                    }
                }
            }
            catch (Exception e) {
                this.loggerInstance.error("Something went wrong during livedata postValue for data type : " + String.valueOf(this.data.getClass()), e);
            }
        });
    }

    public boolean hasObservers() {
        return !this.registeredListeners.isEmpty();
    }

    protected void setValue(DataType newValue) {
        this.data = newValue;
    }

    public static void debug(Object o, String fct, String format, Object ... args) {
    }
}

