/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.livedata;

import io.olvid.windows.messenger.fx.misc.CollectionUtils;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.LiveDataFactory;
import io.olvid.windows.messenger.livedata.MapLiveData;
import io.olvid.windows.messenger.livedata.MediatorLiveData;
import io.olvid.windows.messenger.misc.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public final class ListLiveData {
    private ListLiveData() {
    }

    public static <S> LiveData<Optional<S>> findFirst(LiveData<List<S>> source, Predicate<S> filter) {
        return LiveDataFactory.map(source, Optional.empty(), values -> values.stream().filter(filter).findFirst());
    }

    public static <S> LiveData<List<S>> filter(LiveData<List<S>> source, Predicate<S> filter) {
        return LiveDataFactory.map(source, List.of(), values -> values.stream().filter(filter).toList());
    }

    public static <S> LiveData<List<S>> sort(LiveData<List<S>> source, Comparator<S> comparator) {
        return LiveDataFactory.map(source, List.of(), values -> {
            ArrayList s = new ArrayList(values);
            s.sort(comparator);
            return s;
        });
    }

    public static <S, T> LiveData<List<T>> compact(LiveData<List<S>> source, Function<S, Optional<T>> compactMap) {
        return LiveDataFactory.map(source, List.of(), values -> values.stream().map(compactMap).filter(Optional::isPresent).map(Optional::get).toList());
    }

    public static <S, K> MapLiveData<K, Optional<S>> findByKey(LiveData<List<S>> source, Function<S, K> getKey) {
        return new MapLiveData.MapLiveDataFromListLiveData<Object, S, Optional>(source, (k, l) -> {
            if (l == null) {
                return Optional.empty();
            }
            return l.stream().filter(v -> getKey.apply(v).equals(k)).findFirst();
        });
    }

    public static <S, K> MapLiveData<K, List<S>> filterByKey(LiveData<List<S>> source, Function<S, K> getKey) {
        return new MapLiveData.MapLiveDataFromListLiveData<Object, S, List>(source, (k, l) -> {
            if (l == null) {
                return List.of();
            }
            return l.stream().filter(v -> getKey.apply(v).equals(k)).toList();
        });
    }

    public static <S1, S2, J> LiveData<List<Pair<S1, S2>>> join(LiveData<List<S1>> source1, LiveData<List<S2>> source2, Function<S1, J> join1, Function<S2, J> join2) {
        return new JoinLiveData<S1, S2, J>(source1, source2, join1, join2);
    }

    public static <T> LiveData<List<T>> concat(LiveData<List<T>> list1, LiveData<List<T>> list2) {
        return new ConcatListLiveData<T>(list1, list2);
    }

    private static class JoinLiveData<S1, S2, J>
    extends MediatorLiveData<List<Pair<S1, S2>>> {
        private final Function<S1, J> join1;
        private final Function<S2, J> join2;
        private List<S1> values1;
        private List<S2> values2;

        public JoinLiveData(LiveData<List<S1>> source1, LiveData<List<S2>> source2, Function<S1, J> join1, Function<S2, J> join2) {
            super(List.of());
            this.join1 = join1;
            this.join2 = join2;
            this.addSource(source1, (newValue, oldValue) -> {
                this.values1 = newValue;
                this.consolidate();
            });
            this.addSource(source2, (newValue, oldValue) -> {
                this.values2 = newValue;
                this.consolidate();
            });
        }

        private void consolidate() {
            if (this.values1 == null || this.values2 == null) {
                return;
            }
            ArrayList results = new ArrayList(this.values1.size());
            HashMap<J, S2> join = new HashMap<J, S2>(this.values2.size());
            for (S2 s2 : this.values2) {
                join.put(this.join2.apply(s2), s2);
            }
            for (Object s1 : this.values1) {
                J j = this.join1.apply(s1);
                Object s2 = join.get(j);
                if (s2 == null) continue;
                results.add(Pair.of(s1, s2));
            }
            this.postValue(results);
        }
    }

    private static class ConcatListLiveData<T>
    extends MediatorLiveData<List<T>> {
        static <T> List<T> nonNull(List<T> l) {
            return l == null ? List.of() : l;
        }

        public ConcatListLiveData(LiveData<List<T>> list1, LiveData<List<T>> list2) {
            super(null);
            this.addSource(list1, (newValue, oldValue) -> {
                if (list2.getValue() == null) {
                    return;
                }
                if (newValue == null) {
                    return;
                }
                List<T> l1 = ConcatListLiveData.nonNull(newValue);
                List l2 = (List)list2.getValue();
                this.postValue(CollectionUtils.concat(l1, l2));
            });
            this.addSource(list2, (newValue, oldValue) -> {
                if (list1.getValue() == null) {
                    return;
                }
                if (newValue == null) {
                    return;
                }
                List l1 = (List)list1.getValue();
                List<T> l2 = ConcatListLiveData.nonNull(newValue);
                this.postValue(CollectionUtils.concat(l1, l2));
            });
        }
    }
}

