/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.keycloak.protocol.enrollement;

import io.olvid.engine.engine.types.JsonKeycloakUserDetails;
import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.keycloak.KeycloakUtils;
import io.olvid.windows.messenger.keycloak.protocol.AuthenticationProtocol;
import io.olvid.windows.messenger.keycloak.protocol.EnrollementProtocol;
import io.olvid.windows.messenger.keycloak.protocol.KeycloakProtocolNC;
import io.olvid.windows.messenger.keycloak.protocol.ProtocolContext;
import io.olvid.windows.messenger.keycloak.protocol.authentication.AuthenticationProtocolContext;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import java.util.Optional;
import org.jose4j.jwk.JsonWebKey;

public final class EnrollementProtocolContext
implements ProtocolContext {
    public final KeycloakProtocolNC notificationCenter = new KeycloakProtocolNC();
    public final AuthenticationProtocol authenticationProtocol;
    private boolean authenticationRestricted;
    private String firstName;
    private String lastName;
    private String company;
    private String position;
    private byte[] ownedIdentityBytes;
    private OwnedIdentity ownedIdentity;
    private boolean ownedIdentityCreated = false;
    private JsonWebKey signatureKey;
    private JsonKeycloakUserDetails details;
    private final EnrollementProtocol.KeycloakEnrollementProtocolNotification[] notifications = EnrollementProtocol.KeycloakEnrollementProtocolNotification.values();
    private final NotificationListener<EnrollementProtocol.KeycloakEnrollementOutputNotification> protocolNotificationListener;

    public EnrollementProtocolContext(String serverUrl, String clientId, Optional<String> clientSecret, KeycloakManager.RedirectType redirectType, NotificationListener<EnrollementProtocol.KeycloakEnrollementOutputNotification> notificationListener) {
        this.authenticationProtocol = AuthenticationProtocol.of(serverUrl, clientId, clientSecret, redirectType, Optional.empty(), Either.left(this.notificationCenter));
        this.protocolNotificationListener = notificationListener;
        this.notificationCenter.subscribe(this.notifications, this.protocolNotificationListener);
        this.notificationCenter.startCenter();
    }

    @Override
    public void clear() {
        ((AuthenticationProtocolContext)this.authenticationProtocol.context).notificationCenter.unSubscribe(this.notifications, this.protocolNotificationListener);
    }

    public void setDetails(JsonKeycloakUserDetails details) {
        this.details = details;
    }

    public JsonKeycloakUserDetails getDetails() {
        return this.details;
    }

    public OwnedIdentity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public void setOwnedIdentity(OwnedIdentity ownedIdentityBytes) {
        this.ownedIdentity = ownedIdentityBytes;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public void setTransferRestricted(boolean authenticationRestricted) {
        this.authenticationRestricted = authenticationRestricted;
    }

    public boolean getTransferRestricted() {
        return this.authenticationRestricted;
    }

    public Optional<String> getOlvidServerUrl() {
        return ((AuthenticationProtocolContext)this.authenticationProtocol.context).getOlvidServerUrl();
    }

    public void setOlvidServerUrl(Optional<String> olvidServerUrl) {
        ((AuthenticationProtocolContext)this.authenticationProtocol.context).setOlvidServerUrl(olvidServerUrl);
    }

    public void fireWaitingForAuthenticationUrl() {
        this.notificationCenter.postNotification(EnrollementProtocol.WaitingForAuthenticationUrl.of());
    }

    public void fireWaitingForOwnedIdentityToBind() {
        this.notificationCenter.postNotification(EnrollementProtocol.WaitingIdentityToBind.of(this.firstName, this.lastName, this.company, this.position));
    }

    public void fireBindingNotification() {
        this.notificationCenter.postNotification(EnrollementProtocol.Binding.of());
    }

    public void fireWaitingForAuthenticationNotification(String authUrl) {
        this.notificationCenter.postNotification(EnrollementProtocol.WaitingUserForAuthentication.of(authUrl));
    }

    public void fireEnrollementSuccessNotification() {
        this.notificationCenter.postNotification(EnrollementProtocol.EnrollementSuccess.of(this.ownedIdentity));
    }

    public void fireEnrollementFailedNotification(KeycloakUtils.RfcError rfcError) {
        this.notificationCenter.postNotification(EnrollementProtocol.EnrollementFailed.of(rfcError));
    }

    public void setSignatureKey(JsonWebKey signature) {
        this.signatureKey = signature;
    }

    public JsonWebKey getSignatureKey() {
        return this.signatureKey;
    }

    public void setOwnedIdentityCreated() {
        this.ownedIdentityCreated = true;
    }

    public boolean wasIdentityCreated() {
        return this.ownedIdentityCreated;
    }
}

