/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.keycloak.protocol.authentication.steps;

import io.olvid.windows.messenger.keycloak.KeycloakCallReturn;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.keycloak.KeycloakUtils;
import io.olvid.windows.messenger.keycloak.protocol.authentication.AuthenticationProtocolContext;
import io.olvid.windows.messenger.keycloak.protocol.authentication.steps.GetAccessTokenStep;
import io.olvid.windows.messenger.keycloak.protocol.step.AbstractStep;
import io.olvid.windows.messenger.keycloak.protocol.step.WaitingStep;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.TcpMessageNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.TcpServerNC;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

public final class HandleRedirectStep
extends WaitingStep<AuthenticationProtocolContext, KeycloakUtils.RfcError> {
    private final AppLogger logger = new AppLogger(HandleRedirectStep.class);
    private final NotificationListener<TcpMessageNotification> redirectListener = this::handleRedirect;
    private Optional<KeycloakCallReturn<String>> keycloakGetCodeCallReturnOpt = Optional.empty();
    private Optional<KeycloakCallReturn<KeycloakManager.RedirectType>> keycloakGetRedirectCallReturnOpt = Optional.empty();
    private final AtomicBoolean subTaskFailed = new AtomicBoolean(false);

    @Override
    public AbstractStep.Result execute(AuthenticationProtocolContext protocolContext) {
        NCRegistry.getTCPServerNC().subscribe(TcpServerNC.TcpMessageNotificationEnumType.KEYCLOAK_AUTHENTICATION_REDIRECT_URI, this.redirectListener);
        this.executeWait();
        this.logger.debug("HandleRedirectStep::executeWait stopped waiting for notification...");
        NCRegistry.getTCPServerNC().unSubscribe(TcpServerNC.TcpMessageNotificationEnumType.KEYCLOAK_AUTHENTICATION_REDIRECT_URI, this.redirectListener);
        if (this.subTaskFailed.get()) {
            return AbstractStep.Result.FAILED;
        }
        if (this.keycloakGetRedirectCallReturnOpt.isPresent() && this.keycloakGetCodeCallReturnOpt.isPresent()) {
            KeycloakCallReturn<String> getCodeRet = this.keycloakGetCodeCallReturnOpt.get();
            KeycloakCallReturn<KeycloakManager.RedirectType> getRedirectRet = this.keycloakGetRedirectCallReturnOpt.get();
            if (getCodeRet.isSuccess() && getRedirectRet.isSuccess()) {
                protocolContext.setAuthorizationCode(getCodeRet.getResult());
                return AbstractStep.Result.SUCCESS;
            }
            return AbstractStep.Result.FAILED;
        }
        return AbstractStep.Result.FAILED;
    }

    private void handleRedirect(TcpMessageNotification tcpMessageNotification) {
        this.logger.debug("HandleRedirectStep::handleRedirect received message --> %s ", tcpMessageNotification.getNotificationType());
        if (tcpMessageNotification.getNotificationType().messageId == TcpServerNC.TcpMessageNotificationEnumType.KEYCLOAK_AUTHENTICATION_REDIRECT_URI.messageId && !tcpMessageNotification.data.isEmpty()) {
            if (KeycloakUtils.isRedirectUri(tcpMessageNotification.data)) {
                this.logger.debug("HandleRedirectStep::handleRedirect received redirect url, parsing...");
                KeycloakCallReturn<String> getCodeReturn = KeycloakUtils.getStringCodeFromRedirectUrl(tcpMessageNotification.data);
                KeycloakCallReturn<KeycloakManager.RedirectType> redirectTypeReturn = KeycloakUtils.getRedirectTypeFromUrl(tcpMessageNotification.data);
                this.keycloakGetCodeCallReturnOpt = Optional.of(getCodeReturn);
                this.keycloakGetRedirectCallReturnOpt = Optional.of(redirectTypeReturn);
            } else {
                this.subTaskFailed.set(true);
                this.failReasonOpt = KeycloakUtils.RfcError.RFC_BAD_REDIRECT_URL;
            }
        } else {
            this.logger.warning("HandleRedirectStep::handleRedirect couldn't consume notification instance of type : " + String.valueOf(tcpMessageNotification.getNotificationType()));
            this.subTaskFailed.set(true);
            this.keycloakGetCodeCallReturnOpt = Optional.of(new KeycloakCallReturn(Either.right(KeycloakUtils.RfcError.RFC_INTERNAL_ERROR)));
            this.keycloakGetRedirectCallReturnOpt = Optional.of(new KeycloakCallReturn(Either.right(KeycloakUtils.RfcError.RFC_INTERNAL_ERROR)));
            this.failReasonOpt = KeycloakUtils.RfcError.RFC_INTERNAL_ERROR;
        }
        this.stopWait.set(true);
    }

    @Override
    public AbstractStep<AuthenticationProtocolContext, KeycloakUtils.RfcError> getNextStep() {
        return new GetAccessTokenStep();
    }
}

