/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.keycloak.protocol.authentication.steps;

import io.olvid.windows.messenger.keycloak.KeycloakCallReturn;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.keycloak.KeycloakUtils;
import io.olvid.windows.messenger.keycloak.SimpleAuthState;
import io.olvid.windows.messenger.keycloak.pojos.TokenEndpointResponsePojo;
import io.olvid.windows.messenger.keycloak.protocol.authentication.AuthenticationProtocolContext;
import io.olvid.windows.messenger.keycloak.protocol.step.AbstractStep;
import io.olvid.windows.messenger.misc.BytesKey;

public final class GetAccessTokenStep
extends AbstractStep<AuthenticationProtocolContext, KeycloakUtils.RfcError> {
    @Override
    public AbstractStep.Result execute(AuthenticationProtocolContext protocolContext) {
        if (protocolContext.getAuthorizationCode() == null) {
            throw new IllegalStateException("GetAccessTokenStep::execute authorization code is null");
        }
        KeycloakCallReturn<TokenEndpointResponsePojo> accessTokenResponse = KeycloakUtils.getAccessToken(protocolContext.serverUrl, protocolContext.clientId, protocolContext.clientSecret.orElse(null), protocolContext.getAuthorizationCode(), protocolContext.getChallenge().getFirst());
        if (accessTokenResponse.isSuccess()) {
            TokenEndpointResponsePojo tokenEndpointResponsePojo = accessTokenResponse.getResult();
            SimpleAuthState simpleAuthState = new SimpleAuthState(tokenEndpointResponsePojo.getAccessToken(), tokenEndpointResponsePojo.getRefreshToken(), System.currentTimeMillis() + (long)tokenEndpointResponsePojo.getExpiresIn() * 1000L);
            protocolContext.setSimpleAuthState(simpleAuthState);
            boolean toRet = false;
            switch (protocolContext.redirectType) {
                case ENROLLEMENT: 
                case RESTRICTED: {
                    toRet = true;
                    break;
                }
                case RE_AUTH: {
                    if (!protocolContext.getOwnedIdentityBytes().isPresent()) break;
                    BytesKey ownedIdentityBytes = protocolContext.getOwnedIdentityBytes().get();
                    toRet = KeycloakManager.getInstance().reAuthenticationSuccessful(ownedIdentityBytes, protocolContext.getJsonWebKeySet(), simpleAuthState);
                }
            }
            return toRet ? AbstractStep.Result.SUCCESS : AbstractStep.Result.FAILED;
        }
        this.failReasonOpt = accessTokenResponse.getError();
        return AbstractStep.Result.FAILED;
    }

    @Override
    public AbstractStep<AuthenticationProtocolContext, KeycloakUtils.RfcError> getNextStep() {
        return null;
    }
}

