/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.keycloak.protocol;

import io.olvid.windows.messenger.keycloak.protocol.NotificationDelegate;
import io.olvid.windows.messenger.keycloak.protocol.ProtocolContext;
import io.olvid.windows.messenger.keycloak.protocol.step.AbstractStep;
import io.olvid.windows.messenger.keycloak.protocol.step.StepIterator;
import io.olvid.windows.messenger.logger.AppLogger;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;

public class StepsExecutor<C extends ProtocolContext, F extends ProtocolContext.FailReason>
extends Thread {
    private final AppLogger logger = new AppLogger(this.getClass());
    private final C context;
    private final AtomicBoolean stopLoop = new AtomicBoolean(false);
    private Optional<AbstractStep<C, F>> currentStep = Optional.empty();
    private final AbstractStep<C, F> firstStep;
    private Optional<AbstractStep<C, F>> failedStep = Optional.empty();
    private final NotificationDelegate<C, F> notificationDelegate;

    public StepsExecutor(C context, AbstractStep<C, F> firstStep, NotificationDelegate<C, F> notificationDelegate) {
        this.context = context;
        this.firstStep = firstStep;
        this.notificationDelegate = notificationDelegate;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void run() {
        Objects.requireNonNull(this.firstStep);
        StepIterator<C, F> stepIterator = new StepIterator<C, F>(this.firstStep);
        this.notificationDelegate.notifyProtocolStarted();
        block4: while (stepIterator.hasNext()) {
            Object step = stepIterator.next();
            this.currentStep = Optional.of(step);
            if (this.stopLoop.get()) break;
            AbstractStep.Result result = ((AbstractStep)step).execute(this.context);
            switch (result) {
                case SUCCESS: {
                    this.notificationDelegate.postStepNotification((AbstractStep<C, F>)step);
                    break;
                }
                case FAILED: {
                    this.stopLoop.set(true);
                    this.failedStep = Optional.of(step);
                    break block4;
                }
            }
        }
        if (this.currentStep.isPresent() && this.currentStep.get().interrupted.get()) {
            this.logger.debug("StepsExecutor::run protocol interrupted context --> %s", this.context.getClass());
            return;
        }
        this.failedStep.ifPresent(this.notificationDelegate::stepFailed);
    }

    public void stopStepExecutor() {
        this.currentStep.ifPresent(AbstractStep::interrupt);
        this.stopLoop.set(true);
    }
}

