/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.keycloak.protocol;

import io.olvid.windows.messenger.database.tables.OwnedIdentity;
import io.olvid.windows.messenger.keycloak.KeycloakManager;
import io.olvid.windows.messenger.keycloak.KeycloakUtils;
import io.olvid.windows.messenger.keycloak.protocol.AbstractProtocol;
import io.olvid.windows.messenger.keycloak.protocol.KeycloakProtocol;
import io.olvid.windows.messenger.keycloak.protocol.StepsExecutor;
import io.olvid.windows.messenger.keycloak.protocol.enrollement.EnrollementProtocolContext;
import io.olvid.windows.messenger.keycloak.protocol.enrollement.steps.AuthenticationChildProtocolStep;
import io.olvid.windows.messenger.keycloak.protocol.enrollement.steps.BindIdentityStep;
import io.olvid.windows.messenger.keycloak.protocol.enrollement.steps.GetOwnedDetailsStep;
import io.olvid.windows.messenger.keycloak.protocol.enrollement.steps.RegisterIdentityToEngineStep;
import io.olvid.windows.messenger.keycloak.protocol.step.AbstractStep;
import io.olvid.windows.messenger.misc.BytesKey;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationType;
import java.util.Optional;

public final class EnrollementProtocol
extends AbstractProtocol<EnrollementProtocolContext, KeycloakUtils.RfcError>
implements KeycloakProtocol {
    public EnrollementProtocol(String keycloakServerUrl, String clientId, String clientSecret, NotificationListener<KeycloakEnrollementOutputNotification> notificationListener) {
        this.context = new EnrollementProtocolContext(keycloakServerUrl, clientId, Optional.ofNullable(clientSecret), KeycloakManager.RedirectType.ENROLLEMENT, notificationListener);
        this.stepsExecutor = new StepsExecutor<EnrollementProtocolContext, KeycloakUtils.RfcError>((EnrollementProtocolContext)this.context, new AuthenticationChildProtocolStep(), this);
    }

    @Override
    public void notifyProtocolStarted() {
        ((EnrollementProtocolContext)this.context).fireWaitingForAuthenticationUrl();
    }

    @Override
    public void postStepNotification(AbstractStep<EnrollementProtocolContext, KeycloakUtils.RfcError> step) {
        if (step instanceof GetOwnedDetailsStep) {
            GetOwnedDetailsStep getOwnedDetailsStep = (GetOwnedDetailsStep)step;
            ((EnrollementProtocolContext)this.context).fireWaitingForOwnedIdentityToBind();
        } else if (step instanceof RegisterIdentityToEngineStep) {
            RegisterIdentityToEngineStep registerIdentityToEngineStep = (RegisterIdentityToEngineStep)step;
            ((EnrollementProtocolContext)this.context).fireBindingNotification();
        } else if (step instanceof BindIdentityStep) {
            BindIdentityStep bindIdentityStep = (BindIdentityStep)step;
            ((EnrollementProtocolContext)this.context).fireEnrollementSuccessNotification();
        }
    }

    @Override
    public void stepFailed(AbstractStep<EnrollementProtocolContext, KeycloakUtils.RfcError> step) {
        ((EnrollementProtocolContext)this.context).fireEnrollementFailedNotification(step.getFailReason());
    }

    public void fireShareIdentityToBindNotification(Optional<BytesKey> ownedIdentityBytes) {
        ((EnrollementProtocolContext)this.context).notificationCenter.postNotification(ShareIdentityToBindInputNotification.of(ownedIdentityBytes));
    }

    public record ShareIdentityToBindInputNotification(Optional<BytesKey> ownedIdentity) implements KeycloakEnrollementInputNotification
    {
        public static ShareIdentityToBindInputNotification of(Optional<BytesKey> ownedIdentity) {
            return new ShareIdentityToBindInputNotification(ownedIdentity);
        }

        @Override
        public NotificationType.NotificationEnumType getNotificationType() {
            return KeycloakEnrollementProtocolUserInputNotification.SHARE_IDENTITY_TO_BIND;
        }
    }

    public record WaitingUserForAuthentication(String authUrl) implements KeycloakEnrollementOutputNotification
    {
        public static WaitingUserForAuthentication of(String authUrl) {
            return new WaitingUserForAuthentication(authUrl);
        }

        @Override
        public NotificationType.NotificationEnumType getNotificationType() {
            return KeycloakEnrollementProtocolNotification.WAITING_AUTHENTICATION_URL;
        }
    }

    public record WaitingForAuthenticationUrl() implements KeycloakEnrollementOutputNotification
    {
        public static WaitingForAuthenticationUrl of() {
            return new WaitingForAuthenticationUrl();
        }

        @Override
        public NotificationType.NotificationEnumType getNotificationType() {
            return KeycloakEnrollementProtocolNotification.WAITING_AUTHENTICATION_URL;
        }
    }

    public record WaitingForOwnedDetails() implements KeycloakEnrollementOutputNotification
    {
        public static WaitingForOwnedDetails of() {
            return new WaitingForOwnedDetails();
        }

        @Override
        public NotificationType.NotificationEnumType getNotificationType() {
            return KeycloakEnrollementProtocolNotification.WAITING_FOR_OWNED_DETAILS;
        }
    }

    public record WaitingIdentityToBind(String firstName, String lastName, String company, String position) implements KeycloakEnrollementOutputNotification
    {
        public static WaitingIdentityToBind of(String firstName, String lastName, String company, String position) {
            return new WaitingIdentityToBind(firstName, lastName, company, position);
        }

        @Override
        public NotificationType.NotificationEnumType getNotificationType() {
            return KeycloakEnrollementProtocolNotification.WAITING_FOR_ID_BINDING;
        }
    }

    public record Binding() implements KeycloakEnrollementOutputNotification
    {
        public static Binding of() {
            return new Binding();
        }

        @Override
        public NotificationType.NotificationEnumType getNotificationType() {
            return KeycloakEnrollementProtocolNotification.WAITING_FOR_ID_BINDING;
        }
    }

    public record EnrollementFailed(KeycloakUtils.RfcError reason) implements KeycloakEnrollementOutputNotification
    {
        public static EnrollementFailed of(KeycloakUtils.RfcError rfcError) {
            return new EnrollementFailed(rfcError);
        }

        @Override
        public NotificationType.NotificationEnumType getNotificationType() {
            return KeycloakEnrollementProtocolNotification.FAILURE;
        }
    }

    public record EnrollementSuccess(OwnedIdentity ownedIdentity) implements KeycloakEnrollementOutputNotification
    {
        public static EnrollementSuccess of(OwnedIdentity ownedIdentity) {
            return new EnrollementSuccess(ownedIdentity);
        }

        @Override
        public NotificationType.NotificationEnumType getNotificationType() {
            return KeycloakEnrollementProtocolNotification.SUCCESS;
        }
    }

    public static sealed interface KeycloakEnrollementInputNotification
    extends NotificationType
    permits ShareIdentityToBindInputNotification {
    }

    public static sealed interface KeycloakEnrollementOutputNotification
    extends NotificationType
    permits WaitingUserForAuthentication, WaitingForAuthenticationUrl, WaitingForOwnedDetails, Binding, WaitingIdentityToBind, EnrollementSuccess, EnrollementFailed {
    }

    public static enum KeycloakEnrollementProtocolUserInputNotification implements NotificationType.NotificationEnumType
    {
        SHARE_IDENTITY_TO_BIND;

    }

    public static enum KeycloakEnrollementProtocolNotification implements NotificationType.NotificationEnumType
    {
        WAITING_AUTHENTICATION_URL,
        WAITING_FOR_AUTHENTICATION_RESULT,
        WAITING_FOR_OWNED_DETAILS,
        WAITING_FOR_IDENTITY_TO_BIND,
        WAITING_FOR_ID_BINDING,
        BIND_ID_TO_KC,
        SUCCESS,
        FAILURE;

    }
}

