/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.keycloak.listeners;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.main_stack.MainStackManager;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlow;
import io.olvid.windows.messenger.fx.main_stack.identity_management_layer.mainflow.IdentityManagementFlowModel;
import io.olvid.windows.messenger.keycloak.KeycloakUtils;
import io.olvid.windows.messenger.keycloak.pojos.ConfigurationPojo;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.TcpMessageNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.TcpServerNC;
import io.olvid.windows.messenger.misc.state_pattern.FlowStackContext;

public class KeycloakConfigurationUrlListener
implements NotificationListener<TcpMessageNotification> {
    private final IdentityManagementFlowModel model;
    private final FlowStackContext<IdentityManagementFlow> identityCreationFlowContext;

    public KeycloakConfigurationUrlListener(IdentityManagementFlowModel model, FlowStackContext<IdentityManagementFlow> identityCreationFlowContext) {
        this.model = model;
        this.identityCreationFlowContext = identityCreationFlowContext;
    }

    @Override
    public void onReceived(TcpMessageNotification tcpMessageNotification) {
        AppLogger.d("KeycloakConfigurationUrlListener::onReceived() type : " + String.valueOf(tcpMessageNotification.getNotificationType()));
        if (tcpMessageNotification.getNotificationType().messageId == TcpServerNC.TcpMessageNotificationEnumType.KEYCLOAK_CONFIGURATION_URI.messageId) {
            if (KeycloakUtils.isConfigurationUri(tcpMessageNotification.data)) {
                AsyncTaskExecutor.submitTask(() -> {
                    String confUrl = tcpMessageNotification.data;
                    ConfigurationPojo configurationKeycloakPojo = this.model.setAndLoadConfiguration(confUrl);
                    if (configurationKeycloakPojo != null) {
                        ViewControllerHelper.smartUIUpdate(() -> {
                            this.model.getKeycloakModel().setConfigurationValid(true);
                            this.model.getKeycloakModel().setConfiguration(configurationKeycloakPojo);
                            this.identityCreationFlowContext.pushState(IdentityManagementFlow.KEYCLOAK, IdentityManagementFlow.KeycloakState.KEYCLOAK_CONFIGURATION);
                            MainStackManager.displayedLayerState.pushState(MainStackManager.DisplayedLayerWrapper.of(MainStackManager.DisplayedLayer.OWNED_IDENTITY_MANAGEMENT));
                            ViewControllerHelper.MAIN_STAGE.toFront();
                        });
                    } else {
                        ViewControllerHelper.smartUIUpdate(() -> this.model.getKeycloakModel().setConfigurationValid(false));
                    }
                });
            } else {
                ViewControllerHelper.smartUIUpdate(() -> this.model.getKeycloakModel().setConfigurationValid(false));
            }
        }
    }
}

