/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.keycloak;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.engine.engine.types.JsonKeycloakUserDetails;
import io.olvid.engine.engine.types.RegisterApiKeyResult;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.engine.engine.types.identities.ObvKeycloakState;
import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.engine.EngineWrapper;
import io.olvid.windows.messenger.engine.api.TransferApi;
import io.olvid.windows.messenger.keycloak.KeycloakCallReturn;
import io.olvid.windows.messenger.keycloak.KeycloakManagerState;
import io.olvid.windows.messenger.keycloak.KeycloakUtils;
import io.olvid.windows.messenger.keycloak.SimpleAuthState;
import io.olvid.windows.messenger.keycloak.pojos.GetGroupsResponsePojo;
import io.olvid.windows.messenger.keycloak.pojos.KeycloakSearchResponsePojo;
import io.olvid.windows.messenger.keycloak.pojos.MeResponseJson;
import io.olvid.windows.messenger.keycloak.protocol.AuthenticationProtocol;
import io.olvid.windows.messenger.keycloak.protocol.EnrollementProtocol;
import io.olvid.windows.messenger.keycloak.protocol.KeycloakProtocol;
import io.olvid.windows.messenger.keycloak.protocol.TransferRestrictedAuthenticationProtocol;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.BytesKey;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.Pair;
import io.olvid.windows.messenger.misc.notification_pattern.NotificationListener;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.UtilityNC;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakManager {
    private static final Logger log = LoggerFactory.getLogger(KeycloakManager.class);
    private static KeycloakManager INSTANCE = null;
    public static final int MAX_SYNC_FAIL_COUNT = 5;
    private static final int MAX_API_KEY_REGISTRATION_RETRIES = 10;
    private static final int BASE_TIME_API_REGISTRATION_RETRY_MS = 2000;
    public static final long SYNCHRONIZATION_INTERVAL_MS = 21600000L;
    public static final long OWN_SIGNED_DETAILS_RENEWAL_INTERVAL_MILLIS = 604800000L;
    public static final long REVOCATION_LIST_LATEST_TIMESTAMP_OVERLAP_MILLIS = 3600000L;
    private final Map<BytesKey, KeycloakManagerState> ownedIdentityStates;
    private final Set<BytesKey> currentlySyncingOwnedIdentities;
    private final Timer retryTimer;
    private final AppLogger logger = new AppLogger(this.getClass());
    private Optional<KeycloakProtocol> protocolInProgress = Optional.empty();

    private KeycloakManager() {
        AppLogger.d("KeycloakManager::KeycloakManager");
        this.ownedIdentityStates = new ConcurrentHashMap<BytesKey, KeycloakManagerState>();
        this.currentlySyncingOwnedIdentities = ConcurrentHashMap.newKeySet();
        this.retryTimer = new Timer("KeycloakManagerRetryTimer");
    }

    public static synchronized KeycloakManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new KeycloakManager();
        }
        return INSTANCE;
    }

    public static void stop() {
        KeycloakUtils.stopThread();
    }

    public void init() {
        try {
            ObvIdentity[] ownedIdentities;
            for (ObvIdentity ownedIdentity : ownedIdentities = EngineWrapper.getInstance().getOwnedIdentities()) {
                ObvKeycloakState keycloakState;
                if (!ownedIdentity.isKeycloakManaged() || !ownedIdentity.isActive() || (keycloakState = EngineWrapper.getInstance().getOwnedIdentityKeycloakState(ownedIdentity.getBytesIdentity())) == null || !this.registerKeycloakManagedIdentity(ownedIdentity.getBytesIdentity(), keycloakState.keycloakServer, keycloakState.clientId, keycloakState.clientSecret, keycloakState.jwks, keycloakState.signatureKey, keycloakState.serializedAuthState, keycloakState.ownApiKey, keycloakState.latestRevocationListTimestamp, true, keycloakState.transferRestricted)) continue;
                this.selfTestAndPromptForAuthentication(BytesKey.of(ownedIdentity.getBytesIdentity()), true);
            }
        }
        catch (Exception e) {
            this.logger.error("init : couldn't interact with engine to get fkaOwnedIdentity list or associated keycloak state for some reason... ", e);
        }
    }

    public void startEnrollementProtocol(String kcUrl, String clientId, Optional<String> clientSecret, NotificationListener<EnrollementProtocol.KeycloakEnrollementOutputNotification> notificationListener) {
        Objects.requireNonNull(kcUrl);
        Objects.requireNonNull(clientId);
        Objects.requireNonNull(notificationListener);
        if (kcUrl.isEmpty() || clientId.isEmpty()) {
            throw new IllegalStateException("KeycloakManager::startEnrollementProtocol illegal null or empty args for authentication");
        }
        EnrollementProtocol protocolInProgress = new EnrollementProtocol(kcUrl, clientId, clientSecret.orElse(null), notificationListener);
        protocolInProgress.start();
        this.protocolInProgress = Optional.of(protocolInProgress);
    }

    public void startAuthenticationProtocol(byte[] ownedIdentityBytes, NotificationListener<AuthenticationProtocol.KeycloakAuthenticationNotification> notificationListener) {
        KeycloakManagerState kms = this.ownedIdentityStates.get(BytesKey.of(ownedIdentityBytes));
        if (kms == null) {
            throw new IllegalStateException("KeycloakManager::startAuthenticationProtocol can't find keycloak state for identity");
        }
        AuthenticationProtocol authenticationProtocol = AuthenticationProtocol.of(kms.serverUrl, kms.clientId, Optional.ofNullable(kms.clientSecret), RedirectType.RE_AUTH, Optional.of(BytesKey.of(ownedIdentityBytes)), Either.right(notificationListener));
        authenticationProtocol.start();
        this.protocolInProgress = Optional.of(authenticationProtocol);
    }

    public synchronized void startTransferAuthenticationProtocol(String keycloakServerUrl, String clientId, String clientSecret, String sas, String sessionNumber, BytesKey dummyOwnedIdentity, TransferApi.Step transferStep, UUID dialogUUID, Encoded encodedElements, NotificationListener<TransferRestrictedAuthenticationProtocol.KeycloakTransfertRestrictedAuthenticationNotification> notificationListener) {
        Objects.requireNonNull(keycloakServerUrl);
        Objects.requireNonNull(clientId);
        Objects.requireNonNull(sas);
        Objects.requireNonNull(sessionNumber);
        Objects.requireNonNull(dummyOwnedIdentity);
        Objects.requireNonNull(transferStep);
        Objects.requireNonNull(dialogUUID);
        Objects.requireNonNull(encodedElements);
        Objects.requireNonNull(notificationListener);
        if (keycloakServerUrl.isEmpty() || clientId.isEmpty()) {
            throw new IllegalStateException("KeycloakManager::startTransferAuthenticationProtocol illegal null or empty args for authentication");
        }
        TransferRestrictedAuthenticationProtocol transferRestrictedAuthenticationProtocol = TransferRestrictedAuthenticationProtocol.of(keycloakServerUrl, clientId, Optional.ofNullable(clientSecret), sas, sessionNumber, dummyOwnedIdentity, transferStep, dialogUUID, encodedElements, notificationListener);
        transferRestrictedAuthenticationProtocol.start();
        this.protocolInProgress = Optional.of(transferRestrictedAuthenticationProtocol);
    }

    public synchronized void stopEnrollementProtocol() {
        KeycloakProtocol running;
        if (this.protocolInProgress.isEmpty()) {
            this.logger.error("KeycloakManager::stopEnrollementProtocol no protocol currently running");
            return;
        }
        KeycloakProtocol keycloakProtocol = running = this.protocolInProgress.get();
        Objects.requireNonNull(keycloakProtocol);
        KeycloakProtocol keycloakProtocol2 = keycloakProtocol;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AuthenticationProtocol.class, EnrollementProtocol.class, TransferRestrictedAuthenticationProtocol.class}, (Object)keycloakProtocol2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                AuthenticationProtocol ignored = (AuthenticationProtocol)keycloakProtocol2;
                this.logger.error("KeycloakManager::stopTransferAuthenticationProtocol authentication protocol running");
                break;
            }
            case 1: {
                EnrollementProtocol enrollementProtocol = (EnrollementProtocol)keycloakProtocol2;
                enrollementProtocol.stop();
                this.protocolInProgress = Optional.empty();
                break;
            }
            case 2: {
                TransferRestrictedAuthenticationProtocol ignored = (TransferRestrictedAuthenticationProtocol)keycloakProtocol2;
                this.logger.error("KeycloakManager::stopTransferAuthenticationProtocol transfer restricted protocol running");
            }
        }
    }

    public synchronized void stopTransferAuthenticationProtocol() {
        KeycloakProtocol running;
        if (this.protocolInProgress.isEmpty()) {
            this.logger.error("KeycloakManager::stopTransferAuthenticationProtocol no protocol currently running");
            return;
        }
        KeycloakProtocol keycloakProtocol = running = this.protocolInProgress.get();
        Objects.requireNonNull(keycloakProtocol);
        KeycloakProtocol keycloakProtocol2 = keycloakProtocol;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AuthenticationProtocol.class, EnrollementProtocol.class, TransferRestrictedAuthenticationProtocol.class}, (Object)keycloakProtocol2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                AuthenticationProtocol authenticationProtocol = (AuthenticationProtocol)keycloakProtocol2;
                this.logger.error("KeycloakManager::stopTransferAuthenticationProtocol authentication protocol running");
                break;
            }
            case 1: {
                EnrollementProtocol enrollementProtocol = (EnrollementProtocol)keycloakProtocol2;
                this.logger.error("KeycloakManager::stopTransferAuthenticationProtocol enrollement protocol running");
                break;
            }
            case 2: {
                TransferRestrictedAuthenticationProtocol transferRestrictedAuthenticationProtocol = (TransferRestrictedAuthenticationProtocol)keycloakProtocol2;
                transferRestrictedAuthenticationProtocol.stop();
                this.protocolInProgress = Optional.empty();
            }
        }
    }

    public synchronized void stopAuthenticationProtocol() {
        KeycloakProtocol running;
        if (this.protocolInProgress.isEmpty()) {
            this.logger.error("KeycloakManager::stopTransferAuthenticationProtocol no protocol currently running");
            return;
        }
        KeycloakProtocol keycloakProtocol = running = this.protocolInProgress.get();
        Objects.requireNonNull(keycloakProtocol);
        KeycloakProtocol keycloakProtocol2 = keycloakProtocol;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AuthenticationProtocol.class, EnrollementProtocol.class, TransferRestrictedAuthenticationProtocol.class}, (Object)keycloakProtocol2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                AuthenticationProtocol authenticationProtocol = (AuthenticationProtocol)keycloakProtocol2;
                authenticationProtocol.stop();
                this.protocolInProgress = Optional.empty();
                break;
            }
            case 1: {
                EnrollementProtocol enrollementProtocol = (EnrollementProtocol)keycloakProtocol2;
                this.logger.error("KeycloakManager::stopEnrollementProtocol enrollement protocol running");
                break;
            }
            case 2: {
                TransferRestrictedAuthenticationProtocol ignored = (TransferRestrictedAuthenticationProtocol)keycloakProtocol2;
                this.logger.error("KeycloakManager::stopEnrollementProtocol enrollement protocol running");
            }
        }
    }

    public boolean registerKeycloakManagedIdentity(byte[] obvIdentityBytes, String keycloakServerUrl, String clientId, String clientSecret, JsonWebKeySet jwks, JsonWebKey signatureKey, String serializedAuthState, String ownApiKey, long latestRevocationListTimestamp, boolean doNotSync, boolean transferRestricted) {
        ObvIdentity obvIdentity;
        this.logger.trace("KeycloakManager::registerKeycloakManagedIdentity");
        try {
            obvIdentity = EngineWrapper.getInstance().getObvIdentity(obvIdentityBytes);
        }
        catch (Exception e) {
            this.logger.error("registerKeycloakManagedIdentity : Couldn't retrieve obv identity from engine for keycloak binding...", e);
            return false;
        }
        SimpleAuthState authState = null;
        if (serializedAuthState != null) {
            try {
                authState = (SimpleAuthState)KeycloakUtils.getJsonObjectMapper().readValue(serializedAuthState, SimpleAuthState.class);
            }
            catch (JsonProcessingException e) {
                this.logger.error("Error deserializing SimpleAuthState", (Exception)((Object)e));
                return false;
            }
        }
        KeycloakManagerState keycloakManagerState = new KeycloakManagerState(obvIdentity, keycloakServerUrl, clientId, clientSecret, authState, jwks, signatureKey, ownApiKey, latestRevocationListTimestamp, transferRestricted);
        BytesKey identityBytesKey = new BytesKey(keycloakManagerState.bytesOwnedIdentity);
        this.ownedIdentityStates.put(identityBytesKey, keycloakManagerState);
        if (!doNotSync) {
            this.synchronizeIdentityWithKeycloak(identityBytesKey, 0);
        }
        return true;
    }

    public void shareIdentityToBind(Optional<BytesKey> ownedIdentityToBind) {
        KeycloakProtocol protocol;
        if (this.protocolInProgress.isEmpty()) {
            this.logger.error("KeycloakManager::shareIdenityToBind no protocol in progress, nothing can be done here");
            return;
        }
        KeycloakProtocol keycloakProtocol = protocol = this.protocolInProgress.get();
        Objects.requireNonNull(keycloakProtocol);
        KeycloakProtocol keycloakProtocol2 = keycloakProtocol;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AuthenticationProtocol.class, EnrollementProtocol.class, TransferRestrictedAuthenticationProtocol.class}, (Object)keycloakProtocol2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                AuthenticationProtocol authenticationProtocol = (AuthenticationProtocol)keycloakProtocol2;
                this.logger.error("KeycloakManager::shareIdenityToBind AUTHENTICATION_PROTOCOL in progress, nothing can be done here");
                break;
            }
            case 1: {
                EnrollementProtocol enrollementProtocol = (EnrollementProtocol)keycloakProtocol2;
                this.logger.debug("KeycloakManager::shareIdenityToBind ENROLLEMENT_PROTOCOL in progress, sharing identity to bind");
                enrollementProtocol.fireShareIdentityToBindNotification(ownedIdentityToBind);
                break;
            }
            case 2: {
                TransferRestrictedAuthenticationProtocol transferRestrictedAuthenticationProtocol = (TransferRestrictedAuthenticationProtocol)keycloakProtocol2;
                this.logger.error("KeycloakManager::shareIdenityToBind Transfer Restricted Authentication in progress, nothing can be done here");
            }
        }
    }

    public KeycloakCallReturn<Boolean> bindOwnedIdentityToKeycloakInEngine(byte[] bytesOwnedIdentity, String serverUrl, String clientId, String clientSecret, JsonWebKeySet jwks, JsonWebKey signatureKey, String serializedAuthState, long latestRevocationListTimestamp, long latestGroupUpdateTimestamp, String keycloakUserId, boolean transferRestricted) {
        ObvKeycloakState obvKeycloakState = new ObvKeycloakState(serverUrl, clientId, clientSecret, jwks, signatureKey, serializedAuthState, transferRestricted, null, latestRevocationListTimestamp, latestGroupUpdateTimestamp);
        ObvIdentity obvIdentity = EngineWrapper.getInstance().bindOwnedIdentityToKeycloak(bytesOwnedIdentity, obvKeycloakState, keycloakUserId);
        if (obvIdentity != null) {
            return new KeycloakCallReturn<Boolean>(Either.left(true));
        }
        return new KeycloakCallReturn<Boolean>(Either.right(KeycloakUtils.RfcError.RFC_INTERNAL_ERROR));
    }

    public void unregisterKeycloakManagedIdentity(byte[] bytesOwnedIdentity) {
        AppLogger.d("KeycloakManager::unregisterKeycloakManagedIdentity");
        BytesKey identityBytesKey = new BytesKey(bytesOwnedIdentity);
        this.ownedIdentityStates.remove(identityBytesKey);
        this.currentlySyncingOwnedIdentities.remove(identityBytesKey);
    }

    public void forceSyncManagedIdentity(byte[] bytesOwnedIdentity) {
        BytesKey identityBytesKey = new BytesKey(bytesOwnedIdentity);
        KeycloakManagerState kms = KeycloakManager.getInstance().ownedIdentityStates.get(identityBytesKey);
        if (kms != null) {
            kms.lastSynchronization = 0L;
            KeycloakManager.getInstance().synchronizeIdentityWithKeycloak(identityBytesKey, 0);
        }
    }

    public void forceSelfTestAndReauthentication(byte[] bytesOwnedIdentity, boolean skipNonceheck) {
        AppLogger.t("KeycloakManager::forceSelfTestAndReauthentication");
        BytesKey identityBytesKey = new BytesKey(bytesOwnedIdentity);
        KeycloakManagerState kms = KeycloakManager.getInstance().ownedIdentityStates.get(identityBytesKey);
        if (kms != null && this.selfTestAndPromptForAuthentication(identityBytesKey, skipNonceheck)) {
            this.logger.debug("KeycloakManager::forceSelfTestAndReauthentication POSTING KEYCLOAK_AUTHENTICATION_REQUIRED_NOTIFICATION");
            UtilityNC.fireAuthenticationRequiredNotification(kms.bytesOwnedIdentity);
        }
    }

    public void processPushTopicNotification(String pushTopic) {
        AppLogger.t("KeycloakManager::processPushTopicNotification");
        try {
            Collection<ObvIdentity> obvIdentities = EngineWrapper.getInstance().getOwnedIdentitiesWithKeycloakPushTopic(pushTopic);
            for (ObvIdentity obvIdentity : obvIdentities) {
                this.forceSyncManagedIdentity(obvIdentity.getBytesIdentity());
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to retrieve identities with a push topic...", e);
        }
    }

    public synchronized boolean reAuthenticationSuccessful(BytesKey ownedIdentity, JsonWebKeySet jks, SimpleAuthState simpleAuthState) {
        AppLogger.d("KeycloakManager::reAuthenticationSuccessful");
        if (jks == null || ownedIdentity == null) {
            throw new IllegalArgumentException("KeycloakManager::reAuthenticationSuccessful illegal null arg");
        }
        KeycloakManagerState kms = this.ownedIdentityStates.get(ownedIdentity);
        if (kms == null) {
            return false;
        }
        kms.lastSynchronization = 0L;
        kms.jwks = jks;
        kms.simpleAuthState = simpleAuthState;
        try {
            EngineWrapper.getInstance().saveKeycloakJwks(ownedIdentity.bytes, jks.toJson());
            EngineWrapper.getInstance().saveKeycloakAuthState(ownedIdentity.bytes, KeycloakUtils.getJsonObjectMapper().writeValueAsString((Object)simpleAuthState));
        }
        catch (JsonProcessingException e) {
            AppLogger.e("KeycloakManager::reAuthenticationSuccessful couldn't serialize simple auth state", (Exception)((Object)e));
        }
        catch (Exception e) {
            AppLogger.e("KeycloakManager::reAuthenticationSuccessful failed to save simple auth state or jkws to engine", e);
            return false;
        }
        this.synchronizeIdentityWithKeycloak(ownedIdentity, 0);
        return true;
    }

    public KeycloakCallReturn<Integer> uploadOwnIdentity(byte[] bytesOwnedIdentity) {
        this.logger.trace("KeycloakManager::uploadOwnIdentity");
        final BytesKey identityBytesKey = new BytesKey(bytesOwnedIdentity);
        KeycloakManagerState kms = this.ownedIdentityStates.get(identityBytesKey);
        if (kms == null) {
            return new KeycloakCallReturn<Integer>(Either.right(KeycloakUtils.RfcError.RFC_IDENTITY_NOT_MANAGED));
        }
        if (kms.getSimpleAuthState() == null) {
            this.synchronizeIdentityWithKeycloak(identityBytesKey, 0);
            return new KeycloakCallReturn<Integer>(Either.right(KeycloakUtils.RfcError.RFC_AUTHENTICATION_REQUIRED));
        }
        kms.autoRevokeOnNextSync = true;
        KeycloakCallReturn<Integer> ret = KeycloakUtils.uploadOwnIdentity(kms.serverUrl, kms.getSimpleAuthState(), kms.clientSecret, kms.clientId, bytesOwnedIdentity);
        if (ret.isSuccess()) {
            kms.autoRevokeOnNextSync = false;
            this.synchronizeIdentityWithKeycloak(identityBytesKey, 0);
            return ret;
        }
        switch (ret.getError()) {
            case RFC_AUTHENTICATION_REQUIRED: {
                if (!this.selfTestAndPromptForAuthentication(identityBytesKey, false)) break;
                this.logger.debug("KeycloakManager::uploadOwnIdentity POSTING KEYCLOAKAUTHENTICATIONREQUIREDNOTIFICATION");
                UtilityNC.fireAuthenticationRequiredNotification(kms.bytesOwnedIdentity);
                break;
            }
            case RFC_IDENTITY_ALREADY_UPLOADED: {
                this.logger.warning("uploadIdentity returned RFC_IDENTITY_ALREADY_UPLOADED");
                break;
            }
            case RFC_IDENTITY_REVOKED: {
                this.logger.warning("uploadIdentity returned RFC_IDENTITY_REVOKED");
                break;
            }
            default: {
                this.retryTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        KeycloakManager.this.synchronizeIdentityWithKeycloak(identityBytesKey, 1);
                    }
                }, 500L);
            }
        }
        return ret;
    }

    public KeycloakCallReturn<KeycloakSearchResponsePojo> search(byte[] bytesOwnedIdentity, String searchQuery) {
        this.logger.trace("KeycloakManager::search");
        BytesKey identityBytesKey = new BytesKey(bytesOwnedIdentity);
        KeycloakManagerState kms = this.ownedIdentityStates.get(identityBytesKey);
        if (kms == null) {
            return new KeycloakCallReturn<KeycloakSearchResponsePojo>(Either.right(KeycloakUtils.RfcError.RFC_IDENTITY_NOT_MANAGED));
        }
        if (kms.simpleAuthState == null) {
            this.synchronizeIdentityWithKeycloak(identityBytesKey, 0);
            return new KeycloakCallReturn<KeycloakSearchResponsePojo>(Either.right(KeycloakUtils.RfcError.RFC_AUTHENTICATION_REQUIRED));
        }
        KeycloakCallReturn<KeycloakSearchResponsePojo> codeWithResponse = KeycloakUtils.search(kms.bytesOwnedIdentity, kms.serverUrl, kms.simpleAuthState, kms.clientId, kms.clientSecret, searchQuery);
        if (!codeWithResponse.isSuccess()) {
            this.keycloakSearchFailed(bytesOwnedIdentity, codeWithResponse.getError());
        }
        return codeWithResponse;
    }

    public KeycloakCallReturn<Integer> addContact(byte[] bytesOwnedIdentity, String contactUserId, byte[] bytesContactIdentity) {
        AppLogger.t("KeycloakManager::addContact");
        BytesKey identityBytesKey = new BytesKey(bytesOwnedIdentity);
        KeycloakManagerState kms = this.ownedIdentityStates.get(identityBytesKey);
        KeycloakCallReturn<Integer> responseCode = KeycloakUtils.addContact(kms.serverUrl, kms.simpleAuthState, kms.jwks, kms.signatureKey, bytesOwnedIdentity, contactUserId, bytesContactIdentity);
        if (!responseCode.isSuccess()) {
            this.keycloakAddContactFailed(bytesOwnedIdentity, responseCode.getError());
        }
        return responseCode;
    }

    public void addContactWithEngineSignedDetails(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) {
        AppLogger.t("KeycloakManager::addContactWithEngineSignedDetails");
        KeycloakUtils.addContactWithEngineSignedDetails(bytesOwnedIdentity, bytesContactIdentity);
    }

    public void unbindOwnedIdentityFromKeycloak(byte[] ownedIdentitybytes) {
        AppLogger.d("KeycloakManager::unbindOwnedIdentityfromKeycloak");
        EngineWrapper.getInstance().unbindOwnedIdentityFromKeycloak(ownedIdentitybytes);
    }

    public static void synchronizeAllManagedIdentities() {
        Objects.requireNonNull(INSTANCE);
        AppLogger.d("KeycloakManager::synchronizeAllManagedIdentities");
        for (BytesKey identityBytesKey : KeycloakManager.getInstance().ownedIdentityStates.keySet()) {
            KeycloakManager.getInstance().synchronizeIdentityWithKeycloak(identityBytesKey, 0);
        }
    }

    public boolean setNullKeyAndForceSynchronize(byte[] ownedIdentityBytes) {
        try {
            EngineWrapper.getInstance().setOwnedIdentityKeycloakSignatureKey(ownedIdentityBytes, null);
            KeycloakManager.getInstance().forceSyncManagedIdentity(ownedIdentityBytes);
            return true;
        }
        catch (Exception e) {
            this.logger.error("setNullKeyAndForceSynchronize Fail downloaded owned details ", e);
            return false;
        }
    }

    public boolean selfTestAndPromptForAuthentication(BytesKey identityBytesKey, boolean skipNonceCheck) {
        KeycloakManagerState kms = this.ownedIdentityStates.get(identityBytesKey);
        if (kms != null) {
            if (skipNonceCheck) {
                KeycloakCallReturn<MeResponseJson> me = KeycloakManager.getMe(kms);
                return !me.isSuccess() && me.getError() == KeycloakUtils.RfcError.RFC_AUTHENTICATION_REQUIRED;
            }
            String nonce = EngineWrapper.getInstance().getOwnedIdentityKeycloakSelfRevocationTestNonce(kms.bytesOwnedIdentity, kms.serverUrl);
            if (nonce == null) {
                return true;
            }
            KeycloakCallReturn<Boolean> codeWithResult = KeycloakUtils.selfRevocationTest(kms.serverUrl, nonce);
            if (codeWithResult.isSuccess()) {
                if (codeWithResult.getResult().booleanValue()) {
                    EngineWrapper.getInstance().unbindOwnedIdentityFromKeycloak(kms.bytesOwnedIdentity);
                } else {
                    KeycloakCallReturn<MeResponseJson> me = KeycloakManager.getMe(kms);
                    if (!me.isSuccess() && me.getError() == KeycloakUtils.RfcError.RFC_AUTHENTICATION_REQUIRED) {
                        return true;
                    }
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private static KeycloakCallReturn<MeResponseJson> getMe(KeycloakManagerState kms) {
        return KeycloakUtils.getOwnDetails(kms.bytesOwnedIdentity, kms.serverUrl, kms.clientSecret, kms.clientId, Math.max(0L, kms.latestRevocationListTimestamp - 3600000L), kms.simpleAuthState);
    }

    public boolean isOwnedIdentityTransferRestricted(BytesKey identityBytesKey) {
        KeycloakManagerState kms = this.ownedIdentityStates.get(identityBytesKey);
        if (kms == null) {
            return false;
        }
        return kms.transferRestricted;
    }

    public synchronized Optional<String> getSerializedAuthState(byte[] ownedIdentityBytes) {
        KeycloakManagerState kms = this.ownedIdentityStates.get(BytesKey.of(ownedIdentityBytes));
        if (kms == null) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable(KeycloakUtils.getJsonObjectMapper().writeValueAsString((Object)kms.simpleAuthState));
        }
        catch (JsonProcessingException e) {
            this.logger.error("KeycloakManager::getSerializedAuthState couldn't serialize auth state ");
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void synchronizeIdentityWithKeycloak(BytesKey identityBytesKey, int failedAttempts) {
        KeycloakCallReturn<GetGroupsResponsePojo> codeWithGroupsResponse;
        MeResponseJson meResponseJson;
        KeycloakManagerState kms;
        block42: {
            block41: {
                AppLogger.d("KeycloakManager::synchronizeIdentityWithKeycloak");
                kms = this.ownedIdentityStates.get(identityBytesKey);
                if (kms == null) {
                    return;
                }
                if (System.currentTimeMillis() - kms.lastSynchronization < 21600000L) {
                    return;
                }
                if (!this.currentlySyncingOwnedIdentities.add(identityBytesKey)) {
                    return;
                }
                KeycloakCallReturn<JsonWebKeySet> discoverResult = KeycloakUtils.discoverKeycloakServer(kms.serverUrl);
                if (!discoverResult.isSuccess()) {
                    AsyncTaskExecutor.submitTask(() -> this.synchronizeIdentityWithKeycloak(identityBytesKey, failedAttempts + 1));
                    return;
                }
                kms.jwks = discoverResult.getResult();
                if (kms.jwks == null || kms.getSimpleAuthState() == null) {
                    this.currentlySyncingOwnedIdentities.remove(identityBytesKey);
                    if (!this.selfTestAndPromptForAuthentication(identityBytesKey, false)) return;
                    this.logger.debug("KeycloakManager::synchronizeIdentityWithKeycloak POSTING KEYCLOAKAUTHENTICATIONREQUIREDNOTIFICATION");
                    UtilityNC.fireAuthenticationRequiredNotification(kms.bytesOwnedIdentity);
                    return;
                }
                KeycloakCallReturn<MeResponseJson> codeWithResponse = KeycloakManager.getMe(kms);
                if (!codeWithResponse.isSuccess()) {
                    this.getOwnDetailsFailed(identityBytesKey, codeWithResponse.getError(), failedAttempts);
                    return;
                }
                AppLogger.d("Successfully downloaded own details from keycloak server");
                meResponseJson = codeWithResponse.getResult();
                JsonKeycloakUserDetails userDetails = null;
                try {
                    JsonIdentityDetails serverJsonIdentityDetails;
                    block40: {
                        block39: {
                            Integer minimumBuildVersion;
                            this.currentlySyncingOwnedIdentities.remove(identityBytesKey);
                            KeycloakCallReturn<Pair<String, JsonWebKey>> detailsJsonStringAndSignatureKey = KeycloakUtils.verifyDetailsSignature(meResponseJson.signature, kms.jwks, null);
                            if (!detailsJsonStringAndSignatureKey.isSuccess()) {
                                AppLogger.d("KeycloakManager::synchronizeIdentityWithKeycloak couldn't verify details signature ");
                                UtilityNC.fireAuthenticationRequiredNotification(kms.bytesOwnedIdentity);
                                return;
                            }
                            userDetails = (JsonKeycloakUserDetails)KeycloakUtils.getJsonObjectMapper().readValue(detailsJsonStringAndSignatureKey.getResult().getFirst(), JsonKeycloakUserDetails.class);
                            kms = this.ownedIdentityStates.get(identityBytesKey);
                            if (kms == null) {
                                return;
                            }
                            if (kms.getSimpleAuthState() == null) {
                                AsyncTaskExecutor.submitTask(() -> this.synchronizeIdentityWithKeycloak(identityBytesKey, 0));
                                return;
                            }
                            if (meResponseJson.minimumBuildVersions != null && (minimumBuildVersion = meResponseJson.minimumBuildVersions.get("desktop")) != null && minimumBuildVersion < -1) {
                                AppLogger.d("KeycloakManager::synchronizeIdentityWithKeycloakSuccessfully Outdated desktop version");
                            }
                            try {
                                if (detailsJsonStringAndSignatureKey.getResult().getSecond() == null) break block39;
                                JsonWebKey previousKey = EngineWrapper.getInstance().getOwnedIdentityKeycloakSignatureKey(kms.bytesOwnedIdentity);
                                if (previousKey == null) {
                                    EngineWrapper.getInstance().setOwnedIdentityKeycloakSignatureKey(kms.bytesOwnedIdentity, detailsJsonStringAndSignatureKey.getResult().getSecond());
                                    kms.signatureKey = detailsJsonStringAndSignatureKey.getResult().getSecond();
                                } else if (!Arrays.equals(previousKey.calculateThumbprint("SHA-256"), detailsJsonStringAndSignatureKey.getResult().getSecond().calculateThumbprint("SHA-256"))) {
                                    AppLogger.d("KeycloakManager::synchronizeIdentityWithKeycloak Successfully signature key changed");
                                    UtilityNC.fireKeycloakDetailsSignatureKeyUpdated(kms.bytesOwnedIdentity);
                                    return;
                                }
                            }
                            catch (Exception e) {
                                AppLogger.e("KeycloakManager::synchronizeIdentityWithKeycloak engine getOwnedIdentityKeycloakSignatureKey failed ", e);
                                return;
                            }
                        }
                        try {
                            String previousId = EngineWrapper.getInstance().getOwnedIdentityKeycloakUserId(kms.bytesOwnedIdentity);
                            if (previousId == null && userDetails != null) {
                                EngineWrapper.getInstance().setOwnedIdentityKeycloakUserId(kms.bytesOwnedIdentity, userDetails.getId());
                                break block40;
                            }
                            if (userDetails != null && !previousId.equals(userDetails.getId())) {
                                if (!Arrays.equals(userDetails.getIdentity(), kms.bytesOwnedIdentity)) return;
                                EngineWrapper.getInstance().setOwnedIdentityKeycloakUserId(kms.bytesOwnedIdentity, userDetails.getId());
                            }
                        }
                        catch (Exception e) {
                            AppLogger.e("KeycloakManager::synchronizeIdentityWithKeycloak engine getOwnedIdentityKeycloakSignatureKey failed ", e);
                            return;
                        }
                    }
                    if (userDetails != null && (userDetails.getIdentity() == null || userDetails.getIdentity().length == 0 || kms.autoRevokeOnNextSync && meResponseJson.revocationAllowed.booleanValue() && !Arrays.equals(userDetails.getIdentity(), identityBytesKey.bytes))) {
                        this.currentlySyncingOwnedIdentities.add(identityBytesKey);
                        KeycloakCallReturn<Integer> uploadReturn = KeycloakUtils.uploadOwnIdentity(kms.serverUrl, kms.simpleAuthState, kms.clientSecret, kms.clientId, identityBytesKey.bytes);
                        if (uploadReturn.isSuccess()) {
                            AppLogger.d("KeycloakUtils::synchronizeIdentityWithKeycloak Successfully uploaded own key");
                            this.currentlySyncingOwnedIdentities.remove(identityBytesKey);
                            kms.autoRevokeOnNextSync = false;
                            AsyncTaskExecutor.submitTask(() -> this.synchronizeIdentityWithKeycloak(identityBytesKey, 0));
                            return;
                        }
                        AppLogger.d("KeycloakUtils::synchronizeIdentityWithKeycloak Failed to upload own key " + String.valueOf(uploadReturn));
                        this.uploadIdentityFailed(identityBytesKey, kms, uploadReturn.getError(), failedAttempts);
                        return;
                    }
                    if (userDetails != null && !Arrays.equals(userDetails.getIdentity(), identityBytesKey.bytes) && meResponseJson.revocationAllowed.booleanValue()) {
                        UtilityNC.fireKeycloakIdentityReplacementNotification(identityBytesKey.bytes, true);
                        return;
                    }
                    if (userDetails != null && !Arrays.equals(userDetails.getIdentity(), identityBytesKey.bytes)) {
                        UtilityNC.fireKeycloakIdentityReplacementNotification(identityBytesKey.bytes, false);
                        return;
                    }
                    if (userDetails == null || kms.identityDetails.equals((Object)(serverJsonIdentityDetails = userDetails.getIdentityDetails(meResponseJson.signature))) && (kms.ownDetailsSignatureTimestamp != null || userDetails.getTimestamp() == null) && (kms.ownDetailsSignatureTimestamp == null || userDetails.getTimestamp() == null || kms.ownDetailsSignatureTimestamp + 604800000L >= userDetails.getTimestamp())) break block41;
                    try {
                        AppLogger.i("Refreshing keycloak owned details in engine");
                        EngineWrapper.getInstance().updateLatestIdentityDetails(identityBytesKey.bytes, serverJsonIdentityDetails);
                        EngineWrapper.getInstance().publishLatestIdentityDetails(identityBytesKey.bytes);
                        kms.identityDetails = serverJsonIdentityDetails;
                        kms.ownDetailsSignatureTimestamp = userDetails.getTimestamp();
                    }
                    catch (Exception e) {
                        this.rescheduleSync(identityBytesKey, failedAttempts + 1, 21601000L);
                        return;
                    }
                }
                catch (JsonProcessingException jsonProcessingException) {
                    AppLogger.e("KeycloakManager::synchronizeIdentityWithKeycloak  Couldn't deserialize User Details", (Exception)((Object)jsonProcessingException));
                    this.rescheduleSync(identityBytesKey, failedAttempts + 1, 500L);
                    return;
                }
            }
            if (meResponseJson.apiKey != null) {
                try {
                    UUID newApiKey = UUID.fromString(meResponseJson.apiKey);
                    if (Objects.equals(io.olvid.engine.Logger.getUuidString((UUID)newApiKey), kms.ownApiKey)) break block42;
                    int failures = 0;
                    while (failures < 10) {
                        RegisterApiKeyResult resultStatus = EngineWrapper.getInstance().registerOwnedIdentityApiKeyOnServer(identityBytesKey.bytes, newApiKey);
                        this.logger.debug("KeycloakManager::synchronizeIdentityWithKeycloak registerOwnedIdentityApiKeyOnServer returned : " + resultStatus.toString());
                        switch (resultStatus) {
                            case SUCCESS: {
                                EngineWrapper.getInstance().saveKeycloakApiKey(identityBytesKey.bytes, meResponseJson.apiKey);
                                kms.ownApiKey = meResponseJson.apiKey;
                                break block42;
                            }
                            case WAIT_FOR_SERVER_SESSION: {
                                this.logger.debug("KeycloakManager::synchronizeIdentityWithKeycloak registerOwnedIdentityApiKeyOnServer received WAIT_FOR_SERVER_SESSION, waiting a bit and retry (failed " + (failures + 1) + " time(s)");
                                Thread.sleep(2000L);
                                ++failures;
                                break;
                            }
                            case INVALID_KEY: 
                            case FAILED: {
                                break block42;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error("KeycloakManager::synchronizeIdentityWithKeycloak API key registration error while calling engine...", e);
                }
            }
        }
        EngineWrapper.getInstance().updateKeycloakPushTopicsIfNeeded(kms.bytesOwnedIdentity, kms.serverUrl, meResponseJson.pushTopics);
        EngineWrapper.getInstance().setOwnedIdentityKeycloakSelfRevocationTestNonce(kms.bytesOwnedIdentity, kms.serverUrl, meResponseJson.selfRevocationTestNonce);
        if (meResponseJson.signedRevocations != null) {
            EngineWrapper.getInstance().updateKeycloakRevocationList(identityBytesKey.bytes, meResponseJson.currentTimestamp, meResponseJson.signedRevocations);
            kms.latestRevocationListTimestamp = meResponseJson.currentTimestamp;
        }
        if ((codeWithGroupsResponse = KeycloakUtils.getGroups(kms.serverUrl, kms.simpleAuthState, kms.clientSecret, kms.clientId, kms.bytesOwnedIdentity, kms.latestGetGroupsTimestamp)).isSuccess()) {
            EngineWrapper.getInstance().updateKeycloakGroups(kms.bytesOwnedIdentity, codeWithGroupsResponse.getResult().getSignedGroupBlobs(), codeWithGroupsResponse.getResult().getSignedGroupDeletions(), codeWithGroupsResponse.getResult().getSignedGroupKicks(), codeWithGroupsResponse.getResult().getCurrentTimestamp());
        } else {
            AppLogger.e("KeycloakManager::synchronizeIdentityWithKeycloak: cannot download groups: " + String.valueOf(codeWithGroupsResponse.getError()));
        }
        kms.lastSynchronization = System.currentTimeMillis();
        this.rescheduleSync(identityBytesKey, failedAttempts, 21601000L);
    }

    private void getOwnDetailsFailed(BytesKey identityBytesKey, KeycloakUtils.RfcError code, int failedAttempts) {
        this.logger.debug("KeycloakManager::getOwnDetailsFailed Fail downloaded owned details ");
        this.currentlySyncingOwnedIdentities.remove(identityBytesKey);
        switch (code) {
            case RFC_AUTHENTICATION_REQUIRED: {
                if (!this.selfTestAndPromptForAuthentication(identityBytesKey, false)) break;
                this.logger.debug("KeycloakManager::getOwnDetailsFailed POSTING KEYCLOAKAUTHENTICATIONREQUIREDNOTIFICATION");
                UtilityNC.fireAuthenticationRequiredNotification(identityBytesKey.bytes);
                break;
            }
            case RFC_SERVER_ERROR: 
            case RFC_INVALID_DETAILS_SIGNATURE: 
            case RFC_BAD_RESPONSE: 
            case RFC_NETWORK_ERROR: 
            case RFC_INTERNAL_ERROR: {
                this.rescheduleSync(identityBytesKey, failedAttempts + 1, 500L);
            }
        }
    }

    private void rescheduleSync(final BytesKey identityBytesKey, final int failedAttempts, long delay) {
        if (failedAttempts < 5) {
            this.retryTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    KeycloakManager.this.synchronizeIdentityWithKeycloak(identityBytesKey, failedAttempts + 1);
                }
            }, delay << failedAttempts);
        }
    }

    private void uploadIdentityFailed(final BytesKey identityBytesKey, KeycloakManagerState kms, KeycloakUtils.RfcError uploadReturn, final int failedAttempts) {
        this.logger.debug("KeycloakManager::uploadIdentityFailed");
        this.currentlySyncingOwnedIdentities.remove(identityBytesKey);
        switch (uploadReturn) {
            case RFC_AUTHENTICATION_REQUIRED: 
            case RFC_IDENTITY_REVOKED: {
                kms.simpleAuthState = null;
                break;
            }
            case RFC_IDENTITY_ALREADY_UPLOADED: {
                UtilityNC.fireKeycloakIdentityReplacementNotification(identityBytesKey.bytes, false);
            }
        }
        if (failedAttempts < 5) {
            this.retryTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    KeycloakManager.this.synchronizeIdentityWithKeycloak(identityBytesKey, failedAttempts + 1);
                }
            }, 500L << failedAttempts);
        }
    }

    private void keycloakSearchFailed(byte[] ownedIdentityBytes, KeycloakUtils.RfcError rfc) {
        switch (rfc) {
            case RFC_AUTHENTICATION_REQUIRED: {
                this.logger.debug("KeycloakManager::keycloakSearchFailed RFC_AUTHENTICATION_REQUIRED");
                BytesKey identityBytesKey = new BytesKey(ownedIdentityBytes);
                if (!this.selfTestAndPromptForAuthentication(identityBytesKey, false)) break;
                this.logger.debug("KeycloakManager::keycloakSearchFailed POSTING KEYCLOAKAUTHENTICATIONREQUIREDNOTIFICATION");
                UtilityNC.fireAuthenticationRequiredNotification(identityBytesKey.bytes);
                break;
            }
            case RFC_NETWORK_ERROR: {
                this.logger.error("keycloakSearchFailed RFC_NETWORK_ERROR");
                break;
            }
            case RFC_SERVER_ERROR: {
                this.logger.error("keycloakSearchFailed RFC_SERVER_ERROR");
                break;
            }
            case RFC_INTERNAL_ERROR: {
                this.logger.error("keycloakSearchFailed RFC_UNKNOWN_ERROR");
                break;
            }
            default: {
                this.logger.error("keycloakSearchFailed \"default\" error : " + String.valueOf(rfc));
            }
        }
    }

    private void keycloakAddContactFailed(byte[] ownedIdentityBytes, KeycloakUtils.RfcError rfc) {
        this.logger.trace("KeycloakManager::keycloakAddContactFailed ");
        switch (rfc) {
            case RFC_AUTHENTICATION_REQUIRED: {
                this.logger.error("KeycloakManager::keycloakAddContactFailed RFC_AUTHENTICATION_REQUIRED");
                BytesKey identityBytesKey = new BytesKey(ownedIdentityBytes);
                if (!this.selfTestAndPromptForAuthentication(identityBytesKey, false)) break;
                this.logger.debug("KeycloakManager::keycloakAddContactFailed POSTING KEYCLOAKAUTHENTICATIONREQUIREDNOTIFICATION");
                UtilityNC.fireAuthenticationRequiredNotification(identityBytesKey.bytes);
                break;
            }
            case RFC_SERVER_ERROR: 
            case RFC_INVALID_DETAILS_SIGNATURE: 
            case RFC_NETWORK_ERROR: 
            case RFC_INTERNAL_ERROR: {
                this.logger.error("KeycloakManager::keycloakAddContactFailed General error code : " + String.valueOf(rfc));
            }
        }
    }

    public static enum RedirectType {
        ENROLLEMENT,
        RE_AUTH,
        RESTRICTED;

    }
}

