/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.notifications;

import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.settings.SettingsModalModel;
import io.olvid.windows.messenger.fx.settings.components.ComboSettingItemView;
import io.olvid.windows.messenger.fx.settings.components.ToggleSettingItemView;
import io.olvid.windows.messenger.fx.settings.misc.MuteDuration;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

public class NotificationSettingsViewController
extends BaseViewController {
    public VBox root = new VBox();
    public final HBox header = new HBox();
    public final Region headerVSep = new Region();
    public final ToggleSettingItemView enableNotificationToggle = new ToggleSettingItemView();
    public final ComboSettingItemView<MuteDuration> muteNotificationComboSetting;
    public final ToggleSettingItemView hideNotificationContent = new ToggleSettingItemView();
    public final Label linuxDistrosLabel = new Label(ViewControllerHelper.getString("settings_notification_disabled_on_linux_distros_label"));
    private final SettingsModalModel model;

    public NotificationSettingsViewController(SettingsModalModel model) {
        this.model = model;
        this.headerVSep.setMaxHeight(1.0);
        this.headerVSep.setPrefHeight(1.0);
        VBox.setMargin((Node)this.headerVSep, (Insets)new Insets(0.0, 0.0, 8.0, 0.0));
        this.headerVSep.getStyleClass().add((Object)"separator");
        this.linuxDistrosLabel.getStyleClass().addAll((Object[])new String[]{"body-1", "black-text"});
        this.enableNotificationToggle.settingLabel.setText(ViewControllerHelper.getString("settings_enable_notifications_label"));
        this.enableNotificationToggle.twitch.selectedProperty().bind((ObservableValue)model.muteDurationProp.isEqualTo((Object)MuteDuration.NONE));
        this.enableNotificationToggle.setAction(model::toggleNotification);
        this.muteNotificationComboSetting = new ComboSettingItemView<MuteDuration>(FXCollections.observableArrayList((Object[])MuteDuration.values()), model.getMuteDurationCombo());
        this.muteNotificationComboSetting.comboBox.valueProperty().bindBidirectional(model.muteDurationProp);
        this.muteNotificationComboSetting.settingLabel.setText(ViewControllerHelper.getString("settings_disable_notification_for_label"));
        this.muteNotificationComboSetting.visibleProperty().bind((ObservableValue)model.muteDurationProp.isNotEqualTo((Object)MuteDuration.NONE));
        this.muteNotificationComboSetting.managedProperty().bind((ObservableValue)this.muteNotificationComboSetting.visibleProperty());
        this.hideNotificationContent.settingLabel.setText(ViewControllerHelper.getString("pref_hide_notification_content_label"));
        this.hideNotificationContent.twitch.selectedProperty().bind((ObservableValue)model.hideNotificationContent);
        this.hideNotificationContent.setAction(model::setHideNotificationContentPref);
        this.root.setSpacing(20.0);
        this.root.setPadding(new Insets(24.0, 24.0, 0.0, 24.0));
        if (AppRuntimeHelper.isLinux()) {
            this.root.getChildren().addAll((Object[])new Node[]{this.headerVSep, this.linuxDistrosLabel});
        } else {
            this.root.getChildren().addAll((Object[])new Node[]{this.headerVSep, this.enableNotificationToggle, this.muteNotificationComboSetting, this.hideNotificationContent});
        }
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }
}

