/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.misc;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.management.DbManager;
import io.olvid.windows.messenger.database.tables.Discussion;
import io.olvid.windows.messenger.database.tables.Id;
import io.olvid.windows.messenger.engine.helpers.standalone_interfaces.AppSettingsHelper;
import io.olvid.windows.messenger.fx.custom_components.custom_context_menu.ContextMenuItem;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.settings.components.ComboSettingItemView;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ScheduleNextMuteDurationNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import javafx.scene.control.MenuItem;
import javax.swing.JMenuItem;

public enum MuteDuration implements ComboSettingItemView.ComboItem
{
    NONE,
    ONE_HOUR,
    INDEFINITELY;


    public Long getTimestamp() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> null;
            case 1 -> System.currentTimeMillis() + Duration.ofHours(1L).toMillis();
            case 2 -> -1L;
        };
    }

    private String getLabelKey() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "unmute";
            case 1 -> "mute_one_hour";
            case 2 -> "mute_indefinitely";
        };
    }

    private List<String> getStyle() {
        return List.of();
    }

    @Override
    public String title() {
        return ViewControllerHelper.getString(this.getLabelKey());
    }

    public String toStringValue() {
        return this.getTimestamp() == null ? null : this.getTimestamp().toString();
    }

    @Override
    public void update() {
        AppSettingsHelper.updateMuteDuration(this);
        NCRegistry.getUtilityNC().postNotification(new ScheduleNextMuteDurationNotification());
    }

    public JMenuItem getJMenuItem() {
        JMenuItem item = new JMenuItem(this.title());
        item.addActionListener(a -> AsyncTaskExecutor.submitTask(() -> {
            AppSettingsHelper.updateMuteDuration(this);
            NCRegistry.getUtilityNC().postNotification(new ScheduleNextMuteDurationNotification());
        }));
        return item;
    }

    public MenuItem getFxMenuItem(Id<Discussion> discussionId) {
        return new ContextMenuItem(this.title(), Optional.empty(), () -> AsyncTaskExecutor.submitTask(() -> {
            DbManager.getInstance().getDiscussionCustomizationDao().updateMuteNotificationsTimestamp(discussionId, this.getTimestamp());
            NCRegistry.getUtilityNC().postNotification(new ScheduleNextMuteDurationNotification());
        }), this.getStyle(), 300.0);
    }

    public MenuItem getFxMenuItem() {
        return new ContextMenuItem(this.title(), Optional.empty(), () -> AsyncTaskExecutor.submitTask(() -> {
            AppSettingsHelper.updateMuteDuration(this);
            NCRegistry.getUtilityNC().postNotification(new ScheduleNextMuteDurationNotification());
        }), this.getStyle(), 300.0);
    }
}

