/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.general;

import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.settings.SettingsModalModel;
import io.olvid.windows.messenger.fx.settings.components.ComboSettingItemView;
import io.olvid.windows.messenger.fx.settings.components.ToggleSettingItemView;
import io.olvid.windows.messenger.fx.settings.general.GeneralSettingsViewModel;
import io.olvid.windows.messenger.fx.settings.misc.AutomaticAttachmentSizeDlThreshold;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.util.Arrays;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

public class GeneralSettingViewController
extends BaseViewController {
    public VBox root = new VBox();
    public final Region headerVSep = new Region();
    public final GeneralSettingsViewModel generalSettingsViewModel = new GeneralSettingsViewModel();
    public final ToggleSettingItemView launchOnStartTSwitch = new ToggleSettingItemView();
    public final ToggleSettingItemView backgroundLaunchTswitch = new ToggleSettingItemView();
    public final ComboSettingItemView<AutomaticAttachmentSizeDlThreshold> automaticAttachmentSizeDlThresholdCombo = new ComboSettingItemView(FXCollections.observableList(Arrays.stream(AutomaticAttachmentSizeDlThreshold.values()).toList()), Optional.empty());
    public final ToggleSettingItemView sendReadReceiptTswitch = new ToggleSettingItemView();
    private final SettingsModalModel model;

    public GeneralSettingViewController(SettingsModalModel model) {
        this.model = model;
        this.headerVSep.setMaxHeight(1.0);
        this.headerVSep.setPrefHeight(1.0);
        VBox.setMargin((Node)this.headerVSep, (Insets)new Insets(0.0, 0.0, 8.0, 0.0));
        this.headerVSep.getStyleClass().add((Object)"separator");
        this.launchOnStartTSwitch.settingLabel.setText(ViewControllerHelper.getString("launch_at_startup"));
        this.launchOnStartTSwitch.setAction(model::setLaunchOnStart);
        this.launchOnStartTSwitch.twitch.selectedProperty().bind((ObservableValue)model.launchOnStartProp);
        this.launchOnStartTSwitch.visibleProperty().bind((ObservableValue)model.notificationCenterAvailableProp);
        this.launchOnStartTSwitch.managedProperty().bind((ObservableValue)this.launchOnStartTSwitch.visibleProperty());
        this.backgroundLaunchTswitch.settingLabel.setText(ViewControllerHelper.getString("launch_in_background"));
        this.backgroundLaunchTswitch.setAction(model::setLaunchInBackground);
        this.backgroundLaunchTswitch.twitch.selectedProperty().bind((ObservableValue)model.launchInBackgroundProp);
        this.backgroundLaunchTswitch.visibleProperty().bind((ObservableValue)model.launchOnStartProp);
        this.backgroundLaunchTswitch.managedProperty().bind((ObservableValue)this.backgroundLaunchTswitch.visibleProperty());
        this.sendReadReceiptTswitch.settingLabel.setText(ViewControllerHelper.getString("send_receipt_setting_item_label"));
        this.sendReadReceiptTswitch.setAction(model::setSendReadReceipt);
        this.sendReadReceiptTswitch.twitch.selectedProperty().bind((ObservableValue)model.sendReadReceiptProp);
        this.automaticAttachmentSizeDlThresholdCombo.comboBox.valueProperty().bindBidirectional(model.automaticAttachmentSizeDlThreshold);
        this.automaticAttachmentSizeDlThresholdCombo.settingLabel.setText(ViewControllerHelper.getString("attachment_auto_download_threshold_setting_item_label"));
        this.root.setSpacing(20.0);
        this.root.setPadding(new Insets(24.0, 24.0, 0.0, 24.0));
        if (AppRuntimeHelper.isLinux()) {
            this.root.getChildren().addAll((Object[])new Node[]{this.headerVSep, this.sendReadReceiptTswitch, this.automaticAttachmentSizeDlThresholdCombo});
        } else {
            this.root.getChildren().addAll((Object[])new Node[]{this.headerVSep, this.launchOnStartTSwitch, this.backgroundLaunchTswitch, this.sendReadReceiptTswitch, this.automaticAttachmentSizeDlThresholdCombo});
        }
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }
}

