/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.devices;

import io.olvid.windows.messenger.database.tables.OwnedDevice;
import io.olvid.windows.messenger.fx.custom_components.custom_context_menu.ContextMenuFactory;
import io.olvid.windows.messenger.fx.framework.utils.NodeCell;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.settings.devices.DeviceRowView;
import io.olvid.windows.messenger.fx.settings.devices.DeviceSettingsViewModel;
import io.olvid.windows.messenger.livedata.LiveData;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

public class DeviceSettingViewController
extends BaseViewController {
    private static final double CELL_HEIGHT = 64.0;
    private static final int MAX_VISIBLE_ROWS = 6;
    private static final double ROW_SEPARATOR_PX = 1.0;
    private final DeviceSettingsViewModel viewModel;
    public VBox root = new VBox(12.0);
    private final ListView<OwnedDevice> devices = new ListView();
    private final ListChangeListener<OwnedDevice> listChangeRefresh = c -> this.devices.refresh();

    public DeviceSettingViewController(Runnable closeModalDelegate, LiveData<OwnedIdentityInfo> ownedIdentityLiveData) {
        this.viewModel = new DeviceSettingsViewModel(closeModalDelegate, ownedIdentityLiveData);
        this.configureRoot();
        this.configureDevicesListView();
        this.root.getChildren().addAll((Object[])new Node[]{this.devices, this.createAddButton()});
    }

    @Override
    public Region getLayout() {
        return this.root;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }

    private void configureRoot() {
        this.root.setPadding(new Insets(10.0, 16.0, 10.0, 16.0));
    }

    private void configureDevicesListView() {
        this.devices.itemsProperty().bind(this.viewModel.ownedDeviceListProperty());
        this.devices.getStyleClass().add((Object)"device-list");
        this.devices.setPlaceholder((Node)new Label("Aucun appareil"));
        this.devices.setFixedCellSize(64.0);
        this.devices.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.viewModel.ownedDeviceListProperty().addListener((obs, oldList, newList) -> {
            if (oldList != null) {
                oldList.removeListener(this.listChangeRefresh);
            }
            if (newList != null) {
                newList.addListener(this.listChangeRefresh);
            }
            this.devices.refresh();
        });
        this.devices.setCellFactory(lv -> {
            DeviceRowView v = new DeviceRowView(this::openCellMenu, this.viewModel.ownedIdentityInfoProperty(), this.viewModel.multiDeviceProperty());
            v.setOnRenameDeviceCallback(this::onRenameDevice);
            return new NodeCell<OwnedDevice>((Node)v.root, v::bind);
        });
        DeviceSettingViewController.bindListViewHeight(this.devices, 64.0, 6);
    }

    private static void bindListViewHeight(ListView<?> lv, double fixedCell, int maxRows) {
        lv.setFixedCellSize(fixedCell);
        DoubleBinding pref = Bindings.createDoubleBinding(() -> {
            int n = lv.getItems() == null ? 0 : lv.getItems().size();
            int rows = Math.min(Math.max(n, 1), maxRows);
            Insets in = lv.getInsets();
            double insets = in == null ? 0.0 : in.getTop() + in.getBottom();
            double separators = rows > 0 ? (double)(rows - 1) * 1.0 : 0.0;
            double h = (double)rows * lv.getFixedCellSize() + insets + separators + 0.5;
            return Math.ceil(h);
        }, (Observable[])new Observable[]{lv.getItems(), lv.insetsProperty(), lv.fixedCellSizeProperty()});
        lv.prefHeightProperty().bind((ObservableValue)pref);
        lv.maxHeightProperty().bind((ObservableValue)pref);
    }

    private Button createAddButton() {
        Region plusIcon = DeviceSettingViewController.createIcon("icon-add", 28.0, 28.0);
        plusIcon.setStyle("-fx-background-color: #111827;");
        double scale = 0.5714285714285714;
        plusIcon.setScaleX(scale);
        plusIcon.setScaleY(scale);
        Button addButton = new Button("Ajouter un appareil", (Node)plusIcon);
        addButton.setMnemonicParsing(false);
        addButton.getStyleClass().add((Object)"add-device");
        addButton.setMinHeight(64.0);
        addButton.setMaxHeight(64.0);
        addButton.setMaxWidth(Double.MAX_VALUE);
        addButton.setAlignment(Pos.CENTER_LEFT);
        addButton.setGraphicTextGap(8.0);
        addButton.setOnAction(e -> this.onAddDevice());
        return addButton;
    }

    private static Region createIcon(String cssClass, double w, double h) {
        Region r = new Region();
        r.getStyleClass().add((Object)cssClass);
        r.setMinSize(w, h);
        r.setPrefSize(w, h);
        return r;
    }

    private void onAddDevice() {
        this.viewModel.addDevice();
    }

    private void onRenameDevice(OwnedDevice device) {
        this.viewModel.renameDevice(device);
    }

    private void openCellMenu(Button anchor, List<MenuItem> items) {
        Bounds b = anchor.localToScreen(anchor.getBoundsInLocal());
        ContextMenuFactory.loadContextMenuWithScreenCoordinates(b.getMaxX(), (b.getMinY() + b.getMaxY()) / 2.0, items);
    }
}

