/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.devices;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.database.tables.OwnedDevice;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.fx.custom_components.custom_context_menu.ContextMenuItem;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.framework.utils.FxIcons;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.confirmation.ConfirmModalController;
import io.olvid.windows.messenger.livedata.info.OwnedIdentityInfo;
import io.olvid.windows.messenger.logger.AppLogger;
import io.olvid.windows.messenger.misc.DateUtils;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public final class DeviceRowView {
    final AppLogger logger = new AppLogger(this.getClass());
    public final HBox root = new HBox(12.0);
    public final Button menu = new Button();
    private final Label title = new Label();
    private final Label subtitle = new Label();
    private final Label badge = new Label();
    private final VBox texts = new VBox(2.0);
    private final Region spacer = new Region();
    private final BiConsumer<Button, List<MenuItem>> openMenu;
    private OwnedDevice ownedDevice;
    private Consumer<OwnedDevice> onRenameDeviceCallback;
    private final BooleanProperty multidevice = new SimpleBooleanProperty(false);
    private final ObjectProperty<OwnedIdentityInfo> ownedIdentityInfoObjectProperty = new SimpleObjectProperty();

    public DeviceRowView(BiConsumer<Button, List<MenuItem>> openMenu, ObjectProperty<OwnedIdentityInfo> ownedIdentityInfo, BooleanProperty multiDevice) {
        this.openMenu = Objects.requireNonNull(openMenu);
        this.multidevice.bind((ObservableValue)multiDevice);
        this.ownedIdentityInfoObjectProperty.bind(ownedIdentityInfo);
        this.buildGraphic();
    }

    private void buildGraphic() {
        this.title.getStyleClass().add((Object)"device-title");
        this.subtitle.getStyleClass().add((Object)"device-subtitle");
        this.badge.getStyleClass().add((Object)"device-badge");
        this.badge.setVisible(false);
        this.badge.setManaged(false);
        SvgSizeable menuIcon = new SvgSizeable();
        menuIcon.getStyleClass().addAll((Object[])new String[]{"svg-menu", "icon-medium", "icon-black"});
        this.menu.getStyleClass().add((Object)"device-menu");
        this.menu.setGraphic((Node)menuIcon);
        this.menu.setOnMouseClicked(e -> this.openMenu.accept(this.menu, this.buildMenuItems()));
        this.texts.getChildren().addAll((Object[])new Node[]{this.title, this.subtitle});
        HBox.setHgrow((Node)this.texts, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.spacer, (Priority)Priority.ALWAYS);
        this.texts.setAlignment(Pos.CENTER_LEFT);
        this.title.setMinHeight(Double.NEGATIVE_INFINITY);
        this.subtitle.setMinHeight(Double.NEGATIVE_INFINITY);
        this.root.setAlignment(Pos.CENTER_LEFT);
        this.root.setPadding(new Insets(8.0, 16.0, 8.0, 16.0));
        Node deviceIcon = FxIcons.icon(FxIcons.MONITOR((Paint)Color.BLACK, (Paint)Color.BLACK), 28.0, 28.0);
        this.root.getChildren().addAll((Object[])new Node[]{deviceIcon, this.texts, this.spacer, this.badge, this.menu});
    }

    public void bind(OwnedDevice item, boolean empty) {
        this.ownedDevice = item;
        if (empty || item == null) {
            this.title.setText(null);
            this.subtitle.setText(null);
            this.badge.setVisible(false);
            this.badge.setManaged(false);
            return;
        }
        this.title.setText(item.getDisplayNameOrDeviceHexName());
        this.subtitle.setText(item.isCurrentDevice() ? ViewControllerHelper.getString("actual_device") : ViewControllerHelper.getString("last_activity", item.getLastRegistrationTimestamp().map(ts -> DateUtils.formatRelativeDateAndTime(DateUtils.of(ts))).orElse(ViewControllerHelper.getString("never"))));
        boolean expiring = item.getExpirationTimestamp().isPresent();
        if (expiring) {
            LocalDateTime deactivationDate = DateUtils.of(item.getExpirationTimestamp().get());
            this.badge.setText(ViewControllerHelper.getString("device_deactivates_on", DateUtils.formatRelativeDateAndTime(deactivationDate)));
        }
        this.badge.setVisible(expiring);
        this.badge.setManaged(expiring);
    }

    private List<MenuItem> buildMenuItems() {
        ArrayList<MenuItem> out = new ArrayList<MenuItem>();
        out.add((MenuItem)DeviceRowView.ctx("rename_action", List.of("svg-edit"), () -> AsyncTaskExecutor.submitTask(() -> {
            if (this.onRenameDeviceCallback != null) {
                this.onRenameDeviceCallback.accept(this.ownedDevice);
            }
        })));
        if (this.ownedDevice.getExpirationTimestamp().isPresent() && !this.multidevice.get()) {
            out.add((MenuItem)DeviceRowView.ctx("select_as_long_term_service", List.of("svg-star"), () -> AsyncTaskExecutor.submitTask(() -> this.confirmModal(ViewControllerHelper.getString("select_as_long_term_service_confirm_modal_title"), ViewControllerHelper.getString("select_as_long_term_service_confirm_modal_description"), FxIcons.STAR((Paint)Color.BLACK, null), () -> Api.getDeviceApi().setUnexpiringOwnedDevice(((OwnedIdentityInfo)this.ownedIdentityInfoObjectProperty.get()).bytesOwnedIdentity(), this.ownedDevice.getBytesDeviceUid()), ConfirmModalController.BadgeKind.PRIMARY, ViewControllerHelper.getString("modal.confirm")))));
        }
        if (!this.ownedDevice.isCurrentDevice()) {
            out.add((MenuItem)DeviceRowView.ctx("recreate_channel_action", List.of("svg-user"), () -> AsyncTaskExecutor.submitTask(() -> this.confirmModal(ViewControllerHelper.getString("recreate_channel_action_confirm_modal_title"), ViewControllerHelper.getString("recreate_channel_action_confirm_modal_description"), FxIcons.PLAY_CIRCLE((Paint)Color.BLACK, null), () -> Api.getDeviceApi().recreateOwnedDeviceChannel(((OwnedIdentityInfo)this.ownedIdentityInfoObjectProperty.get()).bytesOwnedIdentity(), this.ownedDevice.getBytesDeviceUid(), this.ownedDevice.isCurrentDevice()), ConfirmModalController.BadgeKind.PRIMARY, ViewControllerHelper.getString("recreate_channel_action_confirm_modal_title")))));
            out.add((MenuItem)DeviceRowView.ctx("remove_device_action", List.of("svg-trash1", "danger-text"), () -> AsyncTaskExecutor.submitTask(() -> this.confirmModal(ViewControllerHelper.getString("remove_device_action_confirm_modal_title"), ViewControllerHelper.getString("remove_device_action_confirm_modal_description"), FxIcons.TRASH((Paint)Color.RED, null), () -> Api.getDeviceApi().deactivateOwnedDevice(((OwnedIdentityInfo)this.ownedIdentityInfoObjectProperty.get()).bytesOwnedIdentity(), this.ownedDevice.getBytesDeviceUid()), ConfirmModalController.BadgeKind.DANGER, ViewControllerHelper.getString("remove_device_action_confirm_modal_title")))));
        }
        return out;
    }

    private void confirmModal(String title, String description, FxIcons.IconDef icon, Runnable onValidCallback, ConfirmModalController.BadgeKind badge, String validButton) {
        ConfirmModalController confirmModal = new ConfirmModalController(450.0);
        String validBtnLabel = validButton;
        String cancelBtnLabel = ViewControllerHelper.getString("modal.cancel");
        String confirmButtonClass = "primary-button";
        switch (badge) {
            case PRIMARY: {
                confirmButtonClass = "primary-button";
                break;
            }
            case DANGER: 
            case WARNING: {
                confirmButtonClass = "warning-button";
            }
        }
        List<ConfirmModalController.ConfirmationAction> actions = List.of(ConfirmModalController.ConfirmationAction.of(validBtnLabel, List.of(confirmButtonClass), onValidCallback).asDefault(), ConfirmModalController.ConfirmationAction.of(cancelBtnLabel, List.of("button-outline"), () -> {}).asCancel());
        confirmModal.configure(title, description, FxIcons.icon(icon, 20.0, 20.0), actions);
        confirmModal.setBadgeKind(badge);
        NCRegistry.getUIActionNC().postNotification(ModalNotification.of(confirmModal, false));
    }

    private static ContextMenuItem ctx(String i18nKey, List<String> icons, Runnable action) {
        return new ContextMenuItem(ViewControllerHelper.getString(i18nKey), Optional.of("body-1"), action, icons, 400.0);
    }

    public void setOnRenameDeviceCallback(Consumer<OwnedDevice> callback) {
        this.onRenameDeviceCallback = callback;
    }
}

