/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.components;

import java.util.Locale;
import java.util.function.UnaryOperator;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextFormatter;

public class KeyTextInputField
extends TextArea {
    public static final String NO_ALPHA_NUM = "[^A-Za-z0-9]";

    public KeyTextInputField(boolean editable) {
        this.setEditable(editable);
        UnaryOperator separatorFormatter = change -> {
            if (!change.isContentChange()) {
                return change;
            }
            if (change.getControlText().substring(change.getRangeStart(), change.getRangeEnd()).equals(" ")) {
                change.setRange(change.getRangeStart() - 1, change.getRangeEnd());
            }
            String newTextBeforeSpace = change.getText().replaceAll(NO_ALPHA_NUM, "").toUpperCase(Locale.ROOT);
            int start = change.getRangeStart();
            String rangeText = KeyTextInputField.createStringWithSpace(newTextBeforeSpace, start);
            int newCaretPosition = start + rangeText.length();
            if (change.getRangeEnd() == change.getControlText().length() - 1) {
                change.setText(rangeText);
                change.setCaretPosition(newCaretPosition);
                change.setAnchor(newCaretPosition);
                return change;
            }
            String newTextAfter = change.getControlText().substring(change.getRangeEnd()).replaceAll(NO_ALPHA_NUM, "");
            String afterText = KeyTextInputField.createStringWithSpace(newTextAfter, newCaretPosition);
            change.setText(rangeText + afterText);
            change.setRange(start, change.getControlText().length());
            change.setCaretPosition(newCaretPosition);
            change.setAnchor(newCaretPosition);
            return change;
        };
        this.setTextFormatter(new TextFormatter(separatorFormatter));
    }

    private static String createStringWithSpace(String newTextBeforeSpace, int start) {
        StringBuilder textWithSpaceBuilder = new StringBuilder();
        for (int i = 0; i < newTextBeforeSpace.length(); ++i) {
            if (0 == (textWithSpaceBuilder.length() + 1 + start) % 5) {
                textWithSpaceBuilder.append(" ");
            }
            textWithSpaceBuilder.append(newTextBeforeSpace.charAt(i));
        }
        return textWithSpaceBuilder.toString();
    }
}

