/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.components;

import io.olvid.windows.messenger.fx.settings.components.AbstractSettingItemView;
import java.util.Optional;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.util.StringConverter;

public class ComboSettingItemView<Combo extends ComboItem>
extends AbstractSettingItemView {
    public final ComboBox<Combo> comboBox = new ComboBox();

    public ComboSettingItemView(ObservableList<Combo> items, Optional<Combo> current) {
        this.comboBox.setItems(items);
        this.comboBox.setValue((Object)current.orElse(null));
        this.comboBox.setConverter(new StringConverter<Combo>(this){

            public String toString(ComboItem item) {
                return item == null ? "" : item.title();
            }

            public Combo fromString(String string) {
                throw new IllegalStateException();
            }
        });
        this.comboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                this.logger.trace("ComboSettingItemView::selectedItemPropertyListener combo box selection listener null");
                return;
            }
            this.logger.trace("ComboSettingItemView::selectedItemPropertyListener combo box selection listener : " + String.valueOf(newValue));
            newValue.update();
        });
        this.setSettingControl((Control)this.comboBox);
    }

    public static interface ComboItem {
        public String title();

        public void update();
    }

    public record EffectiveCombo(ObservableList<ComboItem> items, Optional<ComboItem> currents) {
    }
}

