/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.backups.security;

import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.confirmation.ConfirmationModalController;
import io.olvid.windows.messenger.fx.settings.backups.BackupSettingsViewModel;
import io.olvid.windows.messenger.fx.settings.backups.ErrorModalController;
import io.olvid.windows.messenger.fx.settings.backups.security.SecurityViewContext;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import javafx.scene.input.MouseEvent;

public class ResetKeyConfirmationModalController
extends ConfirmationModalController {
    final boolean compromised;
    final BackupSettingsViewModel model;
    final SecurityViewContext context;

    public ResetKeyConfirmationModalController(boolean compromised, BackupSettingsViewModel backupSettingsViewModel, SecurityViewContext context) {
        this.compromised = compromised;
        this.model = backupSettingsViewModel;
        this.context = context;
        this.confirmationModalHeaderLabel.setText(ViewControllerHelper.getString("backup_reset_title_label"));
        String textId = compromised ? "backup_compromised_key_reset_confirmation_text" : "backup_reset_key_confirmation_text";
        this.modalContentText.setText(ViewControllerHelper.getString(textId));
        this.validateButton.getStyleClass().remove((Object)"primary-button");
        this.validateButton.getStyleClass().add((Object)"warning-button");
        this.validateButton.setText(compromised ? ViewControllerHelper.getString("backup_key_reset_my_key_button_label") : ViewControllerHelper.getString("backup_key_reset_button_label"));
    }

    @Override
    protected void onValidateClicked(MouseEvent mouseEvent) {
        this.logger.debug("ResetKeyConfirmationModalController::onValidateClicked resetting");
        boolean resetState = this.model.deleteDeviceBackupSeed();
        this.logger.debug("ResetKeyConfirmationModalController::onValidateClicked reset complete");
        if (this.compromised) {
            this.logger.debug("ResetKeyConfirmationModalController::onValidateClicked compromised reset,regeneration needed");
            resetState |= this.model.generateDeviceBackupSeed();
        }
        if (resetState) {
            this.logger.debug("ResetKeyConfirmationModalController::onValidateClicked reset complete");
            this.model.seedProperty.setValue(null);
        } else {
            NCRegistry.getUIActionNC().postNotification(ModalNotification.of(new ErrorModalController(ViewControllerHelper.getString("backup_key_reset_reset_failed_label"), null), false));
            this.logger.error("ResetKeyConfirmationModalController::onValidateClicked reset complete");
        }
        this.context.pushState(SecurityViewContext.MainState.of(resetState));
        this.closeModalDelegate.run();
    }

    @Override
    protected void onCancelClicked(MouseEvent mouseEvent) {
        this.context.pushState(SecurityViewContext.MainState.of(false));
        super.onCancelClicked(mouseEvent);
    }
}

