/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.backups.security;

import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.BaseModalController;
import io.olvid.windows.messenger.fx.modal.ModalConfiguration;
import io.olvid.windows.messenger.fx.settings.backups.BackupSettingsViewModel;
import io.olvid.windows.messenger.fx.settings.backups.KeyDisplayController;
import io.olvid.windows.messenger.fx.settings.backups.security.ISecurityViewState;
import io.olvid.windows.messenger.fx.settings.backups.security.ResetKeyConfirmationModalController;
import io.olvid.windows.messenger.fx.settings.backups.security.SecurityViewContext;
import io.olvid.windows.messenger.fx.settings.components.ButtonSettingItemView;
import io.olvid.windows.messenger.livedata.LiveDataListener;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;

public class BackupSecurityModalController
extends BaseModalController {
    public final VBox rootContainer = new VBox();
    public final HBox header = new HBox();
    public final Label title = new Label(ViewControllerHelper.getString("backup_security_button_label"));
    public final Region sep = new Region();
    public final SvgSizeable closeIcon = new SvgSizeable();
    public final StackPane closeIconContainer = new StackPane();
    public final Region headerVSep = new Region();
    public final ButtonSettingItemView showKeyButton = new ButtonSettingItemView("backup_button_show_key_label");
    public final ButtonSettingItemView compromisedKeyButton = new ButtonSettingItemView("backup_button_compromised_key_label");
    public final VBox upperSecurityButtonsContainer = new VBox();
    public final ButtonSettingItemView resetButton = new ButtonSettingItemView("backup_key_reset_button_label");
    public final Label eraseDisclaimerLabel = new Label(ViewControllerHelper.getString("backup_key_deletion_disclaimer"));
    private final SecurityViewContext context = new SecurityViewContext();
    final LiveDataListener<ISecurityViewState> contextLdListener = this::SecurityViewContextListener;
    final BackupSettingsViewModel model;

    public BackupSecurityModalController(BackupSettingsViewModel model) {
        this.model = model;
        this.title.getStyleClass().addAll((Object[])new String[]{"h1", "black-text"});
        this.title.setAlignment(Pos.CENTER);
        this.title.setTextAlignment(TextAlignment.CENTER);
        Region rightSep = new Region();
        Region leftSep = new Region();
        HBox.setHgrow((Node)rightSep, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)leftSep, (Priority)Priority.ALWAYS);
        this.closeIcon.getStyleClass().addAll((Object[])new String[]{"svg-close", "icon-medium", "hand-hoverable"});
        this.closeIconContainer.getChildren().addAll((Object[])new Node[]{this.closeIcon});
        this.closeIconContainer.setAlignment(Pos.CENTER_RIGHT);
        this.closeIconContainer.setOnMouseClicked(event -> this.closeModalDelegate.run());
        this.header.getChildren().addAll((Object[])new Node[]{leftSep, this.title, rightSep, this.closeIconContainer});
        this.header.setPadding(new Insets(16.0, 8.0, 8.0, 8.0));
        this.setSize(ModalConfiguration.ModalSize.SELF_SIZE);
        this.headerVSep.setMaxHeight(1.0);
        this.headerVSep.setPrefHeight(1.0);
        this.headerVSep.getStyleClass().add((Object)"separator");
        this.showKeyButton.setOnMouseClicked(event -> this.context.pushState(SecurityViewContext.ShowKeyState.of(model.seedProperty)));
        this.showKeyButton.settingLabel.getStyleClass().addAll((Object[])new String[]{"black-text"});
        this.showKeyButton.getStyleClass().addAll((Object[])new String[]{"clickable-setting-item-round-up"});
        this.compromisedKeyButton.setOnMouseClicked(event -> this.context.pushState(SecurityViewContext.CompromisedState.of()));
        this.compromisedKeyButton.settingLabel.getStyleClass().addAll((Object[])new String[]{"black-text"});
        this.compromisedKeyButton.getStyleClass().addAll((Object[])new String[]{"clickable-setting-item-round-down"});
        this.upperSecurityButtonsContainer.setSpacing(12.0);
        this.upperSecurityButtonsContainer.getStyleClass().addAll((Object[])new String[]{"setting-left-background", "round-pane"});
        this.upperSecurityButtonsContainer.setPadding(new Insets(16.0, 32.0, 16.0, 32.0));
        this.upperSecurityButtonsContainer.getChildren().addAll((Object[])new Node[]{this.showKeyButton, this.headerVSep, this.compromisedKeyButton});
        this.eraseDisclaimerLabel.getStyleClass().addAll((Object[])new String[]{"body-2", "black-text"});
        this.eraseDisclaimerLabel.setTextAlignment(TextAlignment.LEFT);
        this.eraseDisclaimerLabel.setAlignment(Pos.CENTER_LEFT);
        this.eraseDisclaimerLabel.setWrapText(true);
        HBox securityLabelContainer = new HBox(new Node[]{this.eraseDisclaimerLabel});
        securityLabelContainer.setAlignment(Pos.CENTER_LEFT);
        securityLabelContainer.setPadding(new Insets(-24.0, 0.0, 0.0, 4.0));
        this.resetButton.getStyleClass().addAll((Object[])new String[]{"setting-left-background", "round-pane", "clickable-setting-item-round-full"});
        this.resetButton.settingLabel.getStyleClass().removeAll((Object[])new String[]{"black-text"});
        this.resetButton.settingLabel.getStyleClass().addAll((Object[])new String[]{"error-text"});
        this.resetButton.chevronContainer.setVisible(false);
        this.resetButton.setPadding(new Insets(0.0, 24.0, 0.0, 24.0));
        this.resetButton.setPrefHeight(50.0);
        this.resetButton.setOnMouseClicked(actionEvent -> this.context.pushState(SecurityViewContext.ResetState.of()));
        this.rootContainer.getStylesheets().addAll((Object[])new String[]{"fx/modal/settings/settings.css"});
        this.rootContainer.setPadding(new Insets(0.0, 12.0, 0.0, 12.0));
        this.rootContainer.setPrefWidth(350.0);
        this.rootContainer.setMinWidth(350.0);
        this.rootContainer.setMaxWidth(350.0);
        this.rootContainer.setMaxHeight(400.0);
        this.rootContainer.setMinHeight(400.0);
        this.rootContainer.setMaxHeight(400.0);
        this.rootContainer.getStyleClass().addAll((Object[])new String[]{"modal-contextual-background", "round-pane"});
        this.rootContainer.setSpacing(24.0);
        this.rootContainer.setAlignment(Pos.TOP_CENTER);
        this.rootContainer.getChildren().addAll((Object[])new Node[]{this.header, this.upperSecurityButtonsContainer, this.resetButton, securityLabelContainer});
        this.bindSceneProperty();
    }

    private void SecurityViewContextListener(ISecurityViewState newValue, ISecurityViewState oldValue) {
        ISecurityViewState iSecurityViewState = newValue;
        Objects.requireNonNull(iSecurityViewState);
        ISecurityViewState iSecurityViewState2 = iSecurityViewState;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SecurityViewContext.CompromisedState.class, SecurityViewContext.ResetState.class, SecurityViewContext.MainState.class, SecurityViewContext.ShowKeyState.class}, (Object)iSecurityViewState2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                SecurityViewContext.CompromisedState ignored1 = (SecurityViewContext.CompromisedState)iSecurityViewState2;
                NCRegistry.getUIActionNC().postNotification(ModalNotification.of(new ResetKeyConfirmationModalController(true, this.model, this.context), false));
                break;
            }
            case 1: {
                SecurityViewContext.ResetState ignored = (SecurityViewContext.ResetState)iSecurityViewState2;
                NCRegistry.getUIActionNC().postNotification(ModalNotification.of(new ResetKeyConfirmationModalController(false, this.model, this.context), false));
                break;
            }
            case 2: {
                SecurityViewContext.MainState mainState = (SecurityViewContext.MainState)iSecurityViewState2;
                if (!mainState.reset()) break;
                this.closeModalDelegate.run();
                break;
            }
            case 3: {
                SecurityViewContext.ShowKeyState showKeyState = (SecurityViewContext.ShowKeyState)iSecurityViewState2;
                NCRegistry.getUIActionNC().postNotification(ModalNotification.of(new KeyDisplayController(showKeyState.key()), false));
            }
        }
    }

    @Override
    public void onLayoutAttached() {
        super.onLayoutAttached();
        this.context.getCurrentStateLiveData().addListener(this.contextLdListener);
    }

    @Override
    public void onLayoutDetached() {
        super.onLayoutDetached();
        this.context.getCurrentStateLiveData().removeListener(this.contextLdListener);
    }

    @Override
    public Region getLayout() {
        return this.rootContainer;
    }
}

