/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.backups.management;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.fx.custom_components.custom_context_menu.ContextMenuFactory;
import io.olvid.windows.messenger.fx.custom_components.custom_context_menu.ContextMenuItem;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.settings.backups.BackupSettingsViewModel;
import io.olvid.windows.messenger.fx.settings.backups.management.DeleteProfileSnapshotConfirmationController;
import io.olvid.windows.messenger.livedata.info.backup.ProfileBackupsInfo;
import io.olvid.windows.messenger.misc.DateUtils;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import io.olvid.windows.messenger.start_up.AppRuntimeHelper;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class ProfileBackupSnapshotCell
extends AbstractListCell<ProfileBackupsInfo> {
    public final HBox rootContainer = new HBox();
    public final SvgSizeable deviceIcon = new SvgSizeable();
    public final StackPane deviceIconContainer = new StackPane();
    public final VBox detailsContainer = new VBox();
    public final Label date = new Label();
    public final Label deviceOriginator = new Label();
    public final Label contactAndGroupCount = new Label();
    public final VBox moreButtonContainer = new VBox();
    public final SvgSizeable iconMore = new SvgSizeable();
    public final Button iconContainer = new Button();
    private Optional<BackupSettingsViewModel> local;

    public ProfileBackupSnapshotCell(boolean showOptionIcon, Optional<BackupSettingsViewModel> model) {
        this.deviceIconContainer.getChildren().addAll((Object[])new Node[]{this.deviceIcon});
        this.deviceIconContainer.setAlignment(Pos.CENTER);
        this.deviceIconContainer.getStyleClass().addAll((Object[])new String[]{"white-pane", "round-pane"});
        this.deviceIconContainer.setMinHeight(50.0);
        this.deviceIconContainer.setMinWidth(50.0);
        this.iconMore.getStyleClass().addAll((Object[])new String[]{"svg-menu", "icon-medium", "icon-black"});
        this.iconContainer.setGraphic((Node)this.iconMore);
        this.iconContainer.getStyleClass().addAll((Object[])new String[]{"full-transparent-icon-button"});
        this.moreButtonContainer.setAlignment(Pos.TOP_CENTER);
        Region moreSep = new Region();
        VBox.setVgrow((Node)moreSep, (Priority)Priority.ALWAYS);
        this.moreButtonContainer.getChildren().addAll((Object[])new Node[]{this.iconContainer, moreSep});
        this.date.getStyleClass().addAll((Object[])new String[]{"body-1-bold", "black-text"});
        this.deviceOriginator.getStyleClass().addAll((Object[])new String[]{"body-2"});
        this.contactAndGroupCount.getStyleClass().addAll((Object[])new String[]{"body-2"});
        this.detailsContainer.getChildren().addAll((Object[])new Node[]{this.date, this.deviceOriginator, this.contactAndGroupCount});
        this.detailsContainer.setAlignment(Pos.CENTER_LEFT);
        Region sep = new Region();
        HBox.setHgrow((Node)sep, (Priority)Priority.ALWAYS);
        HBox.setMargin((Node)this.detailsContainer, (Insets)new Insets(12.0, 0.0, 12.0, 0.0));
        HBox.setMargin((Node)this.moreButtonContainer, (Insets)new Insets(12.0, 12.0, 12.0, 0.0));
        HBox.setMargin((Node)this.deviceIconContainer, (Insets)new Insets(12.0, 12.0, 12.0, 12.0));
        this.getStylesheets().addAll((Object[])new String[]{"fx/modal/settings/settings.css"});
        this.rootContainer.getStyleClass().addAll((Object[])new String[]{"setting-left-background", "round-pane"});
        this.rootContainer.setAlignment(Pos.CENTER_LEFT);
        if (showOptionIcon) {
            this.local = model;
            this.getStyleClass().addAll((Object[])new String[]{"list-view-spaced-cell"});
            this.rootContainer.getChildren().addAll((Object[])new Node[]{this.deviceIconContainer, this.detailsContainer, sep, this.moreButtonContainer});
        } else {
            this.getStyleClass().addAll((Object[])new String[]{"list-view-spaced-cell", "profile-snapshot-list-cell"});
            this.rootContainer.getChildren().addAll((Object[])new Node[]{this.deviceIconContainer, this.detailsContainer});
        }
    }

    @Override
    protected void updateItem(ProfileBackupsInfo item, boolean empty) {
        super.updateItem(item, empty);
        if (item == null || empty) {
            this.deviceOriginator.setText(null);
            this.contactAndGroupCount.setText(null);
            this.date.setText(null);
            this.deviceIcon.getStyleClass().removeAll((Object[])new String[]{"icon-mobile-device", "icon-desktop-device", "icon-xlarge", "icon-black"});
            this.setGraphic(null);
            return;
        }
        this.iconMore.setOnMouseClicked(event -> ContextMenuFactory.loadContextMenuWithScreenCoordinates(event.getScreenX(), event.getScreenY(), this.getMenuItems(item)));
        MessageFormat fromMessageFormat = new MessageFormat(ViewControllerHelper.getString("backup_profile_snapshot_from_device_label"));
        if (item.deviceName().isPresent()) {
            this.deviceOriginator.setText(fromMessageFormat.format(new String[]{item.deviceName().get()}));
        } else {
            this.deviceOriginator.setText(fromMessageFormat.format(new String[]{"Unnamed"}));
        }
        if (item.platform().isPresent()) {
            AppRuntimeHelper.OlvidPlatforms interpretedOptional;
            String platform = item.platform().get();
            try {
                interpretedOptional = AppRuntimeHelper.OlvidPlatforms.valueOf(platform.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.logger.warning("ProfileBackupSnapshotCell::updateItem couldn't interpret desktop platform --> unknown platform");
                interpretedOptional = AppRuntimeHelper.OlvidPlatforms.UNKNOWN;
            }
            switch (interpretedOptional) {
                case IPHONE: 
                case IPAD: 
                case ANDROID: {
                    this.deviceIcon.getStyleClass().setAll((Object[])new String[]{"icon-mobile-device", "icon-xlarge", "icon-grey"});
                    StackPane.setMargin((Node)this.deviceIcon, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
                    break;
                }
                case MAC: 
                case WINDOWS: 
                case LINUX: 
                case BOT: 
                case UNKNOWN: {
                    this.deviceIcon.getStyleClass().setAll((Object[])new String[]{"icon-desktop-device", "icon-xlarge", "icon-grey"});
                    StackPane.setMargin((Node)this.deviceIcon, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
                }
            }
        }
        MessageFormat groupContactCountMessageFormat = new MessageFormat(ViewControllerHelper.getString("backup_profile_snapshot_group_contact_count_label"));
        this.contactAndGroupCount.setText(groupContactCountMessageFormat.format(new String[]{Integer.toString(item.groupCount()), Integer.toString(item.contactCount())}));
        LocalDateTime time = DateUtils.of(item.timestamp());
        String format = DateUtils.formatRelativeDate(time);
        this.date.setText(format);
        this.setGraphic((Node)this.rootContainer);
    }

    private List<MenuItem> getMenuItems(ProfileBackupsInfo profileBackupsInfo) {
        if (this.local.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        ContextMenuItem deleteAction = new ContextMenuItem(ViewControllerHelper.getString("delete_action"), Optional.of("body-1"), () -> AsyncTaskExecutor.submitTask(() -> NCRegistry.getUIActionNC().postNotification(ModalNotification.of(DeleteProfileSnapshotConfirmationController.of(this.local.orElse(null), profileBackupsInfo), false))), Collections.emptyList(), 100.0);
        items.add((MenuItem)deleteAction);
        return items;
    }
}

