/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.backups.management;

import io.olvid.windows.messenger.engine.sync.ProfilePictureKey;
import io.olvid.windows.messenger.fx.custom_components.bubbles.BubbleUtils;
import io.olvid.windows.messenger.fx.custom_components.bubbles.IdentityBubble;
import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.generic_types.list_view.AbstractListCell;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.livedata.info.IdentityDetailsInfo;
import io.olvid.windows.messenger.livedata.info.backup.DeviceBackupInfo;
import io.olvid.windows.messenger.misc.Either;
import io.olvid.windows.messenger.misc.StringUtils;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class DeviceBackupListCell
extends AbstractListCell<DeviceBackupInfo> {
    public final HBox rootContainer = new HBox();
    public final IdentityBubble identityBubble = new IdentityBubble(25.0);
    public final VBox detailsContainer = new VBox();
    public final Label firstNameLastName = new Label();
    public final Label positionCompany = new Label();
    public final Label knownProfileLabel = new Label(ViewControllerHelper.getString("backup_profile_already_active"));
    public final SvgSizeable iconChevron = new SvgSizeable();
    public final StackPane iconContainer = new StackPane(new Node[]{this.iconChevron});
    public final StackPane chevronOrLabel = new StackPane(new Node[]{this.knownProfileLabel, this.iconContainer});
    public final BooleanProperty knownProfileProp = new SimpleBooleanProperty(false);

    public DeviceBackupListCell(boolean disableIfActive) {
        this.iconChevron.getStyleClass().addAll((Object[])new String[]{"svg-chevron", "icon-medium", "icon-black"});
        this.knownProfileLabel.getStyleClass().addAll((Object[])new String[]{"body-2", "danger-text"});
        this.firstNameLastName.getStyleClass().addAll((Object[])new String[]{"body-1"});
        this.positionCompany.getStyleClass().addAll((Object[])new String[]{"body-2"});
        this.detailsContainer.getChildren().addAll((Object[])new Node[]{this.firstNameLastName, this.positionCompany});
        this.detailsContainer.setAlignment(Pos.CENTER_LEFT);
        Region sep = new Region();
        HBox.setHgrow((Node)sep, (Priority)Priority.ALWAYS);
        this.rootContainer.getStyleClass().addAll((Object[])new String[]{"setting-left-background", "round-pane"});
        HBox.setMargin((Node)this.identityBubble, (Insets)new Insets(12.0, 12.0, 12.0, 12.0));
        HBox.setMargin((Node)this.detailsContainer, (Insets)new Insets(12.0, 0.0, 12.0, 0.0));
        HBox.setMargin((Node)this.chevronOrLabel, (Insets)new Insets(12.0, 12.0, 12.0, 0.0));
        this.getStylesheets().addAll((Object[])new String[]{"fx/modal/settings/settings.css"});
        this.getStyleClass().addAll((Object[])new String[]{"list-view-spaced-cell"});
        if (disableIfActive) {
            this.knownProfileLabel.visibleProperty().bind((ObservableValue)this.knownProfileProp);
            this.iconContainer.visibleProperty().bind((ObservableValue)this.knownProfileProp.not());
            this.disableProperty().bind((ObservableValue)this.knownProfileProp);
        } else {
            this.knownProfileLabel.setVisible(false);
        }
        this.rootContainer.getChildren().addAll((Object[])new Node[]{this.identityBubble, this.detailsContainer, sep, this.chevronOrLabel});
    }

    @Override
    protected void updateItem(DeviceBackupInfo item, boolean empty) {
        super.updateItem(item, empty);
        if (item == null || empty) {
            BubbleUtils.resetBubbleData(this.identityBubble);
            this.firstNameLastName.setText(null);
            this.positionCompany.setText(null);
            this.setGraphic(null);
            return;
        }
        IdentityDetailsInfo identityDetailsInfo = new IdentityDetailsInfo(item.identityDetails());
        this.firstNameLastName.setText(identityDetailsInfo.getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST));
        this.positionCompany.setText(identityDetailsInfo.getDisplayName(IdentityDetailsInfo.Format.POSITION_COMPANY));
        this.identityBubble.setInitial(StringUtils.firstChar(identityDetailsInfo.getDisplayName(IdentityDetailsInfo.Format.FIRST_LAST)));
        this.identityBubble.setColorByteSource(item.ownedIdentityBytes().byteArray());
        if (item.profilePicInfo().isPresent()) {
            Either<String, ProfilePictureKey> relativePathOrPictureKey = item.profilePicInfo().get();
            if (relativePathOrPictureKey.isLeft()) {
                this.identityBubble.setPhotoUrlRelPath(Optional.of(relativePathOrPictureKey.getLeft()));
            } else {
                this.logger.debug("DeviceBackupListCell::updateItem profile picture key --> %s", relativePathOrPictureKey.getRight());
                this.identityBubble.setProfilePictureKey(Optional.of(relativePathOrPictureKey.getRight()));
            }
        } else {
            this.identityBubble.setPhotoUrlRelPath(Optional.empty());
            this.identityBubble.setProfilePictureKey(Optional.empty());
        }
        this.identityBubble.setKeycloakManaged(item.keycloakManaged());
        this.knownProfileProp.set(item.profileAlreadyPresent());
        this.setGraphic((Node)this.rootContainer);
    }
}

