/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.backups.management;

import io.olvid.windows.messenger.async.AsyncTaskExecutor;
import io.olvid.windows.messenger.engine.api.Api;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.modal.confirmation.ConfirmationModalController;
import io.olvid.windows.messenger.fx.settings.backups.BackupSettingsViewModel;
import io.olvid.windows.messenger.livedata.info.backup.DeviceBackupInfo;
import io.olvid.windows.messenger.livedata.info.backup.ProfileBackupsInfo;
import javafx.scene.input.MouseEvent;

public class DeleteProfileSnapshotConfirmationController
extends ConfirmationModalController {
    private final BackupSettingsViewModel model;
    private final ProfileBackupsInfo profileBackupsInfo;

    public static DeleteProfileSnapshotConfirmationController of(BackupSettingsViewModel model, ProfileBackupsInfo profileBackupsInfo) {
        return new DeleteProfileSnapshotConfirmationController(model, profileBackupsInfo);
    }

    public DeleteProfileSnapshotConfirmationController(BackupSettingsViewModel model, ProfileBackupsInfo profileBackupsInfo) {
        this.model = model;
        this.profileBackupsInfo = profileBackupsInfo;
        this.confirmationModalHeaderLabel.setText(ViewControllerHelper.getString("backup_reset_title_label"));
        this.modalContentText.setText(ViewControllerHelper.getString("backup_management_delete_profile_snapshot_confirmation_text"));
        this.modalContentText.getStyleClass().addAll((Object[])new String[]{"body-1", "black-text"});
        this.validateButton.getStyleClass().remove((Object)"primary-button");
        this.validateButton.getStyleClass().addAll((Object[])new String[]{"warning-button"});
        this.validateButton.setText(ViewControllerHelper.getString("button_label_validate"));
    }

    @Override
    protected void onValidateClicked(MouseEvent mouseEvent) {
        AsyncTaskExecutor.submitTask(() -> {
            this.validateButton.setDisable(true);
            if (Api.getBackupApi().deleteProfileBackupSnapshot(((DeviceBackupInfo)this.model.selectedDeviceBackupInfo.get()).ownedIdentityBytes().byteArray(), ((DeviceBackupInfo)this.model.selectedDeviceBackupInfo.get()).profileBackupSeed(), this.profileBackupsInfo.threadId().byteArray(), this.profileBackupsInfo.version())) {
                this.model.fetchProfileBackupList(((DeviceBackupInfo)this.model.selectedDeviceBackupInfo.get()).ownedIdentityBytes(), ((DeviceBackupInfo)this.model.selectedDeviceBackupInfo.get()).profileBackupSeed());
                this.closeModalDelegate.run();
            } else {
                this.validateButton.setDisable(false);
            }
        });
    }
}

