/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.windows.messenger.fx.settings.backups;

import io.olvid.windows.messenger.fx.custom_components.icon.SvgSizeable;
import io.olvid.windows.messenger.fx.framework.view_controller.BaseViewController;
import io.olvid.windows.messenger.fx.helpers.ViewControllerHelper;
import io.olvid.windows.messenger.fx.misc.richtextfx.RichStyledArea;
import io.olvid.windows.messenger.fx.misc.richtextfx.utils.RichStyledConfiguration;
import io.olvid.windows.messenger.fx.settings.backups.BackupSettingsViewModel;
import io.olvid.windows.messenger.fx.settings.backups.ErrorModalController;
import io.olvid.windows.messenger.fx.settings.backups.KeyDisplayController;
import io.olvid.windows.messenger.fx.settings.backups.management.BackupSettingConfiguredView;
import io.olvid.windows.messenger.fx.settings.backups.management.backup_management_display.BackupManagementViewController;
import io.olvid.windows.messenger.fx.settings.backups.security.BackupSecurityModalController;
import io.olvid.windows.messenger.fx.settings.backups.setup.BackupConfigurationChoiceModalController;
import io.olvid.windows.messenger.fx.settings.backups.setup.BackupSettingsUnconfiguredView;
import io.olvid.windows.messenger.misc.notification_pattern.concrete_notifications.ModalNotification;
import io.olvid.windows.messenger.misc.notification_pattern.notification_centers.NCRegistry;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;

public class BackupSettingsViewController
extends BaseViewController {
    public final VBox rootContainer = new VBox();
    public final SvgSizeable cloudIcon = new SvgSizeable();
    public final StackPane iconContainer = new StackPane();
    public final Label title = new Label();
    public final RichStyledArea description = new RichStyledArea(RichStyledConfiguration.style());
    public final VBox headerContainer = new VBox();
    public final BackupSettingsUnconfiguredView backupSettingsUnconfiguredView = new BackupSettingsUnconfiguredView();
    public final BackupSettingConfiguredView backupSettingConfiguredView = new BackupSettingConfiguredView();
    private final BackupSettingsViewModel backupSettingsViewModel;

    public BackupSettingsViewController(BackupSettingsViewModel model) {
        this.backupSettingsViewModel = model;
        this.cloudIcon.getStyleClass().addAll((Object[])new String[]{"icon-backup", "icon-large", "icon-green-keycloak"});
        this.iconContainer.getChildren().addAll((Object[])new Node[]{this.cloudIcon});
        this.title.setText(ViewControllerHelper.getString("your_backups_headers_title_label"));
        this.title.getStyleClass().addAll((Object[])new String[]{"h1-bold"});
        this.description.setMaxWidth(553.0);
        this.description.replaceText(ViewControllerHelper.getString("backup_settings_global_description_text"));
        this.description.setTextAlignment(TextAlignment.CENTER);
        this.description.setEditable(false);
        this.headerContainer.getChildren().addAll((Object[])new Node[]{this.iconContainer, this.title, this.description});
        this.headerContainer.setMaxWidth(553.0);
        this.headerContainer.setMinHeight(266.0);
        this.headerContainer.setAlignment(Pos.CENTER);
        this.headerContainer.setSpacing(16.0);
        this.headerContainer.getStyleClass().addAll((Object[])new String[]{"setting-left-background", "rounded-background-pane"});
        VBox.setMargin((Node)this.iconContainer, (Insets)new Insets(28.0, 0.0, 0.0, 0.0));
        VBox.setMargin((Node)this.title, (Insets)new Insets(0.0, 32.0, 0.0, 32.0));
        VBox.setMargin((Node)this.description, (Insets)new Insets(0.0, 32.0, 32.0, 32.0));
        this.backupSettingsUnconfiguredView.setMinHeight(224.0);
        this.backupSettingsUnconfiguredView.visibleProperty().bind((ObservableValue)this.backupSettingsViewModel.seedProperty.isNull());
        this.backupSettingsUnconfiguredView.managedProperty().bind((ObservableValue)this.backupSettingsUnconfiguredView.visibleProperty());
        this.backupSettingsUnconfiguredView.advancedSettingItem.setOnMouseClicked(event -> NCRegistry.getUIActionNC().postNotification(ModalNotification.of(new BackupConfigurationChoiceModalController(this.backupSettingsViewModel), false)));
        this.backupSettingsUnconfiguredView.enableAutomaticBackupButton.setOnMouseClicked(event -> {
            if (this.backupSettingsViewModel.generateDeviceBackupSeed()) {
                NCRegistry.getUIActionNC().postNotification(ModalNotification.of(new KeyDisplayController(this.backupSettingsViewModel.seedProperty), false));
            } else {
                NCRegistry.getUIActionNC().postNotification(ModalNotification.of(new ErrorModalController(ViewControllerHelper.getString("backup_seed_generation_failed"), null), false));
            }
        });
        this.backupSettingConfiguredView.visibleProperty().bind((ObservableValue)this.backupSettingsViewModel.seedProperty.isNotNull());
        this.backupSettingConfiguredView.managedProperty().bind((ObservableValue)this.backupSettingConfiguredView.visibleProperty());
        this.backupSettingConfiguredView.manageOlvidBackupsButton.setOnMouseClicked(event -> NCRegistry.getUIActionNC().postNotification(ModalNotification.of(new BackupManagementViewController(this.backupSettingsViewModel), false)));
        this.backupSettingConfiguredView.generateBackupNowButton.setOnMouseClicked(event -> model.generateBackupNow());
        this.backupSettingConfiguredView.generateBackupNowButton.ringProgressIndicator.visibleProperty().bind((ObservableValue)model.dataStateProp.isEqualTo((Object)BackupManagementViewController.BackupManagementDataState.BACKUP_NOW_IN_PROGRESS));
        this.backupSettingConfiguredView.securityButton.setOnMouseClicked(actionEvent -> NCRegistry.getUIActionNC().postNotification(ModalNotification.of(new BackupSecurityModalController(this.backupSettingsViewModel), false)));
        this.rootContainer.setAlignment(Pos.TOP_CENTER);
        this.rootContainer.setSpacing(24.0);
        this.rootContainer.getChildren().addAll((Object[])new Node[]{this.headerContainer, this.backupSettingsUnconfiguredView, this.backupSettingConfiguredView});
        this.bindSceneProperty();
    }

    @Override
    public Region getLayout() {
        return this.rootContainer;
    }

    @Override
    public void onLayoutAttached() {
    }

    @Override
    public void onLayoutDetached() {
    }
}

